/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers.torbox;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import jakarta.annotation.PreDestroy;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.NotImplementedException;
import org.javers.common.collections.Lists;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.NewznabCategoryComputer;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.indexers.QueryGenerator;
import org.nzbhydra.indexers.SearchRequestIdConverter;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.indexers.exceptions.IndexerNoIdConversionPossibleException;
import org.nzbhydra.indexers.exceptions.IndexerParsingException;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.indexers.torbox.Torbox;
import org.nzbhydra.indexers.torbox.mapping.TorboxResult;
import org.nzbhydra.indexers.torbox.mapping.TorboxResultType;
import org.nzbhydra.indexers.torbox.mapping.TorboxSearchResponse;
import org.nzbhydra.mapping.AgeToPubDateConverter;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="torbox")
@Scope(value="prototype")
public class Torbox
extends Indexer<UsenetAndTorrentResponse> {
    private static final Logger log = LoggerFactory.getLogger(Torbox.class);
    private static final Map<MediaIdType, String> ID_TYPE_MAP = new HashMap();
    public static final Set<MediaIdType> SUPPORTED_MEDIA_ID_TYPES = Set.of(MediaIdType.IMDB, MediaIdType.TMDB, MediaIdType.TVMAZE, MediaIdType.TVIMDB);
    @Autowired
    private SearchRequestIdConverter searchRequestIdConverter;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);
    private final QueryGenerator queryGenerator;

    public Torbox(QueryGenerator queryGenerator) {
        this.queryGenerator = queryGenerator;
    }

    protected void completeIndexerSearchResult(UsenetAndTorrentResponse response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        indexerSearchResult.setTotalResultsKnown(true);
        indexerSearchResult.setTotalResults(response.torrent().getData().getTotalTorrents() + response.usenet.getData().getTotalNzbs());
        indexerSearchResult.setHasMoreResults(false);
        indexerSearchResult.setOffset(0);
        indexerSearchResult.setPageSize(indexerSearchResult.getTotalResults());
    }

    protected List<SearchResultItem> getSearchResultItems(UsenetAndTorrentResponse searchRequestResponse, SearchRequest searchRequest) throws IndexerParsingException {
        ArrayList<SearchResultItem> items = new ArrayList<SearchResultItem>();
        List allResults = Lists.join((List)searchRequestResponse.usenet().getData().getNzbs(), (List)searchRequestResponse.torrent().getData().getTorrents());
        for (TorboxResult result : allResults) {
            SearchResultItem searchResultItem = new SearchResultItem();
            searchResultItem.setDownloadType(DownloadType.TORBOX);
            searchResultItem.setTitle(result.getRawTitle());
            searchResultItem.setIndexer((Indexer)this);
            searchResultItem.setSize(Long.valueOf(result.getSize()));
            searchResultItem.setAgePrecise(false);
            searchResultItem.setPubDate(AgeToPubDateConverter.convertToInstant((String)result.getAge()));
            if (result.getLastKnownSeeders() > -1) {
                searchResultItem.setSeeders(Integer.valueOf(result.getLastKnownSeeders()));
            }
            if (result.getLastKnownPeers() > -1) {
                searchResultItem.setPeers(Integer.valueOf(result.getLastKnownPeers()));
            }
            List<Integer> newznabCategories = result.getCategories().stream().map(Integer::valueOf).toList();
            ((NewznabCategoryComputer)NzbHydra.getApplicationContext().getBean(NewznabCategoryComputer.class)).computeCategory(searchResultItem, newznabCategories, this.config);
            searchResultItem.setIndexerScore(Integer.valueOf(this.config.getScore()));
            searchResultItem.setIndexerGuid(String.valueOf(result.getHash()));
            if (result.getNzb() != null) {
                searchResultItem.setLink(result.getNzb());
            } else if (result.getMagnet() != null || result.getTorrent() != null) {
                if (result.getMagnet() != null) {
                    searchResultItem.setLink(result.getMagnet());
                } else {
                    searchResultItem.setLink(result.getTorrent());
                }
            } else {
                this.error("Result " + result.getRawTitle() + " has neither nzb nor magnet or torrent");
                continue;
            }
            items.add(searchResultItem);
        }
        return items;
    }

    protected UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, Integer offset, Integer limit) throws IndexerSearchAbortedException {
        throw new NotImplementedException();
    }

    protected IndexerSearchResult buildSearchUrlAndCall(SearchRequest searchRequest, int offset, Integer limit) throws IndexerAccessException {
        this.searchRequestIdConverter.convertSearchIdsIfNeeded(searchRequest, this.config);
        Stopwatch stopwatch = Stopwatch.createStarted();
        Future<TorboxSearchResponse> usenetFuture = this.executorService.submit(() -> this.buildAndCall(searchRequest, TorboxResultType.USENET));
        Future<TorboxSearchResponse> torrentFuture = this.executorService.submit(() -> this.buildAndCall(searchRequest, TorboxResultType.TORRENT));
        Optional usenetResponse = this.getResultWithTimeout(usenetFuture);
        Optional torrentResponse = this.getResultWithTimeout(torrentFuture);
        if (usenetResponse.isEmpty() && torrentResponse.isEmpty()) {
            throw new IndexerAccessException("Usenet and torrent search failed");
        }
        UsenetAndTorrentResponse response = new UsenetAndTorrentResponse(usenetResponse.orElse(new TorboxSearchResponse()), torrentResponse.orElse(new TorboxSearchResponse()));
        return this.processSearchResponse(searchRequest, offset, limit, stopwatch, (Object)response);
    }

    private TorboxSearchResponse buildAndCall(SearchRequest searchRequest, TorboxResultType searchType) throws IndexerSearchAbortedException, IndexerAccessException {
        UriComponentsBuilder builder = this.buildSearchUrl(searchRequest, searchType);
        URI url = builder.build().toUri();
        this.info("Calling {}", new Object[]{url.toString()});
        TorboxSearchResponse usenetResponse = (TorboxSearchResponse)this.getAndStoreResultToDatabase(url, TorboxSearchResponse.class, IndexerApiAccessType.SEARCH);
        return usenetResponse;
    }

    private UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, TorboxResultType type) throws IndexerSearchAbortedException {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)"https://search-api.torbox.app");
        if (type == TorboxResultType.TORRENT) {
            builder.pathSegment(new String[]{"torznab"});
        } else {
            builder.pathSegment(new String[]{"newznab"});
        }
        boolean idSearch = false;
        for (MediaIdType idType : SUPPORTED_MEDIA_ID_TYPES) {
            if (!searchRequest.getIdentifiers().containsKey(idType)) continue;
            idSearch = true;
            Object idValue = (String)searchRequest.getIdentifiers().get(idType);
            if (idType == MediaIdType.IMDB && !((String)idValue).startsWith("tt")) {
                idValue = "tt" + (String)idValue;
            }
            builder.pathSegment(new String[]{(String)ID_TYPE_MAP.get(idType) + ":" + (String)idValue});
            break;
        }
        if (!idSearch) {
            builder.pathSegment(new String[]{"search"});
            String query = this.queryGenerator.generateQueryIfApplicable(searchRequest, "", (Indexer)this);
            this.verifyIdentifiersNotUnhandled(searchRequest, builder, query);
            builder.path(query);
        } else {
            if (searchRequest.getSeason().isPresent()) {
                builder.queryParam("season", new Object[]{searchRequest.getSeason().get()});
            }
            if (searchRequest.getEpisode().isPresent()) {
                builder.queryParam("episode", new Object[]{searchRequest.getEpisode().get()});
            }
        }
        builder.queryParam("metadata", new Object[]{"false"});
        return builder;
    }

    private void verifyIdentifiersNotUnhandled(SearchRequest searchRequest, UriComponentsBuilder componentsBuilder, String query) throws IndexerNoIdConversionPossibleException {
        String currentUriString = componentsBuilder.toUriString();
        boolean noIdsOrIdWithNull = ID_TYPE_MAP.values().stream().noneMatch(currentUriString::contains);
        if (Strings.isNullOrEmpty((String)query) && !searchRequest.getIdentifiers().isEmpty() && noIdsOrIdWithNull) {
            throw new IndexerNoIdConversionPossibleException("Aborting searching for indexer because no usable search IDs could be found and no query was generated");
        }
    }

    public NfoResult getNfo(String guid) {
        return null;
    }

    protected UsenetAndTorrentResponse getAndStoreResultToDatabase(URI uri, IndexerApiAccessType apiAccessType) throws IndexerAccessException {
        return (UsenetAndTorrentResponse)this.getAndStoreResultToDatabase(uri, UsenetAndTorrentResponse.class, apiAccessType);
    }

    protected Logger getLogger() {
        return log;
    }

    private <T> Optional<T> getResultWithTimeout(Future<T> future) {
        try {
            int timeoutSeconds = 90;
            return Optional.of(future.get(timeoutSeconds, TimeUnit.SECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Error searching torbox", (Throwable)e);
            return Optional.empty();
        }
    }

    @PreDestroy
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    static {
        ID_TYPE_MAP.put(MediaIdType.IMDB, "imdb_id");
        ID_TYPE_MAP.put(MediaIdType.TVIMDB, "imdb_id");
        ID_TYPE_MAP.put(MediaIdType.TMDB, "tmdb_id");
        ID_TYPE_MAP.put(MediaIdType.TVMAZE, "tvmaze_id");
    }
}

