/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers.torznab;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.nzbhydra.NzbHydraException;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.indexers.Newznab;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.mapping.newznab.xml.NewznabAttribute;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlChannel;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlItem;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlRoot;
import org.nzbhydra.mapping.newznab.xml.Xml;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.SearchResultIdCalculator;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="torznab")
@Scope(value="prototype")
public class Torznab
extends Newznab {
    private static final Logger logger = LoggerFactory.getLogger(Torznab.class);

    protected SearchResultItem createSearchResultItem(NewznabXmlItem item) throws NzbHydraException {
        item.getRssGuid().setPermaLink(true);
        SearchResultItem searchResultItem = super.createSearchResultItem(item);
        searchResultItem.setGrabs(item.getGrabs());
        searchResultItem.setIndexerGuid(item.getRssGuid().getGuid());
        for (NewznabAttribute attribute : item.getTorznabAttributes()) {
            searchResultItem.getAttributes().put(attribute.getName(), attribute.getValue());
            switch (attribute.getName()) {
                case "grabs": {
                    searchResultItem.setGrabs(Integer.valueOf(attribute.getValue()));
                    break;
                }
                case "guid": {
                    searchResultItem.setIndexerGuid(attribute.getValue());
                    break;
                }
                case "seeders": {
                    searchResultItem.setSeeders(Integer.valueOf(attribute.getValue()));
                    break;
                }
                case "peers": {
                    searchResultItem.setPeers(Integer.valueOf(attribute.getValue()));
                }
            }
        }
        if (item.getSize() != null) {
            searchResultItem.setSize(item.getSize());
        } else if (item.getTorznabAttributes().stream().noneMatch(x -> x.getName().equals("size"))) {
            searchResultItem.getAttributes().put("size", String.valueOf(item.getSize()));
        }
        List foundCategories = this.tryAndGetCategoryAsNumber(item);
        if (!foundCategories.isEmpty()) {
            this.newznabCategoryComputer.computeCategory(searchResultItem, foundCategories, this.config);
        } else {
            searchResultItem.setCategory(this.categoryProvider.getNotAvailable());
        }
        searchResultItem.setHasNfo(SearchResultItem.HasNfo.NO);
        searchResultItem.setIndexerScore(Integer.valueOf(this.config.getScore()));
        searchResultItem.setDownloadType(DownloadType.TORRENT);
        searchResultItem.setGuid(Long.valueOf(SearchResultIdCalculator.calculateSearchResultId((SearchResultItem)searchResultItem)));
        searchResultItem.setDetails(item.getComments());
        return searchResultItem;
    }

    protected List<Integer> tryAndGetCategoryAsNumber(NewznabXmlItem item) {
        HashSet<Integer> foundCategories = new HashSet<Integer>();
        if (item.getCategory() != null) {
            try {
                foundCategories.add(Integer.parseInt(item.getCategory()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        foundCategories.addAll(item.getNewznabAttributes().stream().filter(x -> x.getName().equals("category")).map(x -> Integer.valueOf(x.getValue())).toList());
        foundCategories.addAll(item.getTorznabAttributes().stream().filter(x -> x.getName().equals("category")).map(x -> Integer.valueOf(x.getValue())).toList());
        return new ArrayList<Integer>(foundCategories);
    }

    protected String addForbiddenWords(SearchRequest searchRequest, String query) {
        return query;
    }

    protected void completeIndexerSearchResult(Xml response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        NewznabXmlChannel rssChannel = ((NewznabXmlRoot)response).getRssChannel();
        super.completeIndexerSearchResult(response, indexerSearchResult, acceptorResult, searchRequest, offset, limit);
        indexerSearchResult.setTotalResultsKnown(true);
        indexerSearchResult.setHasMoreResults(false);
        indexerSearchResult.setOffset(0);
        indexerSearchResult.setTotalResults(rssChannel.getItems().size());
        indexerSearchResult.setPageSize(10000);
    }

    protected UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, Integer offset, Integer limit) throws IndexerSearchAbortedException {
        return super.buildSearchUrl(searchRequest, null, null);
    }

    protected void calculateAndAddCategories(SearchRequest searchRequest, UriComponentsBuilder componentsBuilder) {
        if (!this.configProvider.getBaseConfig().getSearching().isSendTorznabCategories()) {
            logger.debug("Not adding categories to query");
            return;
        }
        super.calculateAndAddCategories(searchRequest, componentsBuilder);
    }

    protected List<String> getEnclosureTypes() {
        return List.of("application/x-bittorrent", "application/x-bittorrent;x-scheme-handler/magnet");
    }

    protected Logger getLogger() {
        return logger;
    }
}

