/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.FileAppender;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nzbhydra.Jackson;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.logging.LogContentProvider;
import org.nzbhydra.logging.ReversedLinesFileReader;
import org.nzbhydra.logging.SensitiveDataRemovingPatternLayoutEncoder;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogContentProvider {
    public long getLogFileSize() throws IOException {
        File logfile = this.getCurrentLogfile(false);
        if (logfile == null) {
            throw new IOException("Unable to determine log file");
        }
        if (!logfile.exists()) {
            throw new IOException("Determined log file does not exist");
        }
        return logfile.length();
    }

    public String getLog() throws IOException {
        File logfile = this.getCurrentLogfile(false);
        if (logfile == null) {
            throw new IOException("Unable to determine log file");
        }
        if (!logfile.exists()) {
            throw new IOException("Determined log file does not exist");
        }
        long logFileSizeMb = logfile.length() / 0x100000L;
        if (logFileSizeMb > 256L) {
            throw new IOException("Log file " + String.valueOf(logfile) + " is " + logFileSizeMb + "MB and therefore too large to handle");
        }
        return new String(Files.readAllBytes(logfile.toPath()));
    }

    public List<String> getLogFileNames() {
        File[] logFiles = new File(NzbHydra.getDataFolder(), "logs").listFiles();
        if (logFiles == null) {
            return Collections.emptyList();
        }
        return Stream.of(logFiles).sorted(Comparator.comparingLong(File::lastModified).reversed()).map(File::getName).filter(name -> name.toLowerCase().endsWith("log")).collect(Collectors.toList());
    }

    public JsonLogResponse getLogsAsJsonLines(int offset, int limit) throws IOException {
        String line;
        File logfile = this.getCurrentLogfile(true);
        if (logfile == null) {
            throw new IOException("Unable to determine log file");
        }
        if (!logfile.exists()) {
            throw new IOException("Determined log file does not exist");
        }
        ArrayList<HashMap> objects = new ArrayList<HashMap>();
        int count = 0;
        try (ReversedLinesFileReader reversedLinesFileReader = new ReversedLinesFileReader(logfile, Charset.defaultCharset());){
            line = reversedLinesFileReader.readLine();
            while (offset > 0 && count++ < offset && line != null) {
                line = reversedLinesFileReader.readLine();
            }
            if (count > 0 && line == null) {
                JsonLogResponse jsonLogResponse = new JsonLogResponse(Collections.emptyList(), false, offset, 0);
                return jsonLogResponse;
            }
            count = 1;
            while (line != null && count++ <= limit) {
                1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
                HashMap o = (HashMap)Jackson.JSON_MAPPER.readValue(line, (TypeReference)typeRef);
                objects.add(o);
                line = reversedLinesFileReader.readLine();
            }
        }
        return new JsonLogResponse(objects, line != null, offset, objects.size());
    }

    public File getCurrentLogfile(boolean getJsonFile) {
        File clientLogFile = new File(new File(NzbHydra.getDataFolder(), "logs"), getJsonFile ? "nzbhydra2-log.json" : "nzbhydra2.log");
        if (clientLogFile.exists()) {
            return clientLogFile;
        }
        FileAppender fileAppender = null;
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        block0: for (Logger logger : context.getLoggerList()) {
            Iterator index = logger.iteratorForAppenders();
            while (index.hasNext()) {
                Object enumElement = index.next();
                if (!(enumElement instanceof FileAppender)) continue;
                FileAppender temp = (FileAppender)enumElement;
                if (getJsonFile) {
                    if (temp.getEncoder().getClass().getName().equals(SensitiveDataRemovingPatternLayoutEncoder.class.getName())) continue;
                    fileAppender = temp;
                    continue block0;
                }
                if (!temp.getEncoder().getClass().getName().equals(SensitiveDataRemovingPatternLayoutEncoder.class.getName())) continue;
                fileAppender = temp;
                continue block0;
            }
        }
        clientLogFile = fileAppender != null ? new File(fileAppender.getFile()) : null;
        return clientLogFile;
    }
}

