/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.logging;

import com.google.common.base.Objects;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

/*
 * Exception performing whole class analysis ignored.
 */
public class MdcThreadPoolExecutor
extends ThreadPoolExecutor {
    private final boolean useFixedContext;
    private final Map<String, String> fixedContext;
    final Instant instantiationTime;

    public static MdcThreadPoolExecutor newWithInheritedMdc(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return new MdcThreadPoolExecutor(null, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public static MdcThreadPoolExecutor newWithInheritedMdc(int corePoolSize) {
        return new MdcThreadPoolExecutor(null, corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    }

    public static MdcThreadPoolExecutor newWithCurrentMdc(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return new MdcThreadPoolExecutor(MDC.getCopyOfContextMap(), corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public static MdcThreadPoolExecutor newWithFixedMdc(Map<String, String> fixedContext, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return new MdcThreadPoolExecutor(fixedContext, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    private MdcThreadPoolExecutor(Map<String, String> fixedContext, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.fixedContext = fixedContext;
        this.useFixedContext = fixedContext != null;
        this.instantiationTime = Instant.now();
    }

    private Map<String, String> getContextForTask() {
        return this.useFixedContext ? this.fixedContext : MDC.getCopyOfContextMap();
    }

    @Override
    public void execute(Runnable command) {
        super.execute(MdcThreadPoolExecutor.wrap((Runnable)command, (Map)this.getContextForTask()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MdcThreadPoolExecutor)) {
            return false;
        }
        MdcThreadPoolExecutor that = (MdcThreadPoolExecutor)o;
        return Objects.equal((Object)this.instantiationTime, (Object)that.instantiationTime);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instantiationTime});
    }

    public static Runnable wrap(Runnable runnable, Map<String, String> context) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

