/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.logging;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.nio.charset.Charset;

public class SensitiveDataRemovingPatternLayoutEncoder
extends PatternLayoutEncoder {
    private Charset charset;

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    private byte[] convertToBytes(String s) {
        if (this.charset == null) {
            return s.getBytes();
        }
        return s.getBytes(this.charset);
    }

    public byte[] encode(ILoggingEvent event) {
        String txt = this.layout.doLayout((Object)event);
        txt = this.removeSensitiveData(txt);
        return this.convertToBytes(txt);
    }

    protected String removeSensitiveData(String txt) {
        return txt.replaceAll("(?i)(r|username|apikey|password)(=|:|%3D)([^&\\s]{2,})", "$1$2<$1>").replaceAll("(\"name\" ?: ?\"apiKey\",(\\s*\"label\": ?\".*\",)?\\s*\"value\" ?: \")([^\"\\s*]*)", "$1<apikey>").replaceAll("(\"name\" ?: ?\"baseUrl\",(\\s*\"label\": ?\".*\",)?\\s*\"value\" ?: \")([^\"\\s*]*)", "$1<url>");
    }
}

