/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.mediainfo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Optional;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.mediainfo.Imdb;
import org.nzbhydra.mediainfo.MediaInfo;
import org.nzbhydra.mediainfo.MovieInfo;
import org.nzbhydra.mediainfo.TmdbSearchResult;
import org.nzbhydra.mediainfo.TvInfo;
import org.nzbhydra.mediainfo.TvMazeSearchResult;

public class MediaInfo {
    private String imdbId;
    private String tmdbId;
    private String tvmazeId;
    private String tvrageId;
    private String tvdbId;
    private String title;
    private Integer year;
    private String posterUrl;

    public Optional<String> getImdbId() {
        return Optional.ofNullable(Imdb.withTt((String)this.imdbId));
    }

    public Optional<String> getTmdbId() {
        return Optional.ofNullable(this.tmdbId);
    }

    public Optional<String> getTvMazeId() {
        return Optional.ofNullable(this.tvmazeId);
    }

    public Optional<String> getTvRageId() {
        return Optional.ofNullable(this.tvrageId);
    }

    public Optional<String> getTvDbId() {
        return Optional.ofNullable(this.tvdbId);
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<Integer> getYear() {
        return Optional.ofNullable(this.year);
    }

    public Optional<String> getPosterUrl() {
        return Optional.ofNullable(this.posterUrl);
    }

    @JsonIgnore
    public Optional<String> getByIdType(MediaIdType idType) {
        return switch (1.$SwitchMap$org$nzbhydra$config$mediainfo$MediaIdType[idType.ordinal()]) {
            case 1, 2 -> this.getImdbId();
            case 3 -> this.getTmdbId();
            case 4 -> this.getTvMazeId();
            case 5 -> this.getTvRageId();
            case 6 -> this.getTvDbId();
            case 7, 8 -> this.getTitle();
            default -> Optional.empty();
        };
    }

    @JsonIgnore
    public boolean isInfoContained(Collection<MediaIdType> types) {
        return types.stream().anyMatch(x -> this.getByIdType(x).isPresent());
    }

    public MediaInfo(TvMazeSearchResult searchResult) {
        this.tvrageId = searchResult.getTvrageId();
        this.tvmazeId = searchResult.getTvmazeId();
        this.tvdbId = searchResult.getTvdbId();
        this.imdbId = Imdb.withTt((String)searchResult.getImdbId());
        this.title = searchResult.getTitle();
        this.year = searchResult.getYear();
        this.posterUrl = searchResult.getPosterUrl();
    }

    public MediaInfo(TmdbSearchResult searchResult) {
        this.imdbId = Imdb.withTt((String)searchResult.getImdbId());
        this.tmdbId = searchResult.getTmdbId();
        this.title = searchResult.getTitle();
        this.year = searchResult.getYear();
        this.posterUrl = searchResult.getPosterUrl();
    }

    public MediaInfo(MovieInfo movieInfo) {
        this.imdbId = movieInfo.getImdbId().orElse(null);
        this.tmdbId = movieInfo.getTmdbId().orElse(null);
        this.title = movieInfo.getTitle().orElse(null);
        this.year = movieInfo.getYear();
        this.posterUrl = movieInfo.getPosterUrl().orElse(null);
    }

    public MediaInfo(TvInfo tvInfo) {
        this.tvrageId = tvInfo.getTvrageId().orElse(null);
        this.tvmazeId = tvInfo.getTvmazeId().orElse(null);
        this.tvdbId = tvInfo.getTvdbId().orElse(null);
        this.imdbId = tvInfo.getImdbId().orElse(null);
        this.title = tvInfo.getTitle();
        this.year = tvInfo.getYear();
        this.posterUrl = tvInfo.getPosterUrl().orElse(null);
    }

    public MediaInfo() {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("imdbId", (Object)this.imdbId).add("tmdbId", (Object)this.tmdbId).add("tvmazeId", (Object)this.tvmazeId).add("tvrageId", (Object)this.tvrageId).add("tvdbId", (Object)this.tvdbId).add("title", (Object)this.title).add("posterUrl", (Object)this.posterUrl).omitNullValues().toString();
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public void setTmdbId(String tmdbId) {
        this.tmdbId = tmdbId;
    }

    public void setTvmazeId(String tvmazeId) {
        this.tvmazeId = tvmazeId;
    }

    public void setTvrageId(String tvrageId) {
        this.tvrageId = tvrageId;
    }

    public void setTvdbId(String tvdbId) {
        this.tvdbId = tvdbId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public void setPosterUrl(String posterUrl) {
        this.posterUrl = posterUrl;
    }
}

