/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.misc;

import java.awt.Desktop;
import java.net.URI;
import org.nzbhydra.web.UrlCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BrowserOpener {
    private static final Logger logger = LoggerFactory.getLogger(BrowserOpener.class);
    @Autowired
    private UrlCalculator urlCalculator;

    public void openBrowser() {
        Desktop desktop;
        URI uri = this.urlCalculator.getLocalBaseUriBuilder().build().toUri();
        try {
            logger.debug("Desktop supported: {}", (Object)Desktop.isDesktopSupported());
            desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        }
        catch (Throwable e) {
            logger.debug("Unable to get desktop", e);
            logger.error("Unable to open browser. Go to {}", (Object)uri, (Object)e);
            return;
        }
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            logger.info("Opening {} in browser", (Object)uri);
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                logger.error("Unable to open browser. Go to {}", (Object)uri, (Object)e);
            }
        } else {
            logger.error("Unable to open browser. Go to {}", (Object)uri);
        }
    }
}

