/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.notifications;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import okhttp3.MediaType;
import org.nzbhydra.Jackson;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.NotificationConfig;
import org.nzbhydra.config.NotificationConfigEntry;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.notifications.NotificationEntity;
import org.nzbhydra.notifications.NotificationEvent;
import org.nzbhydra.notifications.NotificationHandler;
import org.nzbhydra.notifications.NotificationMessageType;
import org.nzbhydra.notifications.NotificationRepository;
import org.nzbhydra.webaccess.WebAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class NotificationHandler {
    private static final Logger logger = LoggerFactory.getLogger(NotificationHandler.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private WebAccess webAccess;
    @Autowired
    private NotificationRepository notificationRepository;

    @EventListener
    public void handleNotification(NotificationEvent event) {
        logger.debug(LoggingMarkers.NOTIFICATIONS, "Retrieved notification event of type {}", (Object)event.getEventType());
        NotificationConfig notificationConfig = this.configProvider.getBaseConfig().getNotificationConfig();
        List<NotificationConfigEntry> configEntries = notificationConfig.getEntries().stream().filter(x -> x.getEventType() == event.getEventType()).toList();
        if (configEntries.isEmpty()) {
            logger.debug(LoggingMarkers.NOTIFICATIONS, "No matching config entries found");
            return;
        }
        for (NotificationConfigEntry configEntry : configEntries) {
            String messageBody;
            logger.debug(LoggingMarkers.NOTIFICATIONS, "Found matching config entry with URLs {} and template {}", (Object)configEntry.getAppriseUrls(), (Object)configEntry.getBodyTemplate());
            String notificationBody = this.fillTemplate(configEntry.getBodyTemplate(), event.getVariablesWithContent());
            String notificationTitle = Strings.isNullOrEmpty((String)configEntry.getTitleTemplate()) ? null : this.fillTemplate(configEntry.getTitleTemplate(), event.getVariablesWithContent());
            boolean isFilteredOut = false;
            for (String filterOut : this.configProvider.getBaseConfig().getNotificationConfig().getFilterOuts()) {
                if (filterOut.startsWith("/") && filterOut.endsWith("/")) {
                    Pattern pattern;
                    String regex = filterOut.substring(1, filterOut.length() - 1);
                    try {
                        pattern = Pattern.compile(regex, 2);
                    }
                    catch (Exception e) {
                        logger.error("Unable to parse regex: {}", (Object)regex);
                        continue;
                    }
                    if (pattern.matcher(notificationBody).find()) {
                        isFilteredOut = true;
                    }
                } else if (notificationBody.toLowerCase().contains(filterOut.toLowerCase())) {
                    isFilteredOut = true;
                }
                if (!isFilteredOut) continue;
                logger.debug(LoggingMarkers.NOTIFICATIONS, "Notification with body matches filter-out \"{}\":\n{}", (Object)filterOut, (Object)notificationBody);
            }
            if (isFilteredOut) continue;
            logger.debug(LoggingMarkers.NOTIFICATIONS, "Sending notification for URLs {} to {} with body:\n{}", new Object[]{configEntry.getAppriseUrls(), notificationConfig.getAppriseApiUrl(), notificationBody});
            try {
                messageBody = Jackson.JSON_MAPPER.writeValueAsString((Object)new AppriseMessage(configEntry.getAppriseUrls(), notificationBody, notificationTitle, configEntry.getMessageType().name().toLowerCase()));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Unable to generate notification body", e);
            }
            this.notificationRepository.save((Object)new NotificationEntity(event.getEventType(), NotificationMessageType.valueOf((String)configEntry.getMessageType().name()), notificationTitle, notificationBody, configEntry.getAppriseUrls(), Instant.now()));
            if (notificationConfig.getAppriseType() == NotificationConfig.AppriseType.NONE) {
                logger.debug(LoggingMarkers.NOTIFICATIONS, "Apprise type set to None");
                return;
            }
            if (configEntry.getAppriseUrls() == null) {
                logger.debug(LoggingMarkers.NOTIFICATIONS, "No Apprise URLs set");
                return;
            }
            if (notificationConfig.getAppriseType() == NotificationConfig.AppriseType.API) {
                this.callAppriseApi(notificationConfig, messageBody);
                continue;
            }
            if (notificationConfig.getAppriseType() == NotificationConfig.AppriseType.CLI) {
                this.callAppriseCli(notificationConfig, configEntry, notificationTitle, notificationBody);
                continue;
            }
            throw new IllegalArgumentException("Unexpected apprise type " + String.valueOf(notificationConfig.getAppriseType()));
        }
    }

    private void callAppriseCli(NotificationConfig notificationConfig, NotificationConfigEntry configEntry, String notificationTitle, String notificationBody) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(notificationConfig.getAppriseCliPath());
        if (notificationTitle != null) {
            commands.add("-t");
            commands.add(notificationTitle.replace("\"", "\\\""));
        }
        commands.add("-b");
        commands.add(notificationBody.replace("\"", "\\\""));
        commands.addAll(Arrays.asList(configEntry.getAppriseUrls().split(",")));
        String commandLine = Joiner.on((String)" ").join(commands);
        logger.debug(LoggingMarkers.NOTIFICATIONS, "Calling apprise command {}", (Object)commandLine);
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                logger.error("Unexpected exit code {} while executing apprise command {}", (Object)exitCode, (Object)commandLine);
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("Unexpected error executing apprise command {}", (Object)commandLine);
        }
    }

    private void callAppriseApi(NotificationConfig notificationConfig, String messageBody) {
        try {
            String notifyUrl = UriComponentsBuilder.fromHttpUrl((String)notificationConfig.getAppriseApiUrl()).path("/notify").toUriString().replace("/notify/notify", "/notify");
            logger.debug(LoggingMarkers.NOTIFICATIONS, "Posting body to {}:\n{}", (Object)notifyUrl, (Object)messageBody);
            this.webAccess.postToUrl(notificationConfig.getAppriseApiUrl(), MediaType.get((String)"application/json"), messageBody, Collections.emptyMap(), 10);
        }
        catch (IOException e) {
            logger.error("Error while sending notification", (Throwable)e);
        }
    }

    private String fillTemplate(String template, Map<String, String> variablesWithContent) {
        for (Map.Entry<String, String> x : variablesWithContent.entrySet()) {
            template = template.replace("$" + x.getKey() + "$", x.getValue());
        }
        return template;
    }
}

