/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.problemdetection;

import com.google.common.base.Stopwatch;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.nzbhydra.debuginfos.DebugInfosProvider;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.problemdetection.ProblemDetector;
import org.nzbhydra.tasks.HydraTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProblemDetectorTask {
    private static final Logger logger = LoggerFactory.getLogger(ProblemDetectorTask.class);
    private static final long HOUR = 3600000L;
    @Autowired
    List<ProblemDetector> problemDetectors;
    @Autowired
    private GenericStorage genericStorage;

    @PostConstruct
    public void init() {
        if (!DebugInfosProvider.isRunInDocker() && !SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)) {
            this.genericStorage.save("belowJava17", (Serializable)Boolean.valueOf(true));
            logger.info("Current Java version is below Java 17: " + SystemUtils.JAVA_SPECIFICATION_VERSION);
        } else {
            this.genericStorage.save("belowJava17", (Serializable)Boolean.valueOf(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HydraTask(configId="ProblemDetector", name="Problem detector", interval=3600000L)
    public void detectProblems() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            for (ProblemDetector problemDetector : this.problemDetectors) {
                logger.debug("Executing problem detector {}", (Object)problemDetector.getClass().getName());
                problemDetector.executeCheck();
                logger.debug("Finished executing problem detector {}", (Object)problemDetector.getClass().getName());
            }
        }
        finally {
            logger.debug(LoggingMarkers.PERFORMANCE, "Check for problems took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

