/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Joiner;
import java.text.Normalizer;
import java.util.List;
import java.util.regex.Pattern;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.searching.AffectedValue;
import org.nzbhydra.config.searching.CustomQueryAndTitleMapping;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.CustomQueryAndTitleMappingHandler;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@RestController
public class CustomQueryAndTitleMappingHandler {
    private static final Logger logger = LoggerFactory.getLogger(CustomQueryAndTitleMappingHandler.class);
    private static final Pattern DIACRITICAL_MARKS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    @Autowired
    private ConfigProvider configProvider;

    public CustomQueryAndTitleMappingHandler() {
    }

    public CustomQueryAndTitleMappingHandler(BaseConfig baseConfig) {
        this.configProvider = new /* Unavailable Anonymous Inner Class!! */;
    }

    public SearchRequest mapSearchRequest(SearchRequest searchRequest) {
        return this.mapSearchRequest(searchRequest, this.configProvider.getBaseConfig().getSearching().getCustomMappings());
    }

    public SearchRequest mapSearchRequest(SearchRequest searchRequest, List<CustomQueryAndTitleMapping> customQueryAndTitleMappings) {
        if (customQueryAndTitleMappings.isEmpty() || customQueryAndTitleMappings.stream().allMatch(x -> x.getAffectedValue() == AffectedValue.RESULT_TITLE)) {
            return searchRequest;
        }
        MetaData metaData = this.mapMetaData(MetaData.fromSearchRequest((SearchRequest)searchRequest), customQueryAndTitleMappings);
        metaData.getQuery().ifPresent(arg_0 -> ((SearchRequest)searchRequest).setQuery(arg_0));
        metaData.getTitle().ifPresent(arg_0 -> ((SearchRequest)searchRequest).setTitle(arg_0));
        return searchRequest;
    }

    public SearchResultItem mapSearchResult(SearchResultItem searchResult, List<CustomQueryAndTitleMapping> customQueryAndTitleMappings) {
        if (customQueryAndTitleMappings.isEmpty() || customQueryAndTitleMappings.stream().noneMatch(x -> x.getAffectedValue() == AffectedValue.RESULT_TITLE)) {
            return searchResult;
        }
        MetaData metaData = this.mapMetaData(MetaData.fromSearchResult((SearchResultItem)searchResult), customQueryAndTitleMappings);
        metaData.getTitle().ifPresent(arg_0 -> ((SearchResultItem)searchResult).setTitle(arg_0));
        return searchResult;
    }

    public static String removeDiacriticalAndUmlauts(String string) {
        return DIACRITICAL_MARKS.matcher(Normalizer.normalize(string, Normalizer.Form.NFD)).replaceAll("").replace("\u00df", "ss").replace("\u2014", "-");
    }

    public MetaData mapMetaData(MetaData metaData, List<CustomQueryAndTitleMapping> customQueryAndTitleMappings) {
        List<CustomQueryAndTitleMapping> relevantMappings;
        String newQuery;
        String oldQuery;
        if (metaData.getQuery().isPresent() && this.configProvider.getBaseConfig().getSearching().isReplaceUmlauts() && !(oldQuery = (String)metaData.getQuery().get()).equals(newQuery = CustomQueryAndTitleMappingHandler.removeDiacriticalAndUmlauts((String)oldQuery))) {
            metaData.setQuery(newQuery);
            logger.debug("Replaced umlauts. Old query: {}. New query: {}", (Object)oldQuery, metaData.getQuery().get());
        }
        if ((relevantMappings = customQueryAndTitleMappings.stream().filter(x -> metaData.getSearchType() == x.getSearchType() || metaData.type == MetaData.Type.RESULT_TITLE).filter(customQueryAndTitleMapping -> this.isDatasetMatch(metaData, customQueryAndTitleMapping)).filter(customQueryAndTitleMapping -> {
            if (customQueryAndTitleMapping.getTo().contains("{season:") && metaData.getSeason().isEmpty()) {
                logger.debug(LoggingMarkers.CUSTOM_MAPPING, "Can't use customQueryAndTitleMapping {} because no season information is available for {}", customQueryAndTitleMapping, (Object)metaData);
                return false;
            }
            if (customQueryAndTitleMapping.getTo().contains("{episode:") && metaData.getEpisode().isEmpty()) {
                logger.debug(LoggingMarkers.CUSTOM_MAPPING, "Can't use customQueryAndTitleMapping {} because no episode information is available for {}", customQueryAndTitleMapping, (Object)metaData);
                return false;
            }
            return true;
        }).toList()).isEmpty()) {
            logger.debug(LoggingMarkers.CUSTOM_MAPPING, "No mappings found matching: {}", (Object)metaData);
            return metaData;
        }
        if (relevantMappings.stream().filter(CustomQueryAndTitleMapping::isMatchAll).count() > 1L) {
            logger.error("Unable to map search request ({}) because multiple customQueryAndTitleMappings which match the whole string match it:\n{}", (Object)metaData, (Object)Joiner.on((String)"\n").join(customQueryAndTitleMappings));
            return metaData;
        }
        for (CustomQueryAndTitleMapping mapping : relevantMappings) {
            this.mapMetaData(metaData, mapping);
        }
        return metaData;
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/customMapping/test"}, method={RequestMethod.POST}, produces={"application/json"})
    public TestResponse testMapping(@RequestBody TestRequest testRequest) {
        MetaData metaData = new MetaData();
        String exampleInput = testRequest.exampleInput;
        if (!(testRequest.mapping.getFromPattern().matcher(exampleInput).matches() && testRequest.mapping.isMatchAll() || testRequest.mapping.getFromPattern().matcher(exampleInput).find() && !testRequest.mapping.isMatchAll())) {
            return new TestResponse(null, null, false);
        }
        testRequest.getMapping().setAffectedValue(AffectedValue.QUERY);
        metaData.setQuery(exampleInput);
        metaData.setSearchType(testRequest.mapping.getSearchType());
        metaData.setSeason(Integer.valueOf(1));
        metaData.setEpisode(Integer.valueOf(2));
        try {
            this.mapMetaData(metaData, testRequest.mapping);
            return new TestResponse((String)metaData.getQuery().get(), null, true);
        }
        catch (Exception e) {
            return new TestResponse(null, e.getMessage(), false);
        }
    }

    protected void mapMetaData(MetaData metaData, CustomQueryAndTitleMapping customQueryAndTitleMapping) {
        if ("<remove>".equals(customQueryAndTitleMapping.getTo())) {
            customQueryAndTitleMapping.setTo("");
        }
        if (customQueryAndTitleMapping.getAffectedValue() == AffectedValue.QUERY && metaData.getQuery().isPresent()) {
            String newQuery = this.mapValue(metaData, customQueryAndTitleMapping, (String)metaData.getQuery().get());
            metaData.setQuery(newQuery);
        } else if ((customQueryAndTitleMapping.getAffectedValue() == AffectedValue.TITLE || customQueryAndTitleMapping.getAffectedValue() == AffectedValue.RESULT_TITLE) && metaData.getTitle().isPresent()) {
            String newTitle = this.mapValue(metaData, customQueryAndTitleMapping, (String)metaData.getTitle().get());
            metaData.setTitle(newTitle);
        }
    }

    private String mapValue(MetaData metaData, CustomQueryAndTitleMapping customQueryAndTitleMapping, String value) {
        logger.debug(LoggingMarkers.CUSTOM_MAPPING, "CustomQueryAndTitleMapping input \"{}\" using dataset \"{}\"", (Object)value, (Object)customQueryAndTitleMapping);
        String mappedValue = value;
        String replacementRegex = customQueryAndTitleMapping.getTo();
        if (metaData.getSeason().isPresent()) {
            replacementRegex = replacementRegex.replace("{season:00}", String.format("%02d", metaData.getSeason().get()));
            replacementRegex = replacementRegex.replace("{season:0}", String.valueOf(metaData.getSeason().get()));
        }
        if (metaData.getEpisode().isPresent()) {
            try {
                Integer episode = (Integer)metaData.getEpisode().get();
                replacementRegex = replacementRegex.replace("{episode:00}", String.format("%02d", episode));
                replacementRegex = replacementRegex.replace("{episode:0}", episode.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            replacementRegex = replacementRegex.replace("{episode}", String.valueOf(metaData.getEpisode().get()));
        }
        replacementRegex = replacementRegex.replaceAll("\\{(?<groupName>[^\\}]*)\\}", "\\$\\{hydra${groupName}\\}");
        logger.debug(LoggingMarkers.CUSTOM_MAPPING, "CustomQueryAndTitleMapping input \"{}\" using replacement regex \"{}\"", (Object)value, (Object)replacementRegex);
        mappedValue = customQueryAndTitleMapping.isMatchAll() ? customQueryAndTitleMapping.getFromPattern().matcher(mappedValue).replaceFirst(replacementRegex) : customQueryAndTitleMapping.getFromPattern().matcher(mappedValue).replaceAll(replacementRegex);
        logger.debug(LoggingMarkers.CUSTOM_MAPPING, "Mapped input \"{}\" to \"{}\"", (Object)value, (Object)mappedValue);
        return mappedValue;
    }

    protected boolean isDatasetMatch(MetaData metaData, CustomQueryAndTitleMapping customQueryAndTitleMapping) {
        if (customQueryAndTitleMapping.getAffectedValue() == AffectedValue.QUERY && metaData.getQuery().isPresent()) {
            if (customQueryAndTitleMapping.isMatchAll()) {
                boolean matches = customQueryAndTitleMapping.getFromPattern().matcher((CharSequence)metaData.getQuery().get()).matches();
                logger.debug(LoggingMarkers.CUSTOM_MAPPING, "Query \"{}\" matches regex \"{}\": {}", new Object[]{metaData.getQuery().get(), customQueryAndTitleMapping.getFromPattern().pattern(), matches});
                return matches;
            }
            boolean found = customQueryAndTitleMapping.getFromPattern().matcher((CharSequence)metaData.getQuery().get()).find();
            logger.debug(LoggingMarkers.CUSTOM_MAPPING, "Query \"{}\" contains regex \"{}\": {}", new Object[]{metaData.getQuery().get(), customQueryAndTitleMapping.getFromPattern().pattern(), found});
            return found;
        }
        if ((customQueryAndTitleMapping.getAffectedValue() == AffectedValue.RESULT_TITLE || customQueryAndTitleMapping.getAffectedValue() == AffectedValue.TITLE) && metaData.getTitle().isPresent()) {
            if (customQueryAndTitleMapping.isMatchAll()) {
                boolean matches = customQueryAndTitleMapping.getFromPattern().matcher((CharSequence)metaData.getTitle().get()).matches();
                logger.debug(LoggingMarkers.CUSTOM_MAPPING, "Title \"{}\" matches regex \"{}\": {}", new Object[]{metaData.getTitle().get(), customQueryAndTitleMapping.getFromPattern().pattern(), matches});
                return matches;
            }
            boolean found = customQueryAndTitleMapping.getFromPattern().matcher((CharSequence)metaData.getTitle().get()).find();
            logger.debug(LoggingMarkers.CUSTOM_MAPPING, "Title \"{}\" contains regex \"{}\": {}", new Object[]{metaData.getTitle().get(), customQueryAndTitleMapping.getFromPattern().pattern(), found});
            return found;
        }
        logger.debug(LoggingMarkers.CUSTOM_MAPPING, "Dataset does not match search request.\nDataset: {}\nSearch request:{}", (Object)customQueryAndTitleMapping.getFrom(), (Object)metaData);
        return false;
    }
}

