/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.dtoseventsenums.DuplicateDetectionResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DuplicateDetector {
    private static final Logger logger = LoggerFactory.getLogger(DuplicateDetector.class);
    @Autowired
    protected ConfigProvider configProvider;

    public DuplicateDetectionResult detectDuplicates(Set<SearchResultItem> results) {
        Map<String, List<SearchResultItem>> groupedByTitle = results.stream().collect(Collectors.groupingBy(x -> x.getTitle().toLowerCase().replaceAll("[ .\\-_]", "")));
        HashMultiset countUniqueResultsPerIndexer = HashMultiset.create();
        ArrayList duplicateGroups = new ArrayList();
        int countDetectedDuplicates = 0;
        for (List<SearchResultItem> list : groupedByTitle.values()) {
            List list2 = list.stream().sorted(Comparator.comparing(SearchResultItem::getBestDate).reversed()).collect(Collectors.toList());
            ArrayList listOfBuckets = new ArrayList();
            listOfBuckets.add(new LinkedHashSet(Lists.newArrayList((Object[])new SearchResultItem[]{(SearchResultItem)list2.get(0)})));
            for (int i = 1; i < list2.size(); ++i) {
                SearchResultItem searchResultItem = (SearchResultItem)list2.get(i);
                boolean foundBucket = false;
                for (LinkedHashSet linkedHashSet : listOfBuckets) {
                    if (linkedHashSet.stream().map(SearchResultItem::getIndexer).toList().contains(searchResultItem.getIndexer())) continue;
                    for (SearchResultItem other : linkedHashSet) {
                        boolean same = this.testForSameness(searchResultItem, other);
                        if (!same) continue;
                        foundBucket = true;
                        linkedHashSet.add(searchResultItem);
                        ++countDetectedDuplicates;
                        break;
                    }
                    if (!foundBucket) continue;
                    break;
                }
                if (foundBucket) continue;
                listOfBuckets.add(new LinkedHashSet(Lists.newArrayList((Object[])new SearchResultItem[]{searchResultItem})));
            }
            LinkedHashSet lastBucket = (LinkedHashSet)Iterables.getLast(listOfBuckets);
            if (lastBucket.size() == 1) {
                countUniqueResultsPerIndexer.add((Object)((SearchResultItem)lastBucket.iterator().next()).getIndexer());
            }
            duplicateGroups.addAll(listOfBuckets);
        }
        int duplicateIdentifier = 0;
        for (LinkedHashSet group : duplicateGroups) {
            for (SearchResultItem x2 : group) {
                x2.setDuplicateIdentifier(duplicateIdentifier);
            }
            ++duplicateIdentifier;
        }
        logger.debug("Duplicate detection for {} search results found {} duplicates", (Object)results.size(), (Object)countDetectedDuplicates);
        return new DuplicateDetectionResult(duplicateGroups, (Multiset)countUniqueResultsPerIndexer, countDetectedDuplicates);
    }

    private boolean testForSameness(SearchResultItem result1, SearchResultItem result2) {
        logger.debug(LoggingMarkers.DUPLICATES, "Comparing {} and {}", (Object)result1, (Object)result2);
        if (result1.getIndexer().equals((Object)result2.getIndexer())) {
            logger.debug(LoggingMarkers.DUPLICATES, "Same indexer");
            return false;
        }
        if (result1.getDownloadType() == DownloadType.TORRENT || result2.getDownloadType() == DownloadType.TORRENT) {
            logger.debug(LoggingMarkers.DUPLICATES, "Torrent download type(s). Type 1: {}. Type 2: {}", (Object)result1.getDownloadType(), (Object)result2.getDownloadType());
            return false;
        }
        boolean groupKnown = result1.getGroup().isPresent() && result2.getGroup().isPresent();
        boolean sameGroup = groupKnown && Objects.equals(result1.getGroup().get(), result2.getGroup().get());
        boolean posterKnown = result1.getPoster().isPresent() && result2.getPoster().isPresent();
        boolean samePoster = posterKnown && Objects.equals(result1.getPoster().get(), result2.getPoster().get());
        float duplicateAgeThreshold = this.configProvider.getBaseConfig().getSearching().getDuplicateAgeThreshold();
        float duplicateSizeThreshold = this.configProvider.getBaseConfig().getSearching().getDuplicateSizeThresholdInPercent();
        if (groupKnown && !sameGroup) {
            logger.debug(LoggingMarkers.DUPLICATES, "Not the same group: {} and {}", result1.getGroup().orElse(null), result2.getGroup().orElse(null));
            return false;
        }
        if (posterKnown && !samePoster) {
            logger.debug(LoggingMarkers.DUPLICATES, "Not the same poster: {} and {}", result1.getPoster().orElse(null), result2.getPoster().orElse(null));
            return false;
        }
        if (sameGroup && !posterKnown || samePoster && !groupKnown) {
            duplicateAgeThreshold *= 2.0f;
            duplicateSizeThreshold *= 2.0f;
        }
        return this.testForDuplicateAge(result1, result2, duplicateAgeThreshold) && this.testForDuplicateSize(result1, result2, duplicateSizeThreshold);
    }

    protected boolean testForDuplicateAge(SearchResultItem result1, SearchResultItem result2, float duplicateAgeThreshold) {
        Instant date1 = result1.getBestDate();
        Instant date2 = result2.getBestDate();
        if (date1 == null || date2 == null) {
            logger.debug(LoggingMarkers.DUPLICATES, "At least one result has no usenet date and no pub date");
            return false;
        }
        boolean isSameAge = (float)(Math.abs(date1.getEpochSecond() - date2.getEpochSecond()) / 3600L) <= duplicateAgeThreshold;
        logger.debug(LoggingMarkers.DUPLICATES, "Same age: {}", (Object)isSameAge);
        return isSameAge;
    }

    private boolean testForDuplicateSize(SearchResultItem result1, SearchResultItem result2, float duplicateSizeDifference) {
        float sizeAverage;
        if (result1.getSize() == null || result2.getSize() == null) {
            return false;
        }
        long sizeDifference = Math.abs(result1.getSize() - result2.getSize());
        float sizeDiffPercent = Math.abs((float)sizeDifference / (sizeAverage = (float)(result1.getSize() + result2.getSize()) / 2.0f)) * 100.0f;
        boolean sameSize = sizeDiffPercent <= duplicateSizeDifference;
        logger.debug(LoggingMarkers.DUPLICATES, "Same size: {}", (Object)sameSize);
        return sameSize;
    }
}

