/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessEntityShort;
import org.nzbhydra.indexers.IndexerApiAccessEntityShortRepository;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.indexers.IndexerHandlingStrategy;
import org.nzbhydra.indexers.IndexerRepository;
import org.nzbhydra.indexers.status.IndexerLimit;
import org.nzbhydra.indexers.status.IndexerLimitRepository;
import org.nzbhydra.searching.IndexerInstantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SearchModuleProvider {
    private static final Logger logger = LoggerFactory.getLogger(SearchModuleProvider.class);
    @Autowired
    private IndexerRepository indexerRepository;
    @Autowired
    private IndexerApiAccessEntityShortRepository shortRepository;
    @Autowired
    private IndexerLimitRepository indexerStatusRepository;
    @Autowired
    private IndexerInstantiator indexerInstantiator;
    private final Map<String, Indexer> searchModuleInstances = new HashMap();
    private final Map<String, Integer> apiHitsToStoreInitially = new HashMap();
    @Autowired
    private List<IndexerHandlingStrategy> indexerHandlingStrategies;

    public List<Indexer> getIndexers() {
        return new ArrayList<Indexer>(this.searchModuleInstances.values());
    }

    public List<Indexer> getEnabledIndexers() {
        return this.searchModuleInstances.values().stream().filter(x -> x.getConfig().getState() == IndexerConfig.State.ENABLED).collect(Collectors.toList());
    }

    public Indexer getIndexerByName(String indexerName) {
        if (this.searchModuleInstances.containsKey(indexerName)) {
            return (Indexer)this.searchModuleInstances.get(indexerName);
        }
        throw new RuntimeException("Unable to find indexer with name " + indexerName);
    }

    @Transactional
    public void loadIndexers(List<IndexerConfig> indexers) {
        if (indexers == null) {
            logger.error("Indexers not set. Check your configuration");
            return;
        }
        logger.info("Loading indexers");
        this.searchModuleInstances.clear();
        for (IndexerConfig config : indexers) {
            try {
                IndexerLimit indexerStatus;
                Optional<IndexerHandlingStrategy> optionalStrategy = this.indexerHandlingStrategies.stream().filter(x -> x.handlesIndexerConfig(config)).findFirst();
                if (optionalStrategy.isEmpty()) {
                    logger.error("Unable to find implementation for indexer type {} and host {}", (Object)config.getSearchModuleType(), (Object)config.getHost());
                    continue;
                }
                Indexer searchModule = this.indexerInstantiator.instantiateIndexer(optionalStrategy.get().getName());
                logger.info("Initializing indexer {}", (Object)config.getName());
                IndexerEntity indexerEntity = this.indexerRepository.findByName(config.getName());
                if (indexerEntity == null) {
                    logger.info("Indexer with name {} not yet in database. Adding it", (Object)config.getName());
                    indexerEntity = new IndexerEntity();
                    indexerEntity.setName(config.getName());
                    indexerEntity = this.indexerRepository.save(indexerEntity);
                    logger.info("Now {} indexers in database", (Object)this.indexerRepository.count());
                }
                if (this.apiHitsToStoreInitially.containsKey(config.getName())) {
                    IndexerEntity finalIndexerEntity = indexerEntity;
                    this.shortRepository.saveAll((Iterable)IntStream.range(0, (Integer)this.apiHitsToStoreInitially.get(config.getName())).mapToObj(x -> new IndexerApiAccessEntityShort(finalIndexerEntity, true, IndexerApiAccessType.SEARCH)).collect(Collectors.toList()));
                    this.apiHitsToStoreInitially.remove(config.getName());
                }
                if ((indexerStatus = this.indexerStatusRepository.findByIndexer(indexerEntity)) == null) {
                    indexerStatus = new IndexerLimit(indexerEntity);
                    this.indexerStatusRepository.save((Object)indexerStatus);
                }
                searchModule.initialize(config, indexerEntity);
                this.searchModuleInstances.put(config.getName(), searchModule);
            }
            catch (Exception e) {
                logger.error("Unable to instantiate indexer with name {} and type {}", new Object[]{config.getName(), config.getSearchModuleType(), e});
            }
        }
        logger.info("Finished initializing active indexers");
        List<String> indexerNames = indexers.stream().map(IndexerConfig::getName).toList();
        if (this.searchModuleInstances.isEmpty()) {
            logger.warn("No indexers configured");
        }
    }

    public void registerApiHitLimits(String indexerName, int hits) {
        this.apiHitsToStoreInitially.put(indexerName, this.apiHitsToStoreInitially.getOrDefault(indexerName, 0) + hits);
    }
}

