/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching.dtoseventsenums;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
public class IndexerSearchResult {
    private Indexer indexer;
    private boolean wasSuccessful = false;
    private String errorMessage;
    private List<SearchResultItem> searchResultItems = new ArrayList();
    private Set<SearchResultEntity> searchResultEntities = new HashSet();
    private int totalResults;
    private int offset;
    private int pageSize;
    private boolean totalResultsKnown;
    private boolean hasMoreResults;
    private long responseTime;
    private Instant time;
    private Multiset<String> reasonsForRejection = HashMultiset.create();

    public IndexerSearchResult() {
    }

    public IndexerSearchResult(Indexer indexer, boolean wasSuccessful) {
        this.wasSuccessful = wasSuccessful;
        this.indexer = indexer;
        this.time = Instant.now();
    }

    public IndexerSearchResult(Indexer indexer, String errorMessage) {
        this.wasSuccessful = false;
        this.indexer = indexer;
        this.time = Instant.now();
        this.errorMessage = errorMessage;
    }

    public List<SearchResultItem> getSearchResultItems() {
        return this.searchResultItems.stream().sorted(Comparator.comparingLong(x -> ((SearchResultItem)x).getBestDate().getEpochSecond()).reversed()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexerSearchResult that = (IndexerSearchResult)o;
        return Objects.equal((Object)this.indexer, (Object)that.indexer) && Objects.equal((Object)this.time, (Object)that.time);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.indexer, this.time});
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public boolean isWasSuccessful() {
        return this.wasSuccessful;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Set<SearchResultEntity> getSearchResultEntities() {
        return this.searchResultEntities;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isTotalResultsKnown() {
        return this.totalResultsKnown;
    }

    public boolean isHasMoreResults() {
        return this.hasMoreResults;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public Instant getTime() {
        return this.time;
    }

    public Multiset<String> getReasonsForRejection() {
        return this.reasonsForRejection;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public void setWasSuccessful(boolean wasSuccessful) {
        this.wasSuccessful = wasSuccessful;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setSearchResultItems(List<SearchResultItem> searchResultItems) {
        this.searchResultItems = searchResultItems;
    }

    public void setSearchResultEntities(Set<SearchResultEntity> searchResultEntities) {
        this.searchResultEntities = searchResultEntities;
    }

    public void setTotalResults(int totalResults) {
        this.totalResults = totalResults;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalResultsKnown(boolean totalResultsKnown) {
        this.totalResultsKnown = totalResultsKnown;
    }

    public void setHasMoreResults(boolean hasMoreResults) {
        this.hasMoreResults = hasMoreResults;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public void setReasonsForRejection(Multiset<String> reasonsForRejection) {
        this.reasonsForRejection = reasonsForRejection;
    }

    public String toString() {
        return "IndexerSearchResult(indexer=" + String.valueOf(this.getIndexer()) + ", wasSuccessful=" + this.isWasSuccessful() + ", errorMessage=" + this.getErrorMessage() + ", searchResultItems=" + String.valueOf(this.getSearchResultItems()) + ", searchResultEntities=" + String.valueOf(this.getSearchResultEntities()) + ", totalResults=" + this.getTotalResults() + ", offset=" + this.getOffset() + ", pageSize=" + this.getPageSize() + ", totalResultsKnown=" + this.isTotalResultsKnown() + ", hasMoreResults=" + this.isHasMoreResults() + ", responseTime=" + this.getResponseTime() + ", time=" + String.valueOf(this.getTime()) + ", reasonsForRejection=" + String.valueOf(this.getReasonsForRejection()) + ")";
    }
}

