/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching.searchrequests;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.SearchSourceRestriction;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.searching.searchrequests.InternalData;
import org.nzbhydra.springnative.ReflectionMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReflectionMarker
public class SearchRequest {
    private static final Logger logger = LoggerFactory.getLogger(SearchRequest.class);
    private static final Pattern EXCLUSION_PATTERN = Pattern.compile("[\\s|\b](\\-\\-|!)(?<term>\\w+)");
    protected Set<String> indexers = null;
    protected SearchSource source;
    protected SearchType searchType = SearchType.SEARCH;
    protected Category category = new Category();
    protected int offset = 0;
    protected int limit;
    protected boolean loadAll;
    protected Integer minsize = null;
    protected Integer maxsize = null;
    protected Integer minage = null;
    protected Integer maxage = null;
    protected String query;
    protected Map<MediaIdType, String> identifiers = new HashMap();
    protected String title;
    protected Integer season;
    protected String episode;
    protected String author = null;
    protected long searchRequestId;
    private DownloadType downloadType = DownloadType.NZB;
    private InternalData internalData = new InternalData();
    protected boolean shortcut = false;

    public SearchRequest(SearchSource source, SearchType searchType, Integer offset, Integer limit) {
        this.source = source;
        this.searchType = searchType;
        this.offset = offset;
        this.limit = limit;
    }

    public Optional<Set<String>> getIndexers() {
        return Optional.ofNullable(this.indexers);
    }

    public Optional<Integer> getMinsize() {
        return Optional.ofNullable(this.minsize);
    }

    public Optional<Integer> getMaxsize() {
        return Optional.ofNullable(this.maxsize);
    }

    public Optional<Integer> getMinage() {
        return Optional.ofNullable(this.minage);
    }

    public Optional<Integer> getMaxage() {
        return Optional.ofNullable(this.maxage);
    }

    public Optional<String> getQuery() {
        return Optional.ofNullable(this.query);
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<Integer> getSeason() {
        return Optional.ofNullable(this.season);
    }

    public Optional<String> getEpisode() {
        return Optional.ofNullable(this.episode);
    }

    public Optional<String> getAuthor() {
        return Optional.ofNullable(this.author);
    }

    public boolean isUpdateQuery() {
        return this.identifiers.isEmpty() && this.query == null;
    }

    public boolean isIdBasedQuery() {
        return !this.identifiers.isEmpty();
    }

    public void setQuery(String query) {
        this.query = query == null ? null : query.trim();
    }

    public SearchRequest extractQueryAndForbiddenWords() {
        if (Strings.isNullOrEmpty((String)this.query)) {
            return this;
        }
        Matcher matcher = EXCLUSION_PATTERN.matcher(this.query);
        HashSet<String> exclusions = new HashSet<String>();
        while (matcher.find()) {
            String match = matcher.group("term");
            exclusions.add(match);
            this.internalData.getRequiredWords().remove(match);
        }
        this.query = matcher.replaceAll("");
        this.internalData.getForbiddenWords().addAll(exclusions);
        if (!exclusions.isEmpty()) {
            logger.debug("Extracted excluded words \"{}\" from query, leaving \"{}\" as qeuery", (Object)Joiner.on((String)", ").join(exclusions), (Object)this.query);
        }
        if (!Strings.isNullOrEmpty((String)this.query)) {
            this.internalData.setQueryWords(List.of(this.query.split(" ")));
        }
        return this;
    }

    public boolean meets(SearchSourceRestriction restriction) {
        if (restriction == SearchSourceRestriction.ALL_BUT_RSS && this.getSource() == SearchSource.API) {
            return this.getQuery().isPresent() || !this.getIdentifiers().isEmpty();
        }
        if (restriction == SearchSourceRestriction.ONLY_RSS && this.getSource() == SearchSource.API) {
            return this.getQuery().isEmpty() && this.getIdentifiers().isEmpty();
        }
        return this.getSource().meets(restriction);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("indexers", (Object)this.indexers).add("searchType", (Object)this.searchType).add("category", (Object)this.category.getName()).add("offset", this.offset).add("limit", this.limit).add("minsize", (Object)this.minsize).add("maxsize", (Object)this.maxsize).add("minage", (Object)this.minage).add("maxage", (Object)this.maxage).add("query", (Object)this.query).add("identifiers", (Object)this.identifiers).add("title", (Object)this.title).add("season", (Object)this.season).add("episode", (Object)this.episode).add("author", (Object)this.author).omitNullValues().toString();
    }

    public String simpleToString() {
        return MoreObjects.toStringHelper((Object)this).add("searchType", (Object)this.searchType).add("category", (Object)this.category.getName()).add("query", (Object)this.query).add("identifiers", (Object)this.identifiers).add("title", (Object)this.title).add("season", (Object)this.season).add("episode", (Object)this.episode).add("author", (Object)this.author).omitNullValues().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRequest that = (SearchRequest)o;
        return this.source == that.source && this.searchType == that.searchType && Objects.equals(this.category, that.category) && Objects.equals(this.minsize, that.minsize) && Objects.equals(this.maxsize, that.maxsize) && Objects.equals(this.minage, that.minage) && Objects.equals(this.maxage, that.maxage) && Objects.equals(this.query, that.query) && Objects.equals(this.identifiers, that.identifiers) && Objects.equals(this.title, that.title) && Objects.equals(this.season, that.season) && Objects.equals(this.episode, that.episode) && Objects.equals(this.author, that.author);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.searchType, this.category, this.minsize, this.maxsize, this.minage, this.maxage, this.query, this.identifiers, this.title, this.season, this.episode, this.author);
    }

    public SearchSource getSource() {
        return this.source;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isLoadAll() {
        return this.loadAll;
    }

    public Map<MediaIdType, String> getIdentifiers() {
        return this.identifiers;
    }

    public long getSearchRequestId() {
        return this.searchRequestId;
    }

    public DownloadType getDownloadType() {
        return this.downloadType;
    }

    public InternalData getInternalData() {
        return this.internalData;
    }

    public boolean isShortcut() {
        return this.shortcut;
    }

    public void setIndexers(Set<String> indexers) {
        this.indexers = indexers;
    }

    public void setSource(SearchSource source) {
        this.source = source;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setLoadAll(boolean loadAll) {
        this.loadAll = loadAll;
    }

    public void setMinsize(Integer minsize) {
        this.minsize = minsize;
    }

    public void setMaxsize(Integer maxsize) {
        this.maxsize = maxsize;
    }

    public void setMinage(Integer minage) {
        this.minage = minage;
    }

    public void setMaxage(Integer maxage) {
        this.maxage = maxage;
    }

    public void setIdentifiers(Map<MediaIdType, String> identifiers) {
        this.identifiers = identifiers;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSeason(Integer season) {
        this.season = season;
    }

    public void setEpisode(String episode) {
        this.episode = episode;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setSearchRequestId(long searchRequestId) {
        this.searchRequestId = searchRequestId;
    }

    public void setDownloadType(DownloadType downloadType) {
        this.downloadType = downloadType;
    }

    public void setInternalData(InternalData internalData) {
        this.internalData = internalData;
    }

    public void setShortcut(boolean shortcut) {
        this.shortcut = shortcut;
    }

    public SearchRequest() {
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }
}

