/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching.uniqueness;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.springnative.ReflectionMarker;

@Entity
@ReflectionMarker
@Table(name="indexeruniquenessscore")
public final class IndexerUniquenessScoreEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @SequenceGenerator(allocationSize=1, name="INDEXERUNIQUENESSSCORE_SEQ")
    private int id;
    @ManyToOne
    @OnDelete(action=OnDeleteAction.CASCADE)
    private IndexerEntity indexer;
    @Column(name="involved")
    private int involved;
    @Column(name="have")
    private int have;
    @Column(name="hasresult")
    private boolean hasResult;

    public IndexerUniquenessScoreEntity() {
    }

    public IndexerUniquenessScoreEntity(IndexerEntity indexer, int involved, int have, boolean hasResult) {
        this.indexer = indexer;
        this.involved = involved;
        this.have = have;
        this.hasResult = hasResult;
    }

    public int getId() {
        return this.id;
    }

    public IndexerEntity getIndexer() {
        return this.indexer;
    }

    public int getInvolved() {
        return this.involved;
    }

    public int getHave() {
        return this.have;
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setIndexer(IndexerEntity indexer) {
        this.indexer = indexer;
    }

    public void setInvolved(int involved) {
        this.involved = involved;
    }

    public void setHave(int have) {
        this.have = have;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexerUniquenessScoreEntity)) {
            return false;
        }
        IndexerUniquenessScoreEntity other = (IndexerUniquenessScoreEntity)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getInvolved() != other.getInvolved()) {
            return false;
        }
        if (this.getHave() != other.getHave()) {
            return false;
        }
        if (this.isHasResult() != other.isHasResult()) {
            return false;
        }
        IndexerEntity this$indexer = this.getIndexer();
        IndexerEntity other$indexer = other.getIndexer();
        return !(this$indexer == null ? other$indexer != null : !this$indexer.equals(other$indexer));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getInvolved();
        result = result * 59 + this.getHave();
        result = result * 59 + (this.isHasResult() ? 79 : 97);
        IndexerEntity $indexer = this.getIndexer();
        result = result * 59 + ($indexer == null ? 43 : $indexer.hashCode());
        return result;
    }

    public String toString() {
        return "IndexerUniquenessScoreEntity(id=" + this.getId() + ", indexer=" + String.valueOf(this.getIndexer()) + ", involved=" + this.getInvolved() + ", have=" + this.getHave() + ", hasResult=" + this.isHasResult() + ")";
    }
}

