/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.systemcontrol;

import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.systemcontrol.SystemControl;
import org.nzbhydra.tasks.HydraTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduledRestartTask {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledRestartTask.class);
    private static final long MINUTE = 60000L;
    private static final String STORAGE_KEY = "ScheduledRestartData";
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("H:mm");
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private SystemControl systemControl;
    @Autowired
    private GenericStorage genericStorage;
    protected Clock clock = Clock.systemDefaultZone();

    @HydraTask(configId="ScheduledRestart", name="Scheduled restart", interval=60000L)
    public void checkForScheduledRestart() {
        LocalTime restartTime;
        Optional scheduledRestartTimeConfig = this.configProvider.getBaseConfig().getMain().getScheduledRestartTime();
        if (scheduledRestartTimeConfig.isEmpty()) {
            logger.trace("No scheduled restart time configured");
            return;
        }
        try {
            restartTime = LocalTime.parse((CharSequence)scheduledRestartTimeConfig.get(), TIME_FORMATTER);
        }
        catch (DateTimeParseException e) {
            logger.error("Invalid scheduled restart time format: {}. Expected HH:mm format.", scheduledRestartTimeConfig.get());
            return;
        }
        LocalTime now = LocalTime.now(this.clock);
        LocalDate today = LocalDate.now(this.clock);
        if (now.getHour() == restartTime.getHour() && now.getMinute() == restartTime.getMinute()) {
            Optional lastRestartDate = this.genericStorage.get(STORAGE_KEY, LocalDate.class);
            if (lastRestartDate.isPresent() && ((LocalDate)lastRestartDate.get()).equals(today)) {
                logger.debug("Scheduled restart already triggered today");
                return;
            }
            logger.info("Triggering scheduled restart at configured time {}", (Object)restartTime);
            this.genericStorage.save(STORAGE_KEY, (Serializable)today);
            this.systemControl.exitWithReturnCode(22);
        }
    }
}

