/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.systemcontrol;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.ShutdownEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class SystemControl {
    private static final Logger logger = LoggerFactory.getLogger(SystemControl.class);
    public static final int SHUTDOWN_RETURN_CODE = 0;
    public static final int UPDATE_RETURN_CODE = 11;
    public static final int RESTART_RETURN_CODE = 22;
    public static final int RESTORE_RETURN_CODE = 33;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void exitWithReturnCode(int returnCode, boolean forceShutdown) {
        if (Boolean.parseBoolean(this.environment.getProperty("hydradontshutdown", "false")) && !forceShutdown) {
            logger.warn("Not shutting down because property hydradontshutdown is set");
            return;
        }
        new Thread(() -> {
            try {
                Path controlIdFilePath = new File(NzbHydra.getDataFolder(), "control.id").toPath();
                logger.debug("Writing control ID {} to {}", (Object)returnCode, (Object)controlIdFilePath);
                Files.write(controlIdFilePath, String.valueOf(returnCode).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error("Unable to write control code to file. Wrapper might not behave as expected");
            }
            try {
                Thread.sleep(300L);
                this.applicationEventPublisher.publishEvent((Object)new ShutdownEvent());
                ((ConfigurableApplicationContext)NzbHydra.getApplicationContext()).close();
                System.exit(returnCode);
            }
            catch (InterruptedException e) {
                logger.error("Error while waiting to exit", (Throwable)e);
            }
        }).start();
    }

    public void exitWithReturnCode(int returnCode) {
        this.exitWithReturnCode(returnCode, false);
    }
}

