/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.web;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.RejectedExecutionHandler;
import org.nzbhydra.web.WebSocketConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration(proxyBeanMethods=false)
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketConfig.class);
    private final ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();

    @PostConstruct
    public void init() {
        this.taskExecutor.setCorePoolSize(2);
        this.taskExecutor.setAllowCoreThreadTimeOut(true);
        this.taskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        this.taskExecutor.setAwaitTerminationSeconds(5);
        this.taskExecutor.setThreadNamePrefix("websocket-");
        this.taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new GracefulShutdownRejectionHandler());
        this.taskExecutor.initialize();
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.enableSimpleBroker(new String[]{"/topic"});
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/websocket"}).setAllowedOriginPatterns(new String[]{"*"}).withSockJS().setClientLibraryUrl("//cdn.jsdelivr.net/sockjs/1.0.3/sockjs.min.js");
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor(this.taskExecutor);
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.taskExecutor(this.taskExecutor);
    }

    @PreDestroy
    public void onShutdown() {
        if (!this.taskExecutor.getThreadPoolExecutor().isShutdown()) {
            this.taskExecutor.shutdown();
        }
    }
}

