/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.webaccess;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.MainConfig;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.webaccess.Ssl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Ssl {
    private static final Logger logger = LoggerFactory.getLogger(Ssl.class);
    private static final Pattern HOST_PATTERN = Pattern.compile("((\\w|\\*)+\\.)?(\\S+\\.\\S+)", 2);
    @Autowired
    private ConfigProvider configProvider;
    private SSLSocketFactory defaultSslSocketFactory;
    private X509TrustManager defaultTrustManager;
    private X509TrustManager customTrustManager;
    private SSLSocketFactory allTrustingSslSocketFactory;
    private X509TrustManager allTrustingDefaultTrustManager = new AllTrustingManager();
    SSLContext caCertsContext;
    SSLContext allTrustingSslContext;

    @PostConstruct
    public void init() {
        this.initSocketFactory(this.configProvider.getBaseConfig().getMain());
    }

    @EventListener
    public void handleConfigChangedEvent(ConfigChangedEvent event) {
        this.initSocketFactory(event.getNewConfig().getMain());
    }

    public String getSupportedCiphers() {
        StringBuilder supportedCiphers = new StringBuilder();
        String[] defaultCiphers = this.defaultSslSocketFactory.getDefaultCipherSuites();
        String[] availableCiphers = this.defaultSslSocketFactory.getSupportedCipherSuites();
        supportedCiphers.append("Available").append("\n");
        for (String availableCipher : availableCiphers) {
            supportedCiphers.append(availableCipher).append("\n");
        }
        supportedCiphers.append("Default").append("\n");
        for (String defaultCipher : defaultCiphers) {
            supportedCiphers.append(defaultCipher).append("\n");
        }
        return supportedCiphers.toString();
    }

    public SslVerificationState getVerificationStateForHost(String host) {
        if (!this.configProvider.getBaseConfig().getMain().isVerifySsl()) {
            logger.debug(LoggingMarkers.HTTPS, "Ignoring SSL certificates because option not to verify SSL is set");
            return SslVerificationState.DISABLED_GLOBALLY;
        }
        if (host != null && this.configProvider.getBaseConfig().getMain().getVerifySslDisabledFor().stream().anyMatch(x -> Ssl.isSameHost((String)host, (String)x))) {
            logger.debug(LoggingMarkers.HTTPS, "Ignoring SSL certificates because option not to verify SSL is set for host {}", (Object)host);
            return SslVerificationState.DISABLED_HOST;
        }
        if (this.configProvider.getBaseConfig().getMain().isDisableSslLocally() && host != null && Ssl.isLocal((String)host)) {
            logger.debug(LoggingMarkers.HTTPS, "Ignoring SSL certificates because host {} is local", (Object)host);
            return SslVerificationState.DISABLED_LOCAL;
        }
        logger.debug(LoggingMarkers.HTTPS, "Not ignoring SSL certificates");
        return SslVerificationState.ENABLED;
    }

    private void initSocketFactory(MainConfig mainConfig) {
        this.loadCacertsAndCustomCerts();
        this.loadAllTrustingTrustManager();
    }

    private void loadAllTrustingTrustManager() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{this.allTrustingDefaultTrustManager};
            this.allTrustingSslContext = SSLContext.getInstance("SSL");
            this.allTrustingSslContext.init(null, trustAllCerts, new SecureRandom());
            this.allTrustingSslSocketFactory = new SniWhitelistingSocketFactory(this, this.allTrustingSslContext.getSocketFactory());
            this.allTrustingDefaultTrustManager = (X509TrustManager)trustAllCerts[0];
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error("Error while creating all-trusting trust manager", (Throwable)e);
        }
    }

    private void loadCacertsAndCustomCerts() {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream keystoreStream = NzbHydra.class.getResource("/cacerts").openStream();
            keystore.load(keystoreStream, null);
            File certificatesFolder = new File(NzbHydra.getDataFolder(), "certificates");
            if (certificatesFolder.exists()) {
                File[] files = certificatesFolder.listFiles();
                logger.info("Loading {} custom certificates", (Object)files.length);
                for (File file : files) {
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(fileInputStream);
                        logger.debug("Loading certificate in file {}", (Object)file);
                        keystore.setCertificateEntry(file.getName(), certificate);
                    }
                }
            }
            TrustManagerFactory customTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            customTrustManagerFactory.init(keystore);
            TrustManager[] trustManagers = customTrustManagerFactory.getTrustManagers();
            this.caCertsContext = SSLContext.getInstance("SSL");
            this.caCertsContext.init(null, trustManagers, null);
            SSLContext.setDefault(this.caCertsContext);
            SSLSocketFactory sslSocketFactory = this.caCertsContext.getSocketFactory();
            this.defaultTrustManager = (X509TrustManager)trustManagers[0];
            this.defaultSslSocketFactory = new SniWhitelistingSocketFactory(this, sslSocketFactory);
        }
        catch (IOException | GeneralSecurityException e) {
            logger.error("Unable to load packaged cacerts file", (Throwable)e);
        }
    }

    public SSLContext getCaCertsContext() {
        return this.caCertsContext;
    }

    public SSLContext getAllTrustingSslContext() {
        return this.allTrustingSslContext;
    }

    public SSLSocketFactory getAllTrustingSslSocketFactory() {
        return this.allTrustingSslSocketFactory;
    }

    public X509TrustManager getAllTrustingDefaultTrustManager() {
        return this.allTrustingDefaultTrustManager;
    }

    public SSLSocketFactory getDefaultSslSocketFactory() {
        return this.defaultSslSocketFactory;
    }

    public X509TrustManager getDefaultTrustManager() {
        return this.defaultTrustManager;
    }

    public static boolean isSameHost(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.equalsIgnoreCase(b)) {
            return true;
        }
        Matcher aMatcher = HOST_PATTERN.matcher(a);
        Matcher bMatcher = HOST_PATTERN.matcher(b);
        if (!aMatcher.matches() || !bMatcher.matches()) {
            return false;
        }
        return aMatcher.group(3).equalsIgnoreCase(bMatcher.group(3));
    }

    private static boolean isLocal(String host) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream in = null;
            keyStore.load(in, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

