angular.module('templates').run(['$templateCache', function($templateCache) {$templateCache.put('static/html/about.html','<!--\n  ~  (C) Copyright 2020 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div class="text-left row d-sm-flex justify-content-center">\n  <div class="col-xs-20 col-md-14">\n    Written by TheOtherP for the community.<br>\n\n    <br>\n    <h3>Program info</h3>\n    <b>Version:</b> {{simpleInfos.currentVersion}}<br>\n    <span ng-if="simpleInfos.packageInfo">\n      <b>Container version:</b> {{simpleInfos.packageInfo.version}}<br>\n      <b>Container release type:</b> {{simpleInfos.packageInfo.releaseType}}<br>\n      <b>Container author:</b> {{simpleInfos.packageInfo.author}}\n    </span>\n\n    <br>\n    <h3>Contact</h3>\n    If you have a question or a feature request I\'d prefer you to create an issue on GitHub.<br>\n    You can <a href="{{  \'https://discord.gg/uh9W3rd\' | dereferer}}">join the Discord channel</a>.<br>\n    If you absolutely must you can reach me via <a href="mailto:theotherp@posteo.net">mail</a> but I really prefer any of the other ways.\n    <br><br>\n    Sources, bugs, enhancements: <a href="{{ \'https://github.com/theotherp/nzbhydra2/\' | dereferer }}" target="_blank">https://github.com/theotherp/nzbhydra2</a>\n    <br><br>\n    <h3>Donations</h3>\n    You\'re welcome to donate:\n    <ul>\n      <li>Bitcoin via 1LPCUF9eKEXi58nHbxTbJyfxCJkcCXKzvm</li>\n      <li>Regular money via PayPal to theotherp@posteo.net</li>\n      <li>Via <a href="{{\'https://github.com/sponsors/theotherp\' | dereferer}}">GitHub sponsors</a> which involves a recurring donation similar to Patreon.</li>\n\n    </ul>\n\n    Thanks to the handful of people who\'ve already donated! I really appreciate the gesture.<br>\n    <br>\n    A special thanks go to\n    <br>\n    <a href="https://www.newsgroup.ninja/"><img src="static/img/ninja.png"></a>\n    <br>\n    for sponsoring me.\n\n    <br><br>\n    <h3>License</h3>\n    Licensed under the Apache License, Version 2.0 (the "License");\n    you may not use this file except in compliance with the License.\n    You may obtain a copy of the License at <a href="{{ \'http://www.apache.org/licenses/LICENSE-2.0\' | dereferer }}">http://www.apache.org/licenses/LICENSE-2.0</a>\n  </div>\n</div>\n');
$templateCache.put('static/html/bugreport.html','<div class="text-left row d-sm-flex justify-content-center">\r\n  <div class="col-xs-20 col-md-14">\r\n    <div class="panel panel-default">\r\n      <div class="panel-heading">\r\n        <h3 class="panel-title">Bugreport / Debug infos</h3>\r\n      </div>\r\n      <div class="panel-body">\r\n        So you found a bug? Ideally <a href="https://github.com/theotherp/nzbhydra2/issues/new" target="_blank">raise\r\n        an issue on github</a>. If you don\'t have an account create one ;-) I prefer GitHub issues for communication. Otherwise\r\n        <a\r\n          href="mailto:theotherp@posteo.net">send me a mail</a>.<br>\r\n        <b>But</b> please read this first:<br>\r\n        Don\'t just tell me what the problem is. If you just post an exception from the console or say "x does not\r\n        work" I probably won\'t be willing or able to help. Remember you want something\r\n        from\r\n        me.<br>\r\n        <ul>\r\n          <li>\r\n            Tell me what you expect to happen and what actually happens\r\n          </li>\r\n          <li>\r\n            If hydra doesn\'t even start, tell me your OS and how you start it.\r\n          </li>\r\n          <li>\r\n            If the website looks weird tell me what browser you use. If you use a reverse proxy post your config\r\n            and your base URL setting.\r\n          </li>\r\n          <li>\r\n            If the GUI behaves strangely or doesn\'t react as it should check the browser console for errors.\r\n          </li>\r\n        </ul>\r\n        Tell me anything that might help. If you do all that I will do my best to help you and improve NZBHydra.\r\n\r\n        <br><br>\r\n        If possible provide the log and your settings. Here you can get anonymized versions of both to be\r\n        posted:<br>\r\n\r\n        <div class="btn-group" uib-dropdown>\r\n          <button id="split-button" type="button" class="btn btn-primary" ng-click="downloadDebuggingInfos()">Create and download debug infos\r\n          </button>\r\n          <button type="button" class="btn btn-primary" uib-dropdown-toggle>\r\n            <span class="caret"></span>\r\n            <span class="sr-only">Split button!</span>\r\n          </button>\r\n          <ul class="dropdown-menu" uib-dropdown-menu role="menu" aria-labelledby="split-button">\r\n            <li role="menuitem"><a href="#" ng-click="uploadDebuggingInfos()">Create and upload debug infos to file share</a></li>\r\n          </ul>\r\n        </div>\r\n        <span>\r\n        <img src="static/img/spinner.gif" ng-show="isBackupCreationAction">\r\n        <span ng-bind-html="debugInfosUrl" style="margin-left: 10px"></span>\r\n        </span>\r\n        <br>\r\n        <button class="btn btn-default" ng-click="logThreadDump()" style="margin-top: 15px">Log thread dump</button>\r\n        <br>\r\n        <a href="actuator/heapdump" target="_blank">\r\n          <button class="btn btn-default" style="margin-top: 15px">Create heap dump <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                                                                          uib-tooltip="Will not work on J9 based JREs (and possibly others as well)."></span></button>\r\n        </a>\r\n      </div>\r\n    </div>\r\n\r\n    <div class="panel panel-default">\r\n      <div class="panel-heading">\r\n        <h3 class="panel-title">CPU usage <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                                uib-tooltip="Enable the logging marker \'Performance\' for this graph to show data."></span></h3>\r\n      </div>\r\n      <div class="panel-body">\r\n        <chart>\r\n          <nvd3 options="cpuChart.options" data="cpuChart.data" api="api" config="cpuChart.config"></nvd3>\r\n        </chart>\r\n      </div>\r\n    </div>\r\n\r\n    <div class="panel panel-default">\r\n      <div class="panel-heading">\r\n        <h3 class="panel-title">Debug SQL execution</h3>\r\n      </div>\r\n      <div class="panel-body">\r\n        You may want to take a look at the settings to make sure there\'s nothing in there you wouldn\'t want me to\r\n        see.\r\n        <br><br><br>\r\n        You can use the input box below to execute any SQL query against the database. You will likely never need\r\n        this but it allows me to ask you to execute a query when I try to solve a bug.\r\n        <br>\r\n        <textarea class="form-control" rows="5" data-ng-model="foo.sql"></textarea>\r\n        <button class="btn btn-default" ng-click="executeSqlQuery()">Query</button>\r\n        <button class="btn btn-default" ng-click="executeSqlUpdate()">Execute</button>\r\n        <textarea class="form-control" rows="10" data-ng-model="foo.csv"></textarea>\r\n      </div>\r\n    </div>\r\n\r\n    <div class="panel panel-default">\r\n      <div class="panel-heading">\r\n        <h3 class="panel-title">Misc</h3>\r\n      </div>\r\n      <div class="panel-body">\r\n        <a href="internalapi/debuginfos/endpoints" target="_blank">\r\n          <button class="btn btn-default">List HTTP endpoints</button>\r\n        </a>\r\n      </div>\r\n    </div>\r\n\r\n  </div>\r\n</div>\r\n');
$templateCache.put('static/html/celebration-modal.html','<!--\n  ~  (C) Copyright 2020 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div class="modal-header">\n  <h3 class="modal-title">Five years of NZBHydra!</h3>\n</div>\n<div class="modal-body" style="text-align: left">\n  <p>On this day, five years ago I <a href="https://old.reddit.com/r/usenet/comments/3vna42/presenting_nzb_hydra_the_usenet_meta_search_alpha/" target="_blank">first showed NZBHydra to the public</a>.</p>\n  \n  <p>It was the product of months of hard work and <a href="https://i.imgur.com/mlVXMT9.png" target="_blank">butt-ugly</a>. I started it mostly just for fun and to see if I could - it was my first\n    python project and it shows in the code. At that point the only other comparable tool was "NZBMegaSearch" which, to be honest, I already blew out of the water feature-wise, and was already abandoned.\n    When I released hydra I thought "What features could I possibly add to this?". Well, apparently enough to put another two years of work and more than 1100 commits into it.</p>\n  \n  <p>But at some point I realized that I could barely keep it working and with every change I made I introduced bugs left and right and the performance got worse and worse.\n    The most pressing issue were database timeouts which I never really solved.</p>\n  \n  <p>So I decided to switch to java (which I know by heart) and write NZBHydra2. I\'d say that was another (at least) 600 hours of work just for the first release - which I <a\n    href="https://old.reddit.com/r/usenet/comments/7ojguw/first_public_release_of_nzbhydra2_better_faster/" target="_blank">published</a> three years ago in january.\n    I think at that point it was one of the top 5 posts on /r/usenet.</p>\n  <p>Five years later I\'ve put more than 3000 hours into both projects, made 3300 commits and got 1100 stars on GitHub. I roughly estimate the user count to be somewhere in the 50 thousands - which is probably nothing compared\n    to NZBGet or Sonarr but still, I never expected to reach these numbers.</p>\n  <p>I admit that I\'m burnt out a bit and the frequency of my commits waned - by now I *really* can\'t think of many more features to develop. That being said I have no plans of abandoning the project and will continue to fix bugs, answer\n    questions and do improvements.\n  </p>\n  <p>\n    I want to thank all users, all the people on reddit, on my discord server, the donors, the bug reporters, the feature requesters, the indexer admins and all the other developers in this little microcosm of ours.</p>\n  <p>\n    And last but not least I want to celebrate with you. For that I will give away a year\'s worth of "Ale" VIP access on <a href="https://drunkenslug.com/" target="_blank">DrunkenSlug</a> for ten users. If you don\'t have an account, don\'t\n    worry - I\'ll send you an invite!\n    Big thanks to the admin for providing me these give-aways, I really appreciate it. To participate just visit the <a href="https://old.reddit.com/r/nzbhydra/" target="_blank">NZBHydra subreddit</a> and look for the announcement thread.\n  </p>\n  <br>\n  \u2764\uFE0F, TheOtherP\n\n</div>\n<div class="modal-footer">\n  <button class="btn btn-primary" type="button" ng-click="close()">Great!</button>\n</div>\n\n');
$templateCache.put('static/html/changelog-modal.html','<div class="modal-header">\r\n    <h3 class="modal-title">Change log</h3>\r\n</div>\r\n<div class="modal-body" style="text-align: left">\r\n    <div class="list-group">\r\n        <li ng-repeat="entry in versionHistory" class="list-group-item"\r\n            style="padding-top: 20px; padding-bottom: 20px;">\r\n            <h3 style="margin-top: 0">{{::entry.version}}<span ng-if="!entry.final"> BETA</span> ({{::entry.date}})</h3>\r\n            <div ng-repeat="change in entry.changes" style="margin-bottom: 5px">\r\n                <span ng-switch="change.type" style="margin-right: 5px">\r\n                    <span class="label label-primary" ng-switch-when="note">Note</span>\r\n                    <span class="label label-warning" ng-switch-when="fix">Fix</span>\r\n                    <span class="label label-success" ng-switch-when="feature">Feature</span>\r\n                </span>\r\n                {{change.text}}\r\n            </div>\r\n        </li>\r\n    </div>\r\n</div>\r\n<div class="modal-footer">\r\n    <button class="btn btn-primary" type="button" ng-click="ok()">Great!</button>\r\n</div>\r\n');
$templateCache.put('static/html/checker-state.html','<div class="modal-header">\r\n    <h3 class="modal-title">Checking caps... Please wait</h3>\r\n</div>\r\n<div class="modal-body" style="text-align: left;">\r\n    <img src="static/img/spinner.gif" ng-if="!messages"/>\r\n\r\n    <div ng-if="messages" style="text-align: left">\r\n\r\n        <ul style="padding-left: 0">\r\n            <li ng-repeat="message in messages" style="list-style-type: none">\r\n                {{message}}\r\n            </li>\r\n\r\n        </ul>\r\n        <img src="static/img/spinner.gif"/>\r\n\r\n    </div>\r\n\r\n</div>\r\n<div class="modal-footer">\r\n    <span style="float: left; margin-top: 5px">\r\n        This window will close automatically when the caps check is finished\r\n    </span>\r\n</div>\r\n');
$templateCache.put('static/html/config/color-control.html','<!--\n  ~  (C) Copyright 2020 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div class="input-group">\n  <input type="text" class="form-control" style="background-color: {{convertColorToCss()}}" ng-change="convertColorFromInput()" ng-model="color"/>\n  <span class="input-group-btn input-group-btn2" style="border-left: 0">\n   <button colorpicker="rgb" ng-model="model[options.key]" class="btn btn-default" type="button">\n     <i class="fa fa-eyedropper" aria-hidden="true"></i>\n    </button>\n  </span>\n  <span class="input-group-btn input-group-btn2" style="border-left-width: 1px; border-radius: 0">\n   <button ng-click="clear()" class="btn btn-default" type="button">\n     <i class="fa fa-remove" aria-hidden="true"></i>\n    </button>\n  </span>\n\n</div>');
$templateCache.put('static/html/config/downloader-config-box.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<span class="config-box">\n    <div class="modal-header" ng-show="model.name">\n        <h3 class="modal-title">{{ model.name }}</h3>\n    </div>\n    <div class="modal-body">\n        <formly-form fields="fields"\n                     model="model"\n                     form="form"\n                     options="options"\n        >\n        </formly-form>\n    </div>\n    <div class="modal-footer">\n        <button class="btn btn-danger pull-left" ng-click="deleteEntry()" ng-if="!isInitial">Delete</button>\n        <button class="btn btn-warning" ng-click="reset()">Reset</button>\n        <button class="btn btn-success has-spinner" ng-class="{\'active\': spinnerActive}" ng-click="obSubmit()">\n            <span class="spinner"><i class="fa fa-refresh fa-spin"></i></span>\n            Submit\n        </button>\n    </div>\n</span>');
$templateCache.put('static/html/config/downloader-config.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div class="row">\n  \n  <div class="btn-group"\n       style="margin-bottom: 30px; margin-left: auto; margin-right: auto; float:none !important;">\n    <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n      <span class="glyphicon glyphicon-plus" style="margin-right: 10px"></span>Add new downloader\n      <span class="caret"></span>\n      <span class="sr-only">Toggle Dropdown</span>\n    </button>\n    <ul class="dropdown-menu">\n      <li ng-repeat="preset in presets">\n        <a ng-click="addEntry(model, preset)">{{ preset.name }}</a>\n      </li>\n    </ul>\n  </div>\n</div>\n\n\n<div ng-repeat="entry in model | orderBy: [\'name\'] track by entry.name">\n  <div class="row">\n    <div style="margin-left: auto; margin-right: auto; float:none !important;">\n      <div style="margin-bottom: 30px;">\n        <form class="form-inline">\n          <button ng-click="showBox(entry, model)" class="btn btn-secondary indexer-button indexer-input btn-default"\n                  style="margin-right: 10px;">{{ entry.name }}\n          </button>\n          <input bs-switch type="checkbox" ng-model="entry.enabled"/>\n        </form>\n      </div>\n    </div>\n  </div>\n</div>');
$templateCache.put('static/html/config/external-tool-config-box.html','<!--\n  ~  (C) Copyright 2023 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<span class="config-box">\n    <div class="modal-header">\n        <h3 class="modal-title">External Tool Configuration</h3>\n    </div>\n    <div class="modal-body">\n        <formly-form fields="fields"\n                     model="model"\n                     form="form"\n                     options="options"\n        >\n        </formly-form>\n    </div>\n    <div class="modal-footer">\n        <button class="btn btn-danger pull-left" ng-click="deleteEntry()" ng-if="!isInitial">Delete</button>\n        <button class="btn btn-warning" ng-click="reset()">Reset</button>\n        <button class="btn btn-info" ng-click="testConnection()" ng-if="model.host && model.apiKey">Test connection</button>\n        <button class="btn btn-default" ng-click="cancel()">Cancel</button>\n        <button class="btn btn-success has-spinner" ng-class="{\'active\': spinnerActive}" ng-click="obSubmit()">\n            <span class="spinner"><i class="fa fa-refresh fa-spin"></i></span>\n            OK\n        </button>\n    </div>\n</span>');
$templateCache.put('static/html/config/external-tool-config.html','<!--\n  ~  (C) Copyright 2023 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div class="row" style="margin-top: 30px;">\n  <div class="btn-group" style="margin-bottom: 30px; margin-left: auto; margin-right: auto; float:none !important;">\n    <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n      <span class="glyphicon glyphicon-plus" style="margin-right: 10px"></span>Add external tool\n      <span class="caret"></span>\n      <span class="sr-only">Toggle Dropdown</span>\n    </button>\n    <ul class="dropdown-menu">\n      <li ng-repeat="preset in presets">\n        <a ng-click="addEntry(model.externalTools, preset)">{{ preset.name }}</a>\n      </li>\n      <li role="separator" class="divider"></li>\n      <li>\n        <a ng-click="addEntry(model.externalTools)">Custom</a>\n      </li>\n    </ul>\n  </div>\n</div>\n\n<div ng-if="model.externalTools.length === 0" class="row">\n  <div class="col-md-12 text-center" style="margin-top: 30px;">\n    <h4>No external tools configured</h4>\n    <p>Use the "Add external tool" button above to configure Sonarr, Radarr, Lidarr, or Readarr instances.</p>\n  </div>\n</div>\n\n<div ng-repeat="entry in model.externalTools | orderBy: [\'name\'] track by $index">\n  <div class="row">\n    <div style="margin-left: auto; margin-right: auto; float:none !important;">\n      <div style="margin-bottom: 30px;">\n        <form class="form-inline">\n          <button ng-click="showBox(entry, model.externalTools)" class="btn btn-secondary indexer-button indexer-input btn-default" style="margin-right: 10px;">\n            {{ entry.name }}\n          </button>\n          <span style="margin-right: 10px;">{{ entry.host }}</span>\n          <button ng-click="model.externalTools.splice($index, 1)" class="btn btn-danger btn-xs">\n            <span class="glyphicon glyphicon-remove"></span>\n          </button>\n        </form>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="row" style="margin-top: 20px;">\n  <div class="col-md-12" style=" margin-left: auto; margin-right: auto; float:none !important;">\n    <button type="button" class="btn btn-info" ng-click="syncAll()">\n      <span class="glyphicon glyphicon-refresh" style="margin-right: 10px"></span>Sync all now\n    </button>\n  </div>\n</div>');
$templateCache.put('static/html/config/indexer-config-box.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<span class="config-box">\n    <div class="modal-header">\n        <h3 class="modal-title">\n            <span ng-if="model.name">{{ model.name }}</span>\n            <span ng-if="!model.name">Unnamed indexer</span>\n        </h3>\n    </div>\n    <div class="modal-body">\n        <div class="panel panel-default" ng-if="model.info">\n            <div class="panel-body ">\n                <span ng-bind-html="model.info | unsafe"></span>\n            </div>\n        </div>\n        <formly-form fields="fields"\n                     model="model"\n                     form="form"\n                     options="options"\n        >\n        </formly-form>\n    </div>\n    <div class="modal-footer">\n        <button class="btn btn-danger pull-left" ng-click="deleteEntry()" ng-if="!isInitial"\n                uib-tooltip="Deleting an indexer will remove its stats and related downloads and search results from the database" tooltip-placement="top" tooltip-trigger="mouseenter">Delete</button>\n        <button class="btn btn-warning" ng-click="reset()">Reset</button>\n        <button class="btn btn-success has-spinner" ng-class="{\'active\': spinnerActive}" ng-click="obSubmit()">\n            <span class="spinner"><i class="fa fa-refresh fa-spin"></i></span>\n            Submit\n        </button>\n    </div>\n</span>');
$templateCache.put('static/html/config/indexer-config-selection.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<span class="config-box">\n    <div class="modal-header">\n        <h3 class="modal-title">Add indexer</h3>\n    </div>\n    <div class="modal-body">\n        <div class="panel panel-default">\n          <div class="panel-heading">\n            <h3 class="panel-title">Usenet</h3>\n          </div>\n          <div class="panel-body">\n            \n            <div class="btn-group"\n                 style="margin-left: auto; margin-right: auto; float:none !important;">\n              <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n                Choose from presets\n                <span class="caret"></span>\n                <span class="sr-only">Toggle Dropdown</span>\n              </button>\n              <ul class="dropdown-menu scrollable-menu">\n                <li ng-repeat="preset in newznabPresets">\n                  <a ng-click="select(preset)">{{ preset.name }}</a>\n                </li>\n              </ul>\n            </div>\n            <button class="btn btn-info" ng-click="select()">\n              Add custom newznab indexer\n            </button>\n          </div>\n        </div>\n      \n        <div class="panel panel-default">\n          <div class="panel-heading">\n            <h3 class="panel-title">Torrents</h3>\n          </div>\n          <div class="panel-body">\n            <div class="btn-group"\n                 style="margin-left: auto; margin-right: auto; float:none !important;">\n              <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n                Choose from presets\n                <span class="caret"></span>\n                <span class="sr-only">Toggle Dropdown</span>\n              </button>\n              <ul class="dropdown-menu scrollable-menu">\n                <li ng-repeat="preset in torznabPresets">\n                  <a ng-click="select(preset)">{{ preset.name }}</a>\n                </li>\n                <li><a href="#">---</a></li>\n                <li>\n                  <a ng-click="readJackettConfig()">Read from jackett config</a>\n                </li>\n              </ul>\n            </div>\n            <button class="btn btn-info" ng-click="select(emptyTorznabPreset)">\n              Add custom torznab indexer\n            </button>\n          </div>\n        </div>\n      \n            <div class="panel panel-default">\n                <div class="panel-heading">\n                  <h3 class="panel-title">Special</h3>\n                </div>\n                <div class="panel-body">\n                  <div class="btn-group" style="margin-left: auto; margin-right: auto; float:none !important;">\n                    <span ng-repeat="preset in specialPresets">\n                    <button type="button" class="btn btn-info" ng-click="select(preset)">\n                      {{ preset.name }}\n                    </button>\n                    </span>\n                  </div>\n                </div>\n              </div>\n    </div>\n</span>');
$templateCache.put('static/html/config/indexer-config.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div>\n\n  <div class="btn-group" style="margin-bottom: 30px; margin-left: auto; margin-right: auto; float:none !important;">\n    <button class="btn btn-info" ng-click="showPresetSelection()">\n      <span class="glyphicon glyphicon-plus" style="margin-right: 10px"></span>Add new indexer\n    </button>\n  </div>\n\n\n  <div ng-repeat="entry in model | orderBy: [\'-state\', \'-score\', \'name\'] : false track by entry.name">\n    <div class="row">\n      <div style="margin-left: auto; margin-right: auto; float:none !important;">\n        <indexer-input indexer="entry" model="model" on-click="showBox"></indexer-input>\n      </div>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('static/html/config/recheck-all-caps.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div class="row">\n  \n  <div class="btn-group"\n       style="margin-bottom: 30px; margin-left: auto; margin-right: auto; float:none !important;">\n    <button class="btn btn-info" ng-click="recheck(\'INCOMPLETE\')">Recheck caps for incomplete indexers\n    </button>\n    <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true"\n            aria-expanded="false">\n      <span class="caret"></span>\n      <span class="sr-only">Toggle Dropdown</span>\n    </button>\n    <ul class="dropdown-menu">\n      <li>\n        <a ng-click="recheck(\'ALL\')">Recheck caps for all indexers</a>\n      </li>\n    </ul>\n  </div>\n</div>');
$templateCache.put('static/html/configure-in-modal.html','<div class="modal-header">\n  <h3 class="modal-title">Configure NZBHydra in {{::externalToolDisplayName}}</h3>\n</div>\n<div class="modal-body" style="text-align: left">\n  <div ng-show="!working">\n    <div class="well">\n      This allows you to configure NZBHydra in Sonarr / Radarr / Lidarr.<br>\n      <br>\n      You can decide if you want to:<br>\n      <ul>\n  \n        <li>a) add NZBHydra as one indexer. This is the default. *arr will make one query to NZBHydra which will then query all indexers and return one unified list of results.</li>\n        <li>b) add one entry per indexer configured in NZBHydra. *arr will make multiple queries to NZBHydra (one per indexer). This will result in a lot of entries in your NZBHydra history but has the one benefit that should *darr be\n          unable\n          to\n          download an NZB from an indexer then NZBHydra then only that indexer entry will be disabled in *arr.\n        </li>\n      </ul>\n      In most cases you should stick with a).<br>\n      <br>\n      Any indexer entries containing "{{nzbhydraName}}" in the name will be deleted. I recommend you make a backup of {{::externalToolDisplayName}} before.\n      <br>\n      <span ng-if="prioritiesConfigured && (externalTool === \'Sonarr\' || externalTool === \'Radarr\') && addType === \'PER_INDEXER\'">\n      <br>\n      This tool supports indexer priorities. Unfortunately where NZBHydra uses higher values for higher priorities this tool uses lower values (0 for highest, 50 for lowest priority). NZBHydra will try to map the priorities accordingly.\n      <br>\n    </span>\n    </div>\n    <br>\n    <div class="form-group row">\n      <div class="col-md-8" style="text-align: right">\n        <label>NZBHydra name</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="nzbhydraName">\n      </div>\n    </div>\n    \n    <div class="form-group row">\n      <div class="col-md-8" style="text-align: right">\n        <label>NZBHydra host</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="nzbhydraHost">\n      </div>\n    </div>\n    \n    <div class="form-group row" ng-show="usenetIndexersConfigured">\n      <div class="col-md-8" style="text-align: right">\n        <label>Configure for usenet</label>\n      </div>\n      <div class="col-md-12">\n        <input bs-switch type="checkbox" ng-model="configureForUsenet">\n      </div>\n    </div>\n    \n    <div class="form-group row" ng-show="torrentIndexersConfigured">\n      <div class="col-md-8" style="text-align: right">\n        <label>Configure for torrents</label>\n      </div>\n      <div class="col-md-12">\n        <input bs-switch type="checkbox" ng-model="configureForTorrents">\n      </div>\n    </div>\n  \n    <div class="form-group row">\n      <div class="col-md-8" style="text-align: right">\n        <label>Add type</label>\n      </div>\n      <div class="col-md-12">\n        <input bs-switch type="checkbox" ng-model="addType" switch-on-text="Single" switch-off-text="Multiple" switch-off-color="success" ng-true-value="\'SINGLE\'" ng-false-value="\'PER_INDEXER\'">\n      </div>\n    </div>\n  \n    <div class="form-group row" ng-show="addType === \'PER_INDEXER\'">\n      <div class="col-md-8" style="text-align: right">\n        <label>Add disabled indexers</label>\n      </div>\n      <div class="col-md-12">\n        <input bs-switch type="checkbox" ng-model="addDisabledIndexers">\n      </div>\n    </div>\n  \n    <div class="form-group row">\n      <div class="col-md-8" style="text-align: right">\n        <label>{{externalToolDisplayName}} URL</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="xdarrHost">\n      </div>\n    </div>\n  \n    <div class="form-group row">\n      <div class="col-md-8" style="text-align: right">\n        <label>{{externalToolDisplayName}} API key</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="xdarrApiKey">\n      </div>\n    </div>\n    \n    <div class="form-group row">\n      <div class="col-md-8" style="text-align: right">\n        <label>Enable RSS</label>\n      </div>\n      <div class="col-md-12">\n        <input bs-switch type="checkbox" ng-model="enableRss">\n      </div>\n    </div>\n    \n    <div class="form-group row">\n      <div class="col-md-8" style="text-align: right">\n        <label>Enable automatic search</label>\n      </div>\n      <div class="col-md-12">\n        <input bs-switch type="checkbox" ng-model="enableAutomaticSearch">\n      </div>\n    </div>\n  \n    <div class="form-group row" ng-show="externalTool !== \'Radarr\'">\n      <div class="col-md-8" style="text-align: right">\n        <label>Enable interactive search</label>\n      </div>\n      <div class="col-md-12">\n        <input bs-switch type="checkbox" ng-model="enableInteractiveSearch">\n      </div>\n    </div>\n    \n    <div class="form-group row" ng-show="prioritiesConfigured && (externalTool === \'Sonarr\' || externalTool === \'Radarr\') && addType === \'PER_INDEXER\'">\n      <div class="col-md-8" style="text-align: right">\n        <label>Set indexer priorities</label>\n      </div>\n      <div class="col-md-12">\n        <input bs-switch type="checkbox" ng-model="useHydraPriorities">\n      </div>\n    </div>\n  \n    <div class="form-group row">\n      <div class="col-md-8" style="text-align: right">\n        <label>Categories</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="categories">\n      </div>\n    </div>\n  \n    <div class="form-group row">\n      <div class="col-md-8" style="text-align: right">\n        <label>Additional parameters</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="additionalParameters">\n      </div>\n    </div>\n    \n    <div class="form-group row" ng-show="externalTool !== \'Lidarr\' && externalTool !== \'Radarr\' && externalTool !== \'Readarr\'">\n      <div class="col-md-8" style="text-align: right">\n        <label>Anime categories</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="animeCategories">\n      </div>\n    </div>\n    \n    <div class="form-group row" ng-show="externalTool === \'Radarr\' || externalTool === \'Radarr\'">\n      <div class="col-md-8" style="text-align: right">\n        <label>Remove year from search string</label>\n      </div>\n      <div class="col-md-12">\n        <input bs-switch type="checkbox" ng-model="removeYearFromSearchString">\n      </div>\n    </div>\n  \n    <div class="form-group row" ng-show="(externalTool === \'Lidarr\' || externalTool === \'Readarr\')">\n      <div class="col-md-8" style="text-align: right">\n        <label>Early download limit</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="earlyDownloadLimit">\n      </div>\n    </div>\n    \n    <div class="form-group row" ng-show="configureForTorrents">\n      <div class="col-md-8" style="text-align: right">\n        <label>Minimum seeders</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="minimumSeeders">\n      </div>\n    </div>\n    \n    <div class="form-group row" ng-show="configureForTorrents && (externalTool === \'Sonarr\'  || externalTool === \'Lidarr\' || externalTool === \'Radarr\' || externalTool === \'Readarr\')">\n      <div class="col-md-8" style="text-align: right">\n        <label>Seed ratio</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="seedRatio">\n      </div>\n    </div>\n    \n    <div class="form-group row" ng-show="configureForTorrents && (externalTool === \'Sonarr\' || externalTool === \'Lidarr\' || externalTool === \'Radarr\' || externalTool === \'Readarr\')">\n      <div class="col-md-8" style="text-align: right">\n        <label>Seed time</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="seedTime">\n      </div>\n    </div>\n    \n    <div class="form-group row" ng-show="configureForTorrents && externalTool === \'Sonarr\' ">\n      <div class="col-md-8" style="text-align: right">\n        <label>Season pack seed time</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="seasonPackSeedTime">\n      </div>\n    </div>\n  \n    <div class="form-group row" ng-show="configureForTorrents && (externalTool === \'Lidarr\' || externalTool === \'Readarr\')">\n      <div class="col-md-8" style="text-align: right">\n        <label>Discography seed time</label>\n      </div>\n      <div class="col-md-12">\n        <input type="text" class="form-control" ng-model="discographySeedTime">\n      </div>\n    </div>\n  \n  </div>\n  \n  <div class="panel panel-default" ng-show="showMessages">\n    <div class="panel-heading">Log</div>\n    <div class="panel-body">\n      <ul>\n        <li ng-repeat="message in externalToolsMessages">\n          {{ message }}\n        </li>\n      </ul>\n    </div>\n  </div>\n  <!--  <div ng-show="showMessages">-->\n  <!--    <ul>-->\n  <!--      <li ng-repeat="message in externalToolsMessages">-->\n  <!--        {{ message }}-->\n  <!--      </li>-->\n  <!--    </ul>-->\n  <!--  </div>-->\n\n</div>\n<div class="modal-footer">\n  <button class="btn danger" type="button" ng-click="submit(true)" ng-show="!completed && !working">Delete existing entries</button>\n  <button class="btn btn-{{closeButtonType}}" type="button" ng-click="close()">Close</button>\n  <button class="btn btn-success has-spinner" ng-class="{\'active\': spinnerActive}" ng-show="!completed" type="button" ng-click="submit()"><span class="spinner"><i class="fa fa-refresh fa-spin"></i></span> Submit</button>\n</div>\n');
$templateCache.put('static/html/custom-mapping-help.html','<div class="modal-header">\n  <h3 class="modal-title">Custom query and title mapping help and test</h3>\n</div>\n<div class="modal-body" style="text-align: left">\n  <div class="well">\n    <ul>\n      <li>\n          The input must completely match the title or query for the customQueryAndTitleMapping to be effective. The matching is case insensitive.\n      </li>\n      <li>\n        You may use regular expressions anywhere (e.g. <code>[a-z]</code> or <code>.*</code>). You may use named groups to reference them in the output pattern (e.g. <code>{title:.*}</code> can be referenced using <code>{title}</code>) but\n        they must not start with digits.\n        Brackets ("{}") may not be used in regexes.\n      </li>\n      <li>\n        The following meta groups are available: <code>{season:0}</code>, <code>{season:00}</code>, <code>{episode:0}</code>, <code>{episode:00}</code> (with and without leading zeroes, respectively). The data will be taken from the search\n          request\'s or title\'s metadata. If it\'s not available the customQueryAndTitleMapping will not be used.\n      </li>\n\n    </ul>\n  </div>\n\n    <div class="form-group row">\n    <div class="col-md-5" style="text-align: right">\n      <label>Input pattern</label>\n    </div>\n    <div class="col-md-15">\n      <input type="text" class="form-control" ng-model="model.from">\n    </div>\n  </div>\n\n    <div class="form-group row">\n    <div class="col-md-5" style="text-align: right">\n      <label>Output pattern</label>\n    </div>\n    <div class="col-md-15">\n      <input type="text" class="form-control" ng-model="model.to">\n    </div>\n    </div>\n  \n  <div class="form-group row">\n    <div class="col-md-5" style="text-align: right">\n      <label>Example query/title</label>\n    </div>\n    <div class="col-md-15">\n      <input type="text" class="form-control" ng-model="exampleInput">\n    </div>\n  </div>\n  \n  <div class="form-group row">\n    <div class="col-md-5" style="text-align: right">\n      <label>Match whole string</label>\n    </div>\n    <div class="col-md-15">\n      <input bs-switch type="checkbox" ng-model="model.matchAll" class="ng-untouched ng-valid ng-not-empty ng-dirty" aria-invalid="false"></div>\n  </div>\n</div>\n</div>\n\n<div class="form-group row">\n  <div class="col-md-5" style="text-align: right">\n  </div>\n  <div class="col-md-15">\n    <button class="btn btn-default" ng-click="test()">Test</button>\n  </div>\n</div>\n\n<div class="form-group row">\n    <div class="col-md-5" style="text-align: right">\n      <label>Result</label>\n    </div>\n    <div class="col-md-15">\n      <input type="text" class="form-control" ng-model="exampleResult" disabled="disabled">\n    </div>\n  </div>\n\n</div>\n<div class="modal-footer">\n  <button class="btn btn-warning" type="button" ng-click="cancel()">Cancel</button>\n  <button class="btn btn-success" type="button" ng-click="submit()">Submit</button>\n</div>\n');
$templateCache.put('static/html/dataTable/columnFilterBoolean.html','<div class="form-group column-filter-boolean" style="padding-left: 5px">\r\n    <div class="radio">\r\n        <label>\r\n            <input type="radio" name="chickenEgg" value="{{ options[0].value }}" ng-model="selected.value"\r\n                   ng-change="apply()">\r\n            {{ ::options[0].label }}\r\n        </label>\r\n    </div>\r\n    <div class="radio">\r\n        <label>\r\n            <input type="radio" name="chickenEgg" value="{{ options[1].value }}" ng-model="selected.value"\r\n                   ng-change="apply()">\r\n            {{ ::options[1].label }}\r\n        </label>\r\n    </div>\r\n    <div class="radio">\r\n        <label>\r\n            <input type="radio" name="chickenEgg" value="{{ options[2].value }}" ng-model="selected.value"\r\n                   ng-change="apply()">\r\n            {{ ::options[2].label }}\r\n        </label>\r\n    </div>\r\n</div>');
$templateCache.put('static/html/dataTable/columnFilterCheckboxes.html','<div class="input-group" style="margin-left: 5px; margin-top: 5px; margin-bottom: 5px">\r\n\r\n    <span selection-button invert-selection="invert" select-all="selectAll" deselect-all="deselectAll"\r\n          btn="primary"></span>\r\n</div>\r\n\r\n<li ng-repeat="entry in entries" style="margin-left: 5px; margin-right: 5px">\r\n    <span style="white-space:nowrap">\r\n        <label class="dropdown-label">\r\n            <input type="checkbox" data-checklist-model="selected.entries" data-checklist-value="entry"\r\n                   class="checkbox-filter-option" data-label="{{::entry.label}}"> {{ ::entry.label }}\r\n        </label>\r\n    </span>\r\n</li>\r\n\r\n<button type="button" class="btn btn-primary checkbox-filter-button-apply" ng-click="apply()"\r\n        style="margin-left: 5px; margin-bottom: 5px">\r\n    Apply\r\n</button>\r\n<button type="button" class="btn btn-primary checkbox-filter-button-clear" ng-click="clear()"\r\n        style="margin-right: 5px; margin-bottom: 5px; float: right">\r\n    Clear\r\n</button>\r\n');
$templateCache.put('static/html/dataTable/columnFilterFreetext.html','<input type="text" ng-keyup="onKeyUp($event)" ng-model="data.filter" id="freetext-filter-input" auto-focus\n       no-focus="{{::inline}}" ng-class="::{\'inline-filter\': inline, \'form-control\' : inline}"\n       placeholder="{{::placeholder}}" uib-tooltip="{{::tooltip}}"\n       tooltip-placement="top"\n       tooltip-trigger="mouseenter"/>');
$templateCache.put('static/html/dataTable/columnFilterNumberRange.html','<span class="number-range-filter">\r\n    <span class="input-group" style="margin-left: 5px; margin-right: 5px;">\r\n        <span class="input-group-addon" style="width: 60px">Min</span>\r\n        <input type="text" class="form-control number-range-filter-min" ng-model="filterValue.min"\r\n               ng-keypress="onKeypress($event)" style="min-width: 70px" auto-focus uib-tooltip="{{::tooltip}}"\r\n               tooltip-placement="top"\r\n               tooltip-trigger="mouseenter"/>\r\n        {{toolipMin}}\r\n        <span class="input-group-addon" ng-if="::addon">{{::addon}}</span>\r\n    </span>\r\n\r\n    <span class="input-group" style="margin: 5px">\r\n        <span class="input-group-addon" style="width: 60px">Max</span>\r\n        <input type="text" class="form-control number-range-filter-max" ng-model="filterValue.max"\r\n               ng-keypress="onKeypress($event)" style="min-width: 70px" uib-tooltip="{{::tooltip}}"\r\n               tooltip-placement="top"\r\n               tooltip-trigger="mouseenter"/>\r\n        <span class="input-group-addon" ng-if="::addon">{{::addon}}</span>\r\n    </span>\r\n\r\n    <button type="button" class="btn btn-primary number-range-filter-button-apply" ng-click="apply()"\r\n            style="margin-left: 5px; margin-bottom: 5px">\r\n        Apply\r\n    </button>\r\n    <button type="button" class="btn btn-primary number-range-filter-button-clear" ng-click="clear()"\r\n            style="margin-right: 5px; margin-bottom: 5px; float: right">\r\n        Clear\r\n    </button>\r\n</span>\r\n');
$templateCache.put('static/html/dataTable/columnFilterOuter.html','<div ng-if="::!columnFilterWrapperCtrl.inline" class="btn-group filter-wrapper"\r\n     ng-class="{\'open\':columnFilterWrapperCtrl.open}" click-outside="columnFilterWrapperCtrl.clear()"\r\n     outside-ignore="{{!columnFilterWrapperCtrl.open}}">\r\n    <button id="single-button" type="button" class="btn btn-primary dropdown-toggle column-filter toggle-column-filter"\r\n            ng-click="columnFilterWrapperCtrl.toggle()">\r\n        <span class="glyphicon glyphicon-filter" ng-class="{\'filter-active\': columnFilterWrapperCtrl.isActive}"></span>\r\n    </button>\r\n    <ul role="menu" class="dropdown-menu" ng-transclude>\r\n\r\n    </ul>\r\n</div>\r\n<span ng-if="::columnFilterWrapperCtrl.inline" style="margin-left:-5px" ng-transclude>\r\n\r\n</span>\r\n');
$templateCache.put('static/html/dataTable/columnFilterTime.html','<span>\r\n    <p class="input-group" style="margin-left: 5px; margin-right: 5px;">\r\n        <span class="input-group-addon" id="basic-addon3" style="min-width: 70px">After</span>\r\n        <input type="text" class="form-control" uib-datepicker-popup ng-model="selected.afterDate" close-on-date-selection="false"\r\n               is-open="after.opened" datepicker-options="dateOptions" close-text="Close"\r\n               style="min-width: 110px"/>\r\n        <span class="input-group-btn input-group-btn2">\r\n    <button type="button" class="btn btn-default" ng-click="openAfter()"><i\r\n            class="glyphicon glyphicon-calendar"></i></button>\r\n        </span>\r\n    </p>\r\n\r\n\r\n    <p class="input-group" style="margin-left: 5px; margin-right: 5px;">\r\n        <span class="input-group-addon" id="basic-addon3" style="min-width: 70px">Before</span>\r\n        <input type="text" class="form-control" uib-datepicker-popup ng-model="selected.beforeDate" close-on-date-selection="false"\r\n               is-open="before.opened" datepicker-options="dateOptions" close-text="Close"\r\n               style="min-width: 110px"/>\r\n        <span class="input-group-btn input-group-btn2">\r\n            <button type="button" class="btn btn-default" ng-click="openBefore()"><i\r\n                    class="glyphicon glyphicon-calendar"></i></button>\r\n        </span>\r\n    </p>\r\n\r\n    <button type="button" class="btn btn-primary" ng-click="apply()" style="margin-left: 5px; margin-bottom: 5px">\r\n        Apply\r\n    </button>\r\n    <button type="button" class="btn btn-primary number-range-filter-button-clear" ng-click="clear()"\r\n            style="margin-right: 5px; margin-bottom: 5px; float: right">\r\n        Clear\r\n    </button>\r\n</span>');
$templateCache.put('static/html/dataTable/columnSortable.html','<span class="column-sortable-{{::column}}">\r\n<span ng-click="sort()" ng-transclude id="text-sortable-{{::column}}" class="text-sortable"></span>\r\n<span ng-click="sort()" class="glyphicon marker-sortable" id="marker-sortable-{{::column}}"\r\n      ng-class="{\'glyphicon-triangle-top\': (sortModel.sortMode==1 && !sortModel.reversed) || (sortModel.sortMode==2 && sortModel.reversed), \'glyphicon-triangle-bottom\': (sortModel.sortMode==2 && !sortModel.reversed) || (sortModel.sortMode==1 && sortModel.reversed)}"\r\n      style="font-size: 80%"></span>\r\n    </span>');
$templateCache.put('static/html/directives/addable-nzb-modal.html','<div class="modal-header">\r\n  <h3 class="modal-title">Please select the category</h3>\r\n</div>\r\n<div class="modal-body" style="text-align: center">\r\n  <div>\r\n    <button class="btn btn-default category-button" type="button" ng-click="select(\'\')">\r\n      No category\r\n    </button>\r\n    <button ng-repeat="category in categories" class="btn btn-default category-button" type="button" ng-click="select(category)">\r\n      {{ category }}\r\n    </button>\r\n  </div>\r\n\r\n</div>\r\n');
$templateCache.put('static/html/directives/addable-nzb.html','<a href="#" ng-click="add()" uib-tooltip="Send to {{ ::downloader.name }}"\n   tooltip-placement="top"\n   tooltip-trigger="mouseenter"\n   class="result-send-to-downloader-link glyph-link"\n>\n    <div class="icon addable-nzb" ng-class="cssClass"\n    ></div>\n</a>\n');
$templateCache.put('static/html/directives/addable-nzbs.html','<span ng-repeat="downloader in ::downloaders">\r\n    <addable-nzb downloader="::downloader" searchresult="::searchresult" always-ask="alwaysAsk"></addable-nzb>\r\n</span>');
$templateCache.put('static/html/directives/backup.html','<div class="text-left row d-sm-flex justify-content-center">\r\n    <div class="col-xs-20 col-md-14">\r\n        <div class="btn-group" uib-dropdown>\r\n            <button id="split-button" type="button" class="btn btn-primary" ng-click="createAndDownloadBackupFile()">Create and download backup\r\n            </button>\r\n            <button type="button" class="btn btn-primary" uib-dropdown-toggle>\r\n                <span class="caret"></span>\r\n                <span class="sr-only">Split button!</span>\r\n            </button>\r\n            <ul class="dropdown-menu" uib-dropdown-menu role="menu" aria-labelledby="split-button">\r\n                <li role="menuitem"><a href="#" ng-click="createBackupFile()">Just create backup</a></li>\r\n            </ul>\r\n        </div>\r\n\r\n        <br>\r\n        <br>\r\n        <button type="file" ngf-select="uploadBackupFile($file, $invalidFiles)" class="btn btn-primary">\r\n            Upload and restore from file\r\n        </button>\r\n        <uib-progressbar ng-class="{\'hidden\': !uploadActive}" max="file.total" value="file.loaded"\r\n                        class="progress-striped active" style="margin-top: 10px"><span\r\n                style="color:white; white-space:nowrap;">{{ file.loaded }} kB</span>\r\n        </uib-progressbar>\r\n\r\n\r\n        <div style="margin-top: 50px">\r\n            <span style="text-align: center"><h3>Existing backups</h3></span>\r\n            <div class="table-responsive">\r\n                <table class="table">\r\n                    <tr class="row">\r\n                        <th class="col-md-15" style="text-align: left">Filename</th>\r\n                        <th class="col-md-4" style="text-align: left">Created</th>\r\n                        <th class="col-md-1" style="text-align: left">Restore</th>\r\n                    </tr>\r\n                    <tr ng-repeat="backup in backups" class="row">\r\n                        <td class="col-md-15" style="text-align: left"><a\r\n                            href="internalapi/backup/download?filename={{ backup.filename }}" target="_self">{{\r\n                            backup.filename }}</a></td>\r\n                        <td class="col-md-4" style="text-align: left">{{ backup.creationDate | reformatDate }}</td>\r\n                        <td class="col-md-1" style="text-align: center"><span class="glyphicon glyphicon-repeat"\r\n                                                                            ng-click="restoreFromFile(backup.filename)"></span>\r\n                        </td>\r\n                    </tr>\r\n\r\n                </table>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n');
$templateCache.put('static/html/directives/cfg-form-entry.html','<div class="form-group row">\r\n    <div class="col-md-6" style="text-align: right">\r\n        <label class="control-label">{{ title }}</label>\r\n    </div>\r\n    <div class="col-md-8">\r\n        <input ng-if="type==\'checkbox\'" ng-model="cfg" type="checkbox" bs-switch/>\r\n        <input ng-if="type==\'text\'" ng-model="cfg" type="text" class="form-control"/>\r\n\r\n        <ui-select ng-if="type==\'select\'" ng-model="cfg" theme="bootstrap" search-enabled="false">\r\n            <ui-select-match class="ui-select-match">\r\n                <span ng-bind="cfg.name"></span>\r\n            </ui-select-match>\r\n            <ui-select-choices repeat="item in options" class="ui-select-choices">\r\n                <span ng-bind="item.name"></span>\r\n            </ui-select-choices>\r\n        </ui-select>\r\n        {{ cfg }}\r\n        {{ cfg.name }}\r\n        <span class="help-block" ng-if="help">{{ help }}</span>\r\n    </div>\r\n\r\n</div>');
$templateCache.put('static/html/directives/checks-footer.html','<span style="bottom: {{updateFooterBottom}}px; z-index:100" id="update-footer" ng-if="updateAvailable || automaticUpdateToNotice">\n<div ng-if="updateAvailable" ng-cloak="" class="alert alert-info" role="alert" style="margin-bottom: 0; padding-top: 0">\n    <div class="container" ng-if="!updatedExternally">\n        An update is available. Your version: <span ng-bind-html="currentVersion"></span>. Latest version: <span ng-bind-html="latestVersion"></span><span ng-if="latestVersionIsBeta"> Beta</span>.<br>\n        <button class="btn btn-default" type="button" ng-click="showChangelog(latestVersion)" style="margin-top: 5px;">See what\'s new!\n        </button>\n        <button class="btn btn-warning" type="button" ng-click="ignore()" style="margin-top: 5px">Ignore this update\n        </button>\n        <button class="btn btn-success" type="button" ng-click="update()" style="margin-top: 5px;">Update now!</button>\n    </div>\n    <div class="container" ng-if="updatedExternally" style="font-size: larger;">\n        An update is available. Your version: <span ng-bind-html="currentVersion"></span>. Latest version: <span ng-bind-html="latestVersion"></span>.\n        Your NZBHydra instance seems to run in docker or is installed via a package manager. Please update this instance accordingly.\n        <button class="btn btn-default" type="button" ng-click="showChangelog()" style="margin-top: 5px;">See what\'s new!\n        </button>\n        <button class="btn btn-warning" type="button" ng-click="ignore()" style="margin-top: 5px">Ignore this update\n        </button>\n    </div>\n</div>\n<div ng-if="automaticUpdateToNotice && showWhatsNewBanner" ng-cloak="" class="alert alert-info" role="alert" style="margin-bottom: 0; padding-top: 0">\n    <button type="button" class="close" data-dismiss="alert" aria-label="Close" ng-click="dismissChangesFromAutomaticUpdate()"><span aria-hidden="true">&times;</span></button>\n    <div class="container">\n        An update was automatically installed.\n        <button class="btn btn-default" type="button" ng-click="showChangesFromAutomaticUpdate()" style="margin-top: 5px;">See what\'s new!</button>\n    </div>\n</div>\n\n</span>\n');
$templateCache.put('static/html/directives/connection-test.html','<span style="text-align: left;">\r\n    <button class="btn btn-default" id="button-test-connection" type="button" ng-click="testConnection()">\r\n    <span class="glyphicon glyphicon-refresh"></span>\r\n    </button>\r\n    <span id="message-test-connection"></span>\r\n</span>');
$templateCache.put('static/html/directives/copy-links-button.html','<div class="btn-group pe-2 mb-2">\n  <button type="button" class="btn btn-default" ng-click="copyLinks()" id="copy-selected-links">\n    Copy links\n  </button>\n</div>');
$templateCache.put('static/html/directives/download-nzbs-button.html','<div class="btn-group pe-2 mb-2" ng-if="downloaders.length > 0">\r\n    <div ng-if="::downloaders.length == 1">\r\n        <button class="btn btn-default" ng-click="download(downloaders[0])" id="send-selected-to-downloader"><span\r\n                class="glyphicon glyphicon-plus" style="margin-right: 10px"></span> {{ ::downloaders[0].name }}</button>\r\n    </div>\r\n    <div ng-if="::downloaders.length > 1">\r\n\r\n        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true"\r\n                aria-expanded="false" id="send-selected-to-downloader-dropdown">\r\n            <span><span class="glyphicon glyphicon-plus" style="margin-right: 10px"></span>Add to ...</span>\r\n            <span class="caret"></span>\r\n            <span class="sr-only">Toggle Dropdown</span>\r\n        </button>\r\n        <ul class="dropdown-menu">\r\n            <li ng-repeat="downloader in downloaders">\r\n                <a ng-click="download(downloader)" class="send-to-downloader">{{ ::downloader.name }}</a>\r\n            </li>\r\n            <li ng-if="blackholeEnabled">\r\n                <a ng-click="sendToBlackhole()" class="send-to-downloader">Black hole</a>\r\n            </li>\r\n        </ul>\r\n    </div>\r\n\r\n</div>\r\n');
$templateCache.put('static/html/directives/download-nzbzip-button.html','<div class="btn-group pe-2 mb-2">\r\n    <button type="button" class="btn btn-default" ng-click="download()" id="download-selected-as-zip">\r\n        Results as ZIP\r\n    </button>\r\n</div>\r\n');
$templateCache.put('static/html/directives/downloader-status-footer.html','<div id="downloader-status-footer" style="margin-bottom: 0; padding-top: 0; margin-top: 5px">\n  <nav class="navbar-default" style="margin-left: 0; margin-right: 0">\n    <div class="row d-md-flex align-items-center" ng-show="foo">\n      <div class="col-xs-6 col-md-2">\n        <a href="{{::foo.url}}" target="_blank">\n          <img ng-src="static/img/{{::foo.downloaderImage}}.png"/>\n        </a>\n      </div>\n      <div class="col-xs-14 col-md-4 text-left">\n        <div class="py-3" style="line-height: 15px;">\n          <span class="glyphicon glyphicon-{{foo.buttonClass}}" tooltip-placement="auto top" uib-tooltip="{{foo.state}}" style="margin-right: 10px"></span>\n          <span ng-show="foo.state === \'Downloading\' && foo.downloadRateFormatted">{{foo.downloadRateFormatted}} &bull; {{foo.remainingTimeFormatted}}  &bull; </span><span\n          ng-show="foo.state !== \'Offline\'">{{foo.elementsInQueue}} in queue</span>\n        </div>\n      </div>\n      <div class="col-xs-20 col-md-14">\n        <div class="row d-md-flex align-items-center">\n          <div class="col-xs-20 col-md-12 col-lg-13 col-xl-14">\n            <div class="py-3" style="line-height: 15px;" ng-show="foo.downloadingTitle">\n              {{foo.downloadingTitle}} ({{foo.downloadingTitlePercentFinished}}%<span ng-show="foo.downloadingTitleRemainingTimeFormatted"> &bull; {{foo.downloadingTitleRemainingTimeFormatted}}</span>)\n            </div>\n          </div>\n          <div class="col-xs-20 col-md-8 col-lg-7 col-xl-6 downloader-status" ng-show="foo.state !== \'Offline\'">\n            <chart>\n              <nvd3 options="downloaderChart.options" data="downloaderChart.data" api="api" config="downloaderChart.config"></nvd3>\n            </chart>\n          </div>\n        </div>\n      </div>\n    </div>\n  </nav>\n</div>\n');
$templateCache.put('static/html/directives/footer.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div downloader-status-footer ng-if="showDownloaderStatus">\n</div>\n<span hydra-checks-footer>\n</span>');
$templateCache.put('static/html/directives/indexer-input.html','<form class="form-inline form-indexer" style="margin-bottom: 30px;">\r\n  <button ng-click="onClick(indexer, model)" class="btn btn-secondary indexer-button indexer-input btn-default"\r\n          ng-class="{\'config-incomplete\': !indexer.configComplete, \'not-all-checked\': (indexer.configComplete && !indexer.allCapsChecked)}" style="{{style}}"\r\n  >{{ indexer.name }}\r\n  </button>\r\n  <indexer-state-switch indexer="indexer" handle-width="135px"></indexer-state-switch>\r\n  <div class="form-group" style="margin-left: 10px">\r\n    <div class="input-group">\r\n      <input type="number" keep-focus ng-model="indexer.score" class="form-control"\r\n             style="width: 49px; height: 34px;">\r\n      <span class="input-group-addon">Priority</span>\r\n    </div>\r\n  </div>\r\n  <div class="input-group" ng-if="expiryWarning" style="display: inline; position: absolute; margin-top: 8px; margin-left: 10px">\r\n    <span tooltip-placement="right" uib-tooltip="{{::expiryWarning}}" class="glyphicon glyphicon-exclamation-sign"></span>\r\n  </div>\r\n\r\n</form>\r\n');
$templateCache.put('static/html/directives/indexer-selection-button.html','<!--\r\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\r\n  ~\r\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\r\n  ~  you may not use this file except in compliance with the License.\r\n  ~  You may obtain a copy of the License at\r\n  ~\r\n  ~      http://www.apache.org/licenses/LICENSE-2.0\r\n  ~\r\n  ~  Unless required by applicable law or agreed to in writing, software\r\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\r\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n  ~  See the License for the specific language governing permissions and\r\n  ~  limitations under the License.\r\n  -->\r\n\r\n<div class="btn-group">\r\n    <button class="btn selection-button-invert-selection btn-default" ng-click="invertSelection()">Invert selection\r\n    </button>\r\n    <button type="button" class="btn dropdown-toggle selection-button-toggle-dropdown btn-default"\r\n            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\r\n        <span class="caret"></span>\r\n        <span class="sr-only">Toggle Dropdown</span>\r\n    </button>\r\n    <ul class="dropdown-menu">\r\n        <li><a href="#" ng-click="reset()" class="selection-button-reset-selection">Reset to preselection</a></li>\r\n        <li><a href="#" ng-click="selectAll()" class="selection-button-select-all">Select all</a></li>\r\n        <li><a href="#" ng-click="deselectAll()" class="selection-button-deselect-all">Deselect all</a></li>\r\n        <li><a href="#" ng-if="::anyTorrentIndexersSelectable" ng-click="selectAllUsenet()"\r\n               class="selection-button-select-usenet">Select all usenet indexers</a></li>\r\n        <li><a href="#" ng-if="::anyTorrentIndexersSelectable" ng-click="selectAllTorrent()"\r\n               class="selection-button-select-torrent">Select all torrent indexers</a></li>\r\n    </ul>\r\n</div>');
$templateCache.put('static/html/directives/indexer-state-switch.html','<!--\r\n~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\r\n~\r\n~  Licensed under the Apache License, Version 2.0 (the "License");\r\n~  you may not use this file except in compliance with the License.\r\n~  You may obtain a copy of the License at\r\n~\r\n~      http://www.apache.org/licenses/LICENSE-2.0\r\n~\r\n~  Unless required by applicable law or agreed to in writing, software\r\n~  distributed under the License is distributed on an "AS IS" BASIS,\r\n~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n~  See the License for the specific language governing permissions and\r\n~  limitations under the License.\r\n-->\r\n<input bs-switch type="checkbox" ng-model="value" switch-change="onChange()" switch-active="{{indexer.configComplete}}"\r\n       switch-on-text="Enabled" switch-off-text="{{offText}}" switch-off-color="{{ offColor }}"\r\n       switch-handle-width="{{handleWidth}}" switch-label-width="20px"/>');
$templateCache.put('static/html/directives/log.html','<uib-tabset active="active">\r\n    <uib-tab index="0" heading="Formatted" ng-click="select(0)">\r\n        <div cg-busy="{promise:logPromise,message:\'Loading log file\'}">\r\n            <div style="margin-bottom: 15px">\r\n                <button class="btn btn-default" ng-click="update()">Update</button>\r\n            </div>\r\n\r\n            <!--<pre ng-bind-html="log" style="text-align: left; height: 65vh; overflow-y: scroll" id="logfile"></pre>-->\r\n            <div style="margin-bottom: 10px">\r\n                <button class="btn btn-default" ng-click="getNewerFormatted()" ng-disabled="currentJsonIndex === 0">Get\r\n                    newer entries\r\n                </button>\r\n                <button class="btn btn-default" ng-click="getOlderFormatted()" ng-disabled="!hasMoreJsonLines">Get older\r\n                    entries\r\n                </button>\r\n            </div>\r\n            <div class="table-responsive">\r\n                <table class="table table-hover" style="margin-bottom: 20px">\r\n                    <thead class="search-results-header">\r\n                    <tr>\r\n                        <th style="width: 11%">Time (newest first)</th>\r\n                        <th style="width: 3%">Level</th>\r\n                        <th style="width: 15%">Logger</th>\r\n                        <th style="width: 71%; overflow: hidden">Message</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody class="log">\r\n                    <tr ng-repeat="line in jsonLogLines" ng-click="openModal(line)">\r\n                        <td class="log-line">{{::line["@timestamp"] | formatTimestamp}}</td>\r\n                        <td class="log-line">\r\n                            <div ng-switch on="line.level">\r\n                                <div class="fa fa-info-circle" ng-switch-when="INFO"></div>\r\n                                <div class="fa fa-warning warning" ng-switch-when="WARN"></div>\r\n                                <div class="fa fa-times-circle error" ng-switch-when="ERROR"></div>\r\n                            </div>\r\n                        </td>\r\n                        <td class="log-line">{{line.logger_name | formatClassname}}</td>\r\n                        <td class="log-line">\r\n                            <div class="text-break">\r\n                                {{::line.message}}\r\n                            </div>\r\n                        </td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n            </div>\r\n            <div style="margin-bottom: 20px">\r\n                <button class="btn btn-default" ng-click="getNewerFormatted()" ng-disabled="currentJsonIndex === 0">Get\r\n                    newer entries\r\n                </button>\r\n                <button class="btn btn-default" ng-click="getOlderFormatted()" ng-disabled="!hasMoreJsonLines">Get older\r\n                    entries\r\n                </button>\r\n            </div>\r\n        </div>\r\n    </uib-tab>\r\n\r\n\r\n    <uib-tab index="1" heading="Raw" ng-click="select(1)">\r\n        <div cg-busy="{promise:logPromise,message:\'Loading log file\'}">\r\n            <div style="margin-bottom: 15px">\r\n                <button class="btn btn-default" ng-click="update()">Update</button>\r\n                <button class="btn btn-default" ng-click="scrollToBottom()">Scroll to bottom</button>\r\n                <label>\r\n                    <input type="checkbox" ng-model="doUpdateLog" ng-change="toggleUpdate(doUpdateLog)">\r\n                    Update every five seconds...\r\n                </label>\r\n                <label>\r\n                    <input type="checkbox" ng-model="doTailLog" ng-change="toggleTailLog()">\r\n                    and scroll to end\r\n                </label>\r\n            </div>\r\n\r\n            <pre ng-bind-html="log" style="text-align: left; height: 65vh; overflow-y: scroll" id="logfile"></pre>\r\n        </div>\r\n    </uib-tab>\r\n\r\n    <uib-tab index="2" heading="Files" ng-click="select(2)">\r\n        <div class="row">\r\n            <div class="col-md-6"></div>\r\n            <div class="col-md-8" style="text-align: left">\r\n                <ul>\r\n                    <li ng-repeat="filename in logfilenames">\r\n                        <a href="internalapi/debuginfos/downloadlog?logfilename={{filename}}" target="_blank">{{filename}}</a>\r\n                    </li>\r\n                </ul>\r\n            </div>\r\n        </div>\r\n\r\n    </uib-tab>\r\n\r\n</uib-tabset>\r\n\r\n\r\n<script type="text/ng-template" id="log-entry.html">\r\n    <div class="modal-header">\r\n        <h3 class="modal-title">Log entry details</h3>\r\n    </div>\r\n    <div class="modal-body" style="text-align: left;">\r\n        Message\r\n        <pre ng-bind-html="::entry.message"></pre>\r\n\r\n        <div ng-if="entry.IPADDRESS || entry.USERNAME" style="margin-bottom: 10px; margin-top: 15px">\r\n            <div ng-if="entry.IPADDRESS">Accessing IP address: {{entry.IPADDRESS}}</div>\r\n            <div ng-if="entry.USERNAME">Accessing Username: {{entry.USERNAME}}</div>\r\n        </div>\r\n\r\n        <span ng-if="entry.stack_trace">\r\n            Stacktrace\r\n            <pre ng-bind-html="::entry.stack_trace" style="overflow-y: scroll; width: 100%; max-height: 600px"></pre>\r\n        </span>\r\n    </div>\r\n    <div class="modal-footer">\r\n        <button class="btn btn-primary" type="button" ng-click="ok()">Close</button>\r\n    </div>\r\n</script>\r\n');
$templateCache.put('static/html/directives/multiselect-dropdown.html','<!--Fork of https://github.com/dotansimha/angularjs-dropdown-multiselect to make it compatible with formly-->\n\n<div class="multiselect-parent btn-group dropdown-multiselect dropdown ng-class:settings.classes"\n     ng-class="{open: open}">\n    <div ng-transclude=toggleDropdown ng-click=toggleDropdown()>\n        <button ng-disabled=disabled type=button class="btn btn-default dropdown-toggle">{{buttonText}}&nbsp;<span\n                class=caret style="position: absolute; left: 90%; top: 45%;"></span></button>\n    </div>\n    <ul class="dropdown-menu dropdown-menu-form" ng-if=open\n        ng-style="{display: open ? \'block\' : \'none\', height : \'auto\', overflow: \'auto\' }">\n        <li ng-if="settings.showSelectAll">\n            <a data-ng-click=selectAll() tabindex=-1 id=selectAll>\n                <span class="glyphicon glyphicon-ok"></span>\n                Select all\n            </a>\n        </li>\n        <li ng-if="settings.showDeselectAll">\n            <a data-ng-click=deselectAll(); tabindex=-1 id=deselectAll>\n                <span class="glyphicon glyphicon-remove"></span>\n                Deselect all\n            </a>\n        </li>\n\n        <li class=divider ng-if="settings.showSelectAll || settings.showDeselectAll"></li>\n        <li ng-class="{\'active\': isChecked(option) && settings.styleActive}" role=presentation\n            ng-repeat="option in options">\n            <a role=menuitem class=option tabindex=-1 ng-click="toggleItem(option)">\n                <span data-ng-class="{\'glyphicon glyphicon-ok\': selectedModel.indexOf(option.id) > -1}"></span>\n                {{option.label}}\n            </a>\n        </li>\n    </ul>\n</div>');
$templateCache.put('static/html/directives/news.html','<div class="row d-sm-flex justify-content-center">\n  <div class="col-xs-20 col-md-12">\n        <div class="panel panel-default " ng-repeat="entry in news">\n            <div class="panel-heading">\n                <h3 class="panel-title">\n                    {{entry.version}}\n                    <span style="font-size: smaller">\n                        <span ng-if="entry.forCurrentVersion">(This version)</span>\n                        <span ng-if="entry.forNewerVersion">(Newer version)</span>\n                    </span>\n                </h3>\n            </div>\n            <div class="panel-body" ng-bind-html="entry.news">\n            </div>\n        </div>\n\n        <div class="text-center">\n            <h3 ng-if="news.length == 0">No news yet ;-)</h3>\n        </div>\n    </div>\n</div>\n');
$templateCache.put('static/html/directives/save-or-send-file.html','<span ng-if="::enableButton">\r\n    <a href="#" ng-click="add()" uib-tooltip="{{::tooltip}}"\r\n       tooltip-placement="top"\r\n       tooltip-trigger="mouseenter" class="no-underline">\r\n        <span class="icon addable-nzb glyphicon" ng-class="cssClass"></span>\r\n    </a>\r\n</span>\r\n\r\n');
$templateCache.put('static/html/directives/search-result.html','<tr ng-class="{\'duplicate\' : result.duplicateGroupIndex > 0, \'title-group-expanded\': result.titleGroupIndex > 0} "\n    style="margin:0; border-width: 0; padding: 0" ng-if="resultDisplayed" class="search-result-row">\n  <td class="col-md-13 text-break search-results-cell result-title" style="margin:0;" data-label="Title">\n    <div class="d-flex">\n      <div class="d-flex align-items-center justify-content-space-around title-actions me-2">\n        <input type="checkbox"\n               ng-model="foo.selected"\n               ng-click="clickCheckbox($event, result)" data-checkbox-index="0" class="result-checkbox mt-0"/>\n        <a href="" ng-click="toggleTitleExpansion()"\n           ng-class="{\'visibility-hidden\': (result.titlesLength === 1 || result.titleGroupIndex > 0 || result.duplicateGroupIndex > 0)}"\n           class="title-expand-toggle mx-2"\n           uib-tooltip="Click to see or hide all results with the same title"\n           tooltip-placement="top"\n           tooltip-trigger="mouseenter"\n           style="text-decoration: none">\n          <span class="glyphicon" ng-class="{\'glyphicon-minus\': titlesExpanded, \'glyphicon-plus\': !titlesExpanded}"></span>\n        </a>\n      </div>\n      <a ng-if="foo.duplicatesDisplayed" href="" ng-click="toggleDuplicateExpansion()"\n         ng-class="{\'visibility-hidden\': (result.duplicatesLength == 1 || result.duplicateGroupIndex > 0)}"\n         class="duplicate-expand-toggle"\n         uib-tooltip="Click to see or hide all duplicates of this result"\n         tooltip-placement="right"\n         tooltip-trigger="mouseenter" style="text-decoration: none">\n        <!-- Formatting must be so weird because otherwise we\'ll have leading whitespaces in the titles   -->\n        <span class="glyphicon" ng-class="{\'glyphicon-minus\': duplicatesExpanded, \'glyphicon-plus\': !duplicatesExpanded}"></span>\n      </a>\n      <span class="title">{{result.alwaysShowTitles}}<span\n        ng-if="(result.titleGroupIndex === 0 && result.duplicateGroupIndex === 0) || searchResultsControllerShared.isGroupEpisodes || foo.alwaysShowTitles"><img\n        ng-if="result.cover && foo.showCovers" ng-src="{{::result.cover}}" width="{{::coverSize}}px" style="margin-right: 5px" ng-click="showCover(result.cover)"/><span\n        ng-if="result.downloadedAt && searchResultsControllerShared.showDownloadedIndicator" class="fa fa-check" uib-tooltip="Already downloaded at {{::result.downloadedAt}}"\n        tooltip-placement="top" tooltip-trigger="mouseenter"></span>{{ ::result.title }}</span>\n      </span>\n      <span class="badge" ng-if="result.torrentDownloadFactor">{{::result.torrentDownloadFactor}}</span>\n    </div>\n  </td>\n  \n  <td class="col-md-1 search-results-cell result-indexer text-right" data-label="Indexer">\n    {{ ::result.indexer }}\n  </td>\n  <td class="col-md-1 search-results-cell result-category text-right" data-label="Category">\n    {{ ::result.category }}\n  </td>\n  <td class="col-md-1 search-results-cell result-size text-right" data-label="Size">\n    {{ ::result.size | byteFmt: 2 }}\n  </td>\n  <td class="col-md-1 search-results-cell result-details text-right" data-label="Details">\n    <span ng-if="::(result.grabs !== null)">\n        {{ ::result.grabs | kify }}\n    </span>\n    <span ng-if="::result.grabs !== null && result.seeders !== null">\n         /\n    </span>\n    <span ng-if="::result.seeders !== null">\n        {{ ::result.seeders | kify }} / {{ ::result.peers | kify }}\n    </span>\n  </td>\n  <td class="col-md-1 search-results-cell result-age text-right" data-label="Age">\n    <span uib-tooltip="{{ ::result.date }}"\n          tooltip-placement="top"\n          tooltip-trigger="mouseenter">{{ ::result.age }}</span>\n  </td>\n  <td class="col-md-2 search-results-cell result-links" data-label="Links">\n    <div>\n      <a href ng-click="showNfo(result)" ng-class="::{\'no-nfo\': result.hasNfo === \'NO\'}"\n         class="no-underline result-show-nfo-link"\n         uib-tooltip="{{ ::getNfoTooltip() }}"\n         tooltip-placement="top"\n         tooltip-trigger="mouseenter">\n        <i class="fa fa-file-text" aria-hidden="true" ng-class="::{\'fuzzy-nfo\': result.hasNfo == \'MAYBE\'}"\n           style="margin-left:3px; margin-right:3px; vertical-align: middle"></i>\n      </a>\n      <span ng-if="::showDetailsDl">\n        <a ng-if="result.source" target="_blank" href="{{ ::result.source | binsearch | dereferer}}"\n           style="vertical-align: middle" class="no-underline result-details-link"\n           uib-tooltip="Search via Binsearch"\n           tooltip-placement="top"\n           tooltip-trigger="mouseenter">\n            <i class="fa fa-search" aria-hidden="true" style="margin-left:3px; margin-right:3px; vertical-align: middle"></i>\n        </a>\n\n            <a ng-class="::{\'no-nfo\': !result.comments}" href="{{::result.details_link | dereferer}}" target="_blank"\n               class="no-underline result-comments-link"\n               uib-tooltip="Comments"\n               tooltip-placement="top"\n               tooltip-trigger="mouseenter">\n            <i class="fa fa-comment" aria-hidden="true" style="margin-left:0; margin-right:3px;"></i>\n        </a>\n\n        <a target="_blank" href="{{ ::result.details_link | dereferer}}" ng-class="::{\'no-nfo\': !result.details_link}"\n           style="vertical-align: middle" class="no-underline result-details-link"\n           uib-tooltip="Details"\n           tooltip-placement="top"\n           tooltip-trigger="mouseenter">\n            <i class="fa fa-info" aria-hidden="true"\n               style="margin-left:3px; margin-right:3px; vertical-align: middle"></i>\n        </a>\n        \n        </a>\n    </span>\n      <span ng-switch on="::result.downloadType">\n        <span ng-switch-when="TORBOX">\n          <addable-nzbs searchresult="::result"></addable-nzbs>\n        </span>\n        <span ng-switch-when="TORRENT">\n            <a target="_blank" href="gettorrent/user/{{ ::result.searchResultId }}"\n               style="vertical-align: middle; margin-left: 3px; margin-right: 3px"\n               class="no-underline result-torrent-download-link"\n               uib-tooltip="Download torrent"\n               tooltip-placement="top"\n               tooltip-trigger="mouseenter"><span class="glyphicon glyphicon-save"></span>\n            </a>\n          <addable-nzbs searchresult="::result"></addable-nzbs>\n        </span>\n        <save-or-send-file ng-if="result.downloadType!=\'TORBOX\'" search-result-id="result.searchResultId" type="result.downloadType"></save-or-send-file>\n          <span ng-switch-default>\n              <a target="_blank" href="getnzb/user/{{ ::result.searchResultId }}"\n                 style="vertical-align: middle; margin-left: 3px; margin-right: 3px"\n                 class="no-underline result-nzb-download-link"\n                 uib-tooltip="Download NZB"\n                 tooltip-placement="top"\n                 tooltip-trigger="mouseenter"><span class="glyphicon glyphicon-save"></span>\n              </a>\n              <addable-nzbs searchresult="::result"></addable-nzbs>\n          </span>\n      </span>\n    </div>\n  </td>\n</tr>\n');
$templateCache.put('static/html/directives/selection-button.html','<div class="btn-group">\r\n    <button class="btn selection-button-invert-selection" ng-class="\'btn-\' + btn" ng-click="invertSelection()">Invert\r\n        selection\r\n    </button>\r\n    <button type="button" class="btn dropdown-toggle selection-button-toggle-dropdown" ng-class="\'btn-\' + btn"\r\n            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\r\n        <span class="caret"></span>\r\n        <span class="sr-only">Toggle Dropdown</span>\r\n    </button>\r\n    <ul class="dropdown-menu">\r\n        <li><a href="#" ng-click="selectAll(true)" class="selection-button-select-all">Select all</a></li>\r\n        <li><a href="#" ng-click="deselectAll(false)" class="selection-button-deselect-all">Deselect all</a></li>\r\n    </ul>\r\n</div>');
$templateCache.put('static/html/directives/tab-or-chart.html','<div>\r\n    <ul class="nav nav-tabs">\r\n        <li ng-class="{\'active\': display == \'chart\'}"><a href="#" ng-click="display = \'chart\'">Chart</a></li>\r\n        <li ng-class="{\'active\': display == \'table\'}"><a href="#" ng-click="display = \'table\'">Table</a></li>\r\n    </ul>\r\n\r\n\r\n    <div ng-show="display == \'chart\'">\r\n        <div ng-transclude="chartSlot"></div>\r\n    </div>\r\n\r\n\r\n    <div ng-show="display == \'table\'">\r\n        <div ng-transclude="tableSlot"></div>\r\n    </div>\r\n</div>');
$templateCache.put('static/html/directives/tasks.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div class="text-left row d-sm-flex justify-content-center">\n    <div class="col-xs-20 col-md-14" style="margin-top: 50px">\n        <span style="text-align: center"><h3>Tasks</h3></span>\n        <div class="table-responsive">\n            <table class="table">\n                <tr class="row">\n                    <th class="col-md-10" style="text-align: left">Name</th>\n                    <th class="col-md-5" style="text-align: left">Last execution</th>\n                    <th class="col-md-5" style="text-align: left">Next execution</th>\n                </tr>\n                <tr ng-repeat="task in tasks" class="row">\n                    <td class="col-md-10" style="text-align: left"><a ng-click="runTask(task.name)" class="glyph-link"><span\n                            class="glyphicon glyphicon-play-circle"></span> {{task.name}}</a></td>\n                    <td class="col-md-5" style="text-align: left"><span ng-show="task.lastExecutionTime"\n                                                                        uib-tooltip="{{task.lastExecutionTime | reformatDateSeconds}}">{{ task.lastExecutionTime | humanizeDate }}</span>\n                    </td>\n                    <td class="col-md-5" style="text-align: left"><span\n                            uib-tooltip="{{task.nextExecutionTime | reformatDateSeconds}}">{{task.nextExecutionTime | humanizeDate}}</span>\n                    </td>\n                </tr>\n            </table>\n        </div>\n    </div>\n</div>\n');
$templateCache.put('static/html/directives/updates.html','<div cg-busy="{promise:loadingPromise,message:\'Loading versions and changelog\'}">\n\n  Current version: {{ currentVersion }}\n  <br>\n  Latest version: {{ latestVersion }} <span ng-if="latestVersionIsBeta">Beta</span>\n  <span ng-if="betaUpdateAvailable">\n        <br>\n        Latest beta version: {{ betaVersion }}\n      </span>\n  <br>\n    <div ng-if="updatedExternally" class="alert alert-warning" role="alert"\n         style="margin-bottom: 0; padding-top: 0; margin-top: 5px">\n        <br>\n        Your NZBHydra instance seems to run in docker or is installed via a package manager. Please update this instance accordingly instead of using the NZBHydra update mechanism.\n    </div>\n  <div ng-if="updateAvailable">\n    <br>\n    A new release ({{ latestVersion }} <span ng-if="latestVersionIsBeta">Beta</span>) is available.\n    <br>\n    <button class="btn btn-info" type="button" ng-click="showChangelog(latestVersion)">See what\'s new</button>\n    <button class="btn btn-success" type="button" ng-click="update(latestVersion)">Install update</button>\n  </div>\n  <div ng-if="betaUpdateAvailable">\n    <br>\n    A new beta release ({{ betaVersion }}) is available.\n    <br>\n    <button class="btn btn-info" type="button" ng-click="showChangelog(betaVersion)">See what\'s new</button>\n    <button class="btn btn-warning" type="button" ng-click="update(betaVersion)">Install beta update</button>\n  </div>\n  <br>\n  <span ng-if="!updateAvailable && !latestVersionIgnored && !betaUpdateAvailable">You\'re up to date!</span>\n  <span ng-if="latestVersionIgnored">The latest version was ignored by you.</span>\n  <button ng-if="!updateAvailable && !betaUpdateAvailable" class="btn btn-warning" type="button" ng-click="forceUpdate()">Force update\n  </button>\n\n    <div class="row">\n    <div class="col-md-4"></div>\n    <div ng-if="wrapperOutdated" class="col-md-12 alert alert-warning" role="alert" style="margin-top: 20px">\n      The NZBHydra wrappers (i.e. the executables or python scripts you use to run NZBHydra) seem to be outdated.Please update them.<br><br>\n      Shut down NZBHydra, <a href="https://github.com/theotherp/nzbhydra2/releases/latest">download the latest version</a> and extract all the relevant wrapper files into your main NZBHydra folder.<br>\n      For Windows these files are:\n      <ul>\n        <li>NZBHydra2.exe</li>\n        <li>NZBHydra2 Console.exe</li>\n      </ul>\n      For linux or macOS these files are:\n      <ul>\n        <li>nzbhydra2wrapper.py</li>\n        <li>nzbhydra2wrapperPy3.py</li>\n      </ul>\n      Make sure to overwrite all of these files that already exist - you don\'t need to update any files that aren\'t already present. If you added any of the other listed files manually make sure to update them as well!\n      <br><br>\n      Afterwards start NZBHydra again.\n    </div>\n  </div>\n\n    <ng-include src="\'static/html/directives/version-history.html\'"></ng-include>\n</div>\n');
$templateCache.put('static/html/directives/version-history.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div class="panel panel-default " style="margin-top: 50px; text-align: left">\n  <div class="panel-heading"><h3>Version history</h3></div>\n  <div class="list-group">\n    <li ng-repeat="entry in versionHistory" class="list-group-item text-break"\n        style="padding-top: 20px; padding-bottom: 20px;">\n      <h3 style="margin-top: 0">{{::entry.version}}<span ng-if="!entry.final"> Beta</span> ({{::entry.date}})</h3>\n      <div ng-repeat="change in entry.changes" style="margin-bottom: 5px">\n              <span ng-switch="change.type" style="margin-right: 5px">\n                  <span class="label label-primary" ng-switch-when="note">Note</span>\n                  <span class="label label-warning" ng-switch-when="fix">Fix</span>\n                  <span class="label label-success" ng-switch-when="feature">Feature</span>\n              </span>\n        <span ng-bind-html="change.text  | unsafe"></span>\n      </div>\n    </li>\n  </div>\n</div>\n');
$templateCache.put('static/html/dirPagination.tpl.html','<ul class="pagination" ng-if="1 < pages.length || !autoHide">\r\n    <li ng-if="boundaryLinks" ng-class="{ disabled : pagination.current == 1 }">\r\n        <a href="" ng-click="setCurrent(1)">&laquo;</a>\r\n    </li>\r\n    <li ng-if="directionLinks" ng-class="{ disabled : pagination.current == 1 }">\r\n        <a href="" ng-click="setCurrent(pagination.current - 1)">&lsaquo;</a>\r\n    </li>\r\n    <li ng-repeat="pageNumber in pages track by tracker(pageNumber, $index)"\r\n        ng-class="{ active : pagination.current == pageNumber, disabled : pageNumber == \'...\' }">\r\n        <a href="" ng-click="setCurrent(pageNumber)">{{ pageNumber }}</a>\r\n    </li>\r\n\r\n    <li ng-if="directionLinks" ng-class="{ disabled : pagination.current == pagination.last }">\r\n        <a href="" ng-click="setCurrent(pagination.current + 1)">&rsaquo;</a>\r\n    </li>\r\n    <li ng-if="boundaryLinks" ng-class="{ disabled : pagination.current == pagination.last }">\r\n        <a href="" ng-click="setCurrent(pagination.last)">&raquo;</a>\r\n    </li>\r\n</ul>');
$templateCache.put('static/html/file-selection.html','<div class="modal-header">\n    <h3 class="modal-title">{{::showType}} selection</h3>\n</div>\n<div class="modal-header">\n    {{data.fullPath}}\n</div>\n<div class="modal-body" style="text-align: left">\n    <span ng-show="data.hasParent">\n        <a href="#" ng-click="goUp()">...</a>\n    </span>\n    <div ng-repeat="folder in data.folders">\n        <span class="glyphicon glyphicon-folder-open" style="margin-right: 8px"></span>\n        <a href="#" ng-click="select(folder, \'folder\')">{{::folder.name}}</a>\n    </div>\n    <div ng-repeat="file in data.files">\n        <span class="glyphicon glyphicon-file" style="margin-right: 8px"></span>\n        <a href="#" ng-click="select(file, \'file\')">{{::file.name}}</a>\n    </div>\n</div>\n<div class="modal-footer" ng-show="type === \'folder\'">\n    <div class="row">\n        <span class="col-md-15" style="text-align: left">\n        </span>\n        <span class="col-md-5">\n            <button class="btn btn-default" ng-click="submit()">\n                Select\n            </button>\n        </span>\n    </div>\n</div>\n');
$templateCache.put('static/html/migration-modal.html','<div class="modal-header">\n    <h3 class="modal-title">Migration from NZBHydra 1</h3>\n</div>\n<div class="modal-body" style="text-align: left">\n    <span ng-show="!foo.isMigrating">\n        <p>Migration from NZBHydra v1 was removed in version 2.10.3. Please manually download and run <a href="https://github.com/theotherp/nzbhydra2/releases/tag/v2.10.2">the latest version</a> which supports migration, migrate that and then update.</p>\n    </span>\n\n</div>\n<div class="modal-footer">\n    <button class="btn btn-warning" type="button" ng-click="cancel()">Ok</button>\n</div>');
$templateCache.put('static/html/modal.html','<div class="modal-header">\r\n    <h3 class="modal-title">{{ headline }}</h3>\r\n</div>\r\n<div class="modal-body" style="text-align: {{textAlign}}">\r\n    <span ng-bind-html="message | unsafe"></span>\r\n\r\n</div>\r\n<div class="modal-footer">\r\n    <button class="btn btn-success" type="button" ng-click="yes()">{{ params.yes.text }}</button>\r\n    <button class="btn btn-danger" type="button" ng-if="showNo" ng-click="no()">{{ params.no.text }}</button>\r\n    <button class="btn btn-warning" type="button" ng-if="showCancel" ng-click="cancel()">{{ params.cancel.text }}\r\n    </button>\r\n</div>\r\n');
$templateCache.put('static/html/news-modal.html','<div class="modal-header">\n    <h3 class="modal-title">News</h3>\n</div>\n<div class="modal-body" style="text-align: left">\n    <div class="panel panel-default " ng-repeat="entry in news track by $index">\n        <div class="panel-heading">\n            <h3 class="panel-title">{{entry.version}}</h3>\n        </div>\n        <div class="panel-body" ng-bind-html="entry.news">\n        </div>\n    </div>\n\n</div>\n<div class="modal-footer">\n    <button class="btn btn-success" type="button" ng-click="close()">Close</button>\n</div>\n');
$templateCache.put('static/html/restart-modal.html','<div class="modal-header">\r\n    <h3 class="modal-title">Restarting...</h3>\r\n</div>\r\n<div class="modal-body" style="text-align: left">\r\n    {{message}} <img src="static/img/spinner.gif">\r\n</div>');
$templateCache.put('static/html/results-pagination.html','<ul class="pagination" ng-if="1 < pages.length || !autoHide">\r\n    <li ng-if="boundaryLinks" ng-class="{ disabled : pagination.current == 1 }">\r\n        <a href="" ng-click="setCurrent(1)">&laquo;</a>\r\n    </li>\r\n    <li ng-if="directionLinks" ng-class="{ disabled : pagination.current == 1 }">\r\n        <a href="" ng-click="setCurrent(pagination.current - 1)">&lsaquo;</a>\r\n    </li>\r\n    <li ng-repeat="pageNumber in pages track by tracker(pageNumber, $index)"\r\n        ng-class="{ active : pagination.current == pageNumber, disabled : pageNumber == \'...\' }">\r\n        <a href="" ng-click="setCurrent(pageNumber)">{{ pageNumber }}</a>\r\n    </li>\r\n\r\n    <li ng-if="directionLinks" ng-class="{ disabled : pagination.current == pagination.last }">\r\n        <a href="" ng-click="setCurrent(pagination.current + 1)">&rsaquo;</a>\r\n    </li>\r\n    <li ng-if="boundaryLinks" ng-class="{ disabled : pagination.current == pagination.last }">\r\n        <a href="" ng-click="setCurrent(pagination.last)">&raquo;</a>\r\n    </li>\r\n</ul>');
$templateCache.put('static/html/search-history-details-modal.html','<!--\r\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\r\n  ~\r\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\r\n  ~  you may not use this file except in compliance with the License.\r\n  ~  You may obtain a copy of the License at\r\n  ~\r\n  ~      http://www.apache.org/licenses/LICENSE-2.0\r\n  ~\r\n  ~  Unless required by applicable law or agreed to in writing, software\r\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\r\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n  ~  See the License for the specific language governing permissions and\r\n  ~  limitations under the License.\r\n  -->\r\n\r\n<div class="modal-body" style="text-align: left">\r\n   <span ng-show="!details">\r\n   <img src="static/img/spinner.gif">\r\n      Loading...\r\n   </span>\r\n    <table class="table" ng-if="details">\r\n        <caption>Details</caption>\r\n        <thead>\r\n        <tr>\r\n          <th>Host</th>\r\n            <th>User agent</th>\r\n        </tr>\r\n        </thead>\r\n        <tbody>\r\n        <tr>\r\n            <td>{{details.ip}}</td>\r\n            <td>{{details.userAgent}}</td>\r\n        </tr>\r\n        </tbody>\r\n    </table>\r\n\r\n    <table class="table" ng-if="details">\r\n        <caption>Related indexer searches</caption>\r\n        <thead>\r\n        <tr>\r\n            <th>Indexer</th>\r\n            <th>Successful</th>\r\n            <th>Results</th>\r\n        </tr>\r\n        </thead>\r\n        <tbody>\r\n        <tr ng-repeat="entry in details.indexerSearches">\r\n            <td>{{entry.indexerName}}</td>\r\n            <td>{{entry.successful}}</td>\r\n            <td>{{entry.resultsCount}}</td>\r\n        </tr>\r\n        </tbody>\r\n    </table>\r\n</div>\r\n\r\n');
$templateCache.put('static/html/search-searchhistory-dropdown.html','<ul class="dropdown-menu dropdown-menu-right" role="menu" uib-dropdown-menu aria-labelledby="button-template-url">\r\n  <li role="menuitem" ng-repeat="request in searchHistory">\r\n    <a href="#" ng-click="repeatSearch(request)"\r\n       x-draggable="true" data-request="{{request}}"\r\n       ng-bind-html="formatRequest(request)"\r\n       class="search-history-dropdown-entry"\r\n    ></a></li>\r\n</ul>\r\n');
$templateCache.put('static/html/search-state.html','<div class="modal-header">\r\n  <h3 style="display: inline-block" class="modal-title">Searching... please wait</h3>\r\n  <button class="btn {{btnType}}" type="button" ng-click="shortcutSearch()"\r\n          uib-tooltip="{{buttonTooltip}}"\r\n          tooltip-placement="top"\r\n          tooltip-trigger="mouseenter"\r\n          style="position: absolute; right: 18px"\r\n  >{{buttonText}}\r\n  </button>\r\n</div>\r\n\r\n<div class="modal-body" style="text-align: left;">\r\n  <img src="static/img/spinner.gif" ng-if="!messages && !indexerSelectionFinished"/>\r\n  \r\n  <div ng-if="messages" style="text-align: left">\r\n    \r\n    <ul style="padding-left: 0">\r\n      <li ng-repeat="message in messages" style="list-style-type: none">\r\n                <span ng-class="{\'indexerStatusHasResults\': hasResults(message)}">\r\n                  {{message.message}}\r\n                </span>\r\n      </li>\r\n    \r\n    </ul>\r\n    <img src="static/img/spinner.gif"/>\r\n  \r\n  </div>\r\n  <div style="margin-top: 15px; margin-bottom: -20px">\r\n    <div ng-if="indexerSelectionFinished">\r\n      Indexers finished:\r\n      <uib-progressbar max="indexersSelected" class="progress-striped active" value="indexersFinished">\r\n        {{indexersFinished}} / {{progressMax}}\r\n      </uib-progressbar>\r\n    </div>\r\n  </div>\r\n</div>\r\n<div class="modal-footer">\r\n    <span style="float: left; margin-top: 5px">\r\n        This window will close automatically when searching is finished\r\n    </span>\r\n</div>\r\n');
$templateCache.put('static/html/searchtemplate.html','');
$templateCache.put('static/html/states/config.html','<div class="row">\r\n  <form class="col-sm-20" name="form" name="ctrl.myform" novalidate>\r\n    <ul class="nav nav-tabs config-tabs" role="tablist" style="text-align: left">\r\n      <li ng-repeat="tab in allTabs" ng-class="{\'active\': $index == activeTab}">\r\n        <a href="" ng-click="goToConfigState($index)">{{ tab.name }}</a>\r\n      </li>\r\n      <li style="float: right">\r\n\r\n        <!--        We need to make this switch ourselves becase bs-switch will always make the model dirty-->\r\n        <div class="bootstrap-switch-off bootstrap-switch bootstrap-switch-advanced-toggle-wrapper bootstrap-switch-animate {{showAdvanced ? \'bootstrap-switch-on\' : \'bootstrap-switch-off\'}}"\r\n             style="width: 200px;" ng-click="toggleShowAdvanced()">\r\n          <div class="bootstrap-switch-container" style="width: 352px; margin-left: {{showAdvanced ? \'0\' : \'-154\'}}px;">\r\n            <span class="bootstrap-switch-handle-on bootstrap-switch-primary" style="width: 154px; opacity: 1">Advanced shown</span>\r\n            <span class="bootstrap-switch-label" style="width: 48px;">&nbsp;</span>\r\n            <span class="bootstrap-switch-handle-off bootstrap-switch-default" style="width: 154px;">Advanced hidden</span>\r\n            <input type="checkbox" ng-model="showAdvanced" class="ng-untouched ng-valid ng-not-empty ng-dirty" aria-invalid="false"></div>\r\n        </div>\r\n\r\n\r\n        <button ng-click="apiHelp()" class="btn config-button config-api-button btn-default">API?</button>\r\n        <button ng-click="submit()" class="btn config-button" ng-class="{\'btn-info\': isSavingNeeded(), \'pulse2\': isSavingNeeded(), \'btn-success\': !isSavingNeeded()}">\r\n          Save\r\n        </button>\r\n      </li>\r\n    </ul>\r\n\r\n    <div class="tab-content config">\r\n      <div ng-repeat="tab in allTabs">\r\n        <div class="config-tab-content">\r\n          <formly-form model="tab.model" fields="tab.fields" ng-if="$index == activeTab"\r\n                        options="tab.options">\r\n          </formly-form>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </form>\r\n</div>\r\n\r\n\r\n<script type="text/ng-template" id="ui-select-multiple.html">\r\n  <ui-select multiple data-ng-model="model[options.key]" data-required="{{ to.required }}"\r\n             data-disabled="{{ to.disabled }}" theme="bootstrap">\r\n    <ui-select-match class="ui-select-match" placeholder="{{ to.getPlaceholder(model[options.key]) }}">\r\n      {{$item[to.labelProp]}}\r\n    </ui-select-match>\r\n    <ui-select-choices class="ui-select-choices" data-repeat="{{ to.ngOptions }}">\r\n      <div ng-bind-html="option[to.labelProp] | highlight: $select.search"></div>\r\n    </ui-select-choices>\r\n  </ui-select>\r\n</script>\r\n\r\n<script type="text/ng-template" id="button-test-connection.html">\r\n  <span style="text-align: left;"><button class="btn btn-default" id="button-test-connection-{{ uniqueId }}"\r\n                                          type="button" ng-click="testConnection()"><span\r\n    class="glyphicon glyphicon-refresh"></span></button> <span\r\n    id="message-test-connection-{{ uniqueId }}"></span></span>\r\n</script>\r\n\r\n\r\n<script type="text/ng-template" id="button-check-caps.html">\r\n  <span style="text-align: left; float: left"><button class="btn btn-default" id="button-check-caps-{{ uniqueId }}"\r\n                                                      type="button" ng-click="checkCaps()"><span\r\n    class="glyphicon glyphicon-refresh"></span></button> <span\r\n    id="message-check-caps-{{ uniqueId }}"></span></span>\r\n</script>\r\n\r\n\r\n<script type="text/ng-template" id="newznab-preset.html">\r\n  <ui-select ng-model="selectedpreset" theme="bootstrap" on-select="selectPreset($item, $model)"\r\n             search-enabled="false">\r\n    <ui-select-match class="ui-select-match" allow-clear="true">{{ display }}</ui-select-match>\r\n    <ui-select-choices class="ui-select-choices" repeat="preset in presets">\r\n      <div ng-bind-html="preset.name"></div>\r\n    </ui-select-choices>\r\n  </ui-select>\r\n</script>\r\n\r\n<script type="text/ng-template" id="repeatSection.html">\r\n  <!--loop through each element in model array-->\r\n  <div class="{{ hideRepeat }} repeatWrapperClass" ng-show="model.showAdvanced || !to.advanced">\r\n    <legend style="overflow: hidden">\r\n   <span class="config-fieldset-legend">{{to.headline}}\r\n       <span class="glyphicon glyphicon-question-sign" ng-if="::options.templateOptions.tooltip"\r\n             uib-popover-html="options.templateOptions.tooltip"\r\n             popover-trigger="\'outsideClick\'"\r\n             style="font-size: 15px; cursor: pointer"></span>\r\n</span>\r\n    </legend>\r\n\r\n    <div class="repeatsection modal-content" ng-repeat="element in model[options.key]"\r\n         ng-init="fields = copyFields(to.fields)">\r\n      <fieldset>\r\n        <legend>\r\n          <span class="config-fieldset-legend">\r\n            {{ element.name ? element.name : (element.username ? element.username : to.altLegendText)}}\r\n          </span>\r\n        </legend>\r\n        <formly-form fields="fields"\r\n                     model="element"\r\n                     form="form">\r\n        </formly-form>\r\n        <div style="margin-bottom:20px;">\r\n          <button type="button" class="btn btn-danger remove-button" ng-click="remove($index)">\r\n            Remove {{ element.name }}\r\n          </button>\r\n        </div>\r\n\r\n      </fieldset>\r\n    </div>\r\n    <hr class="repeat-hr">\r\n    <p class="addNewButton">\r\n      <button type="button" class="btn btn-primary add-button" ng-click="addNew()">{{ to.btnText }}</button>\r\n    </p>\r\n  </div>\r\n</script>\r\n\r\n<script type="text/ng-template" id="setting-wrapper.html">\r\n  <div class="setting-wrapper" ng-show="model.showAdvanced || !to.advanced">\r\n  <div class="form-group form-horizontal" ng-class="{\'row\': !options.templateOptions.noRow}">\r\n    <!--Test-->\r\n    <div class="col-xs-8 col-sm-4 text-right config-label pe-xs-0">\r\n      <label class="control-label align-middle justify-content-flex-end pt-0">\r\n        {{ to.label }} {{ to.required ? "*" : ""}}\r\n      </label>\r\n    </div>\r\n    <div class="col-xs-9 col-sm-6 config-content">\r\n      <!--Before transclude-->\r\n      <formly-transclude></formly-transclude>\r\n      <!--After transclude-->\r\n      <div class="my-messages" ng-messages="fc.$error" ng-if="options.formControl.$touched || form.$submitted"\r\n           ng-messages-multiple>\r\n        <div class="some-message has-error control-label" ng-message="{{::name}}"\r\n             ng-repeat="(name, message) in ::options.validation.messages">\r\n          {{ message(fc.$viewValue, fc.$modelValue, this)}}\r\n        </div>\r\n      </div>\r\n      <div class="my-messages">\r\n        <div class="some-message has-error control-label"\r\n             ng-repeat="message in ::options.validation.customMessages">\r\n          {{ message}}\r\n        </div>\r\n      </div>\r\n    </div>\r\n    <div class="col-xs-1 col-sm-1">\r\n      <div class="config-tooltip">\r\n        <div class="d-flex justify-content-center" ng-if="::to.tooltip" uib-popover-html="to.tooltip" popover-trigger="\'outsideClick\'" popover-placement="auto top">\r\n            <span class="glyphicon glyphicon-question-sign align-middle" style="cursor: pointer"></span>\r\n        </div>\r\n      </div>\r\n    </div>\r\n    <div class="col-xs-20 col-sm-9 config-help mt-xs-2">\r\n      <div class="help-block mx-xs-4">\r\n        <div class="align-middle">\r\n          <span ng-bind-html="to.help | derefererExtracting | unsafe" >\r\n              Help\r\n          </span>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  </div>\r\n</script>\r\n\r\n<script type="text/ng-template" id="fieldset-wrapper.html">\r\n  <fieldset ng-show="model.showAdvanced || !to.advanced">\r\n    <legend class="text-left">\r\n      <div class="col-sm-4"></div>\r\n      <div class="col-sm-16">\r\n        <div class="config-fieldset-legend py-3">{{options.templateOptions.label}}\r\n          <span class="glyphicon glyphicon-question-sign" ng-if="::options.templateOptions.tooltip"\r\n              uib-popover-html="options.templateOptions.tooltip"\r\n              tooltip-placement="auto top"\r\n              popover-trigger="\'outsideClick\'"\r\n              style="font-size: 15px; cursor: pointer"></span>\r\n        </div>\r\n      </div>\r\n    </legend>\r\n    <formly-transclude></formly-transclude>\r\n  </fieldset>\r\n</script>\r\n\r\n<script type="text/ng-template" id="notificationRepeatSection.html">\r\n  <!--loop through each element in model array-->\r\n  <div class="{{ hideRepeat }} repeatWrapperClass">\r\n    <legend><div class="config-fieldset-legend py-3">{{to.headline}}</div></legend>\r\n    <div class="repeatsection modal-content" ng-repeat="element in model[options.key]"\r\n         ng-init="fields = copyFields(to.fields)">\r\n      <fieldset>\r\n        <legend>\r\n          <span class="config-fieldset-legend">\r\n            {{ element.eventTypeReadable}}\r\n          </span>\r\n        </legend>\r\n        <formly-form fields="fields"\r\n                     model="element"\r\n                     form="form">\r\n        </formly-form>\r\n        <div style="margin-bottom:20px;">\r\n          <button type="button" class="btn btn-danger remove-button" ng-click="remove($index)">\r\n            Remove {{ element.name }}\r\n          </button>\r\n        </div>\r\n\r\n      </fieldset>\r\n    </div>\r\n    <hr>\r\n\r\n    <div class="btn-group" uib-dropdown is-open="status.isopen">\r\n      <button id="single-button" type="button" class="btn btn-primary" uib-dropdown-toggle ng-disabled="disabled">\r\n        Add new notification <span class="caret"></span>\r\n      </button>\r\n      <ul class="dropdown-menu" uib-dropdown-menu role="menu" aria-labelledby="single-button">\r\n        <li role="menuitem" ng-repeat="event in eventTypes"><a ng-click="addNew(event.key)">{{::event.label}}</a></li>\r\n      </ul>\r\n    </div>\r\n  </div>\r\n</script>\r\n\r\n<script type="text/ng-template" id="button-test-notification.html">\r\n  <span style="text-align: left; float: left">\r\n    <button class="btn btn-default" type="button" ng-click="testNotification()" uib-tooltip="Send a test notification. You need to save the config first." tooltip-placement="top" tooltip-trigger="mouseenter">\r\n      <span class="glyphicon glyphicon-eye-open"></span>\r\n    </button>\r\n  </span>\r\n</script>\r\n');
$templateCache.put('static/html/states/download-history.html','<div class="row" style="margin-top: 30px; margin-bottom: 20px">\n    <div class="col-md-5"></div>\n    <div class="col-md-10" style="text-align: center">\n        <dir-pagination-controls on-page-change="update()" pagination-id="downloads"></dir-pagination-controls>\n    </div>\n    <div class="col-md-5" style="text-align: right">\n        <button class="btn btn-default" ng-click="update()"><span class="glyphicon glyphicon-refresh"></span></button>\n    </div>\n</div>\n<div class="table-responsive">\n<table class="table">\n    <thead>\n    <tr>\n        <th class="col-md-2" style="width: {{columnSizes.time}}%;">\n            <column-sortable column="time" start-mode="2">Time\n            </column-sortable>\n            <column-filter-wrapper>\n                <time-filter column="time" selected="preselectedTimeInterval"/>\n            </column-filter-wrapper>\n        </th>\n        <th class="col-md-2" style="width: {{columnSizes.indexer}}%;">\n            <column-sortable column="name">Indexer\n            </column-sortable>\n            <column-filter-wrapper>\n                <checkboxes-filter column="name" entries="indexersForFiltering" preselect="true" show-invert="true"/>\n            </column-filter-wrapper>\n        </th>\n        <th class="col-md-8" style="width: {{columnSizes.title}}%;">\n            <column-sortable column="title">Title\n            </column-sortable>\n            <column-filter-wrapper>\n                <freetext-filter column="title"/>\n            </column-filter-wrapper>\n        </th>\n        <th class="col-md-1" style="width: {{columnSizes.result}}%;">\n            <column-sortable column="status">Result <span class="glyphicon glyphicon-question-sign"\n                                                          tooltip-placement="auto top"\n                                                          uib-tooltip="Actual download result only available downloader software configured in NZBHydra"></span></div>\n            </column-sortable>\n            <column-filter-wrapper>\n                <checkboxes-filter column="status" entries="statusesForFiltering" preselect="true" show-invert="false"/>\n            </column-filter-wrapper>\n        </th>\n        <th class="col-md-1" style="width: {{columnSizes.source}}%;">\n            <column-sortable column="access_source">Source\n            </column-sortable>\n            <column-filter-wrapper>\n                <boolean-filter column="access_source" options="accessOptionsForFiltering" preselect="0"/>\n            </column-filter-wrapper>\n        </th>\n        <th class="col-md-1" style="width: {{columnSizes.age}}%;">\n            <column-sortable column="age">Age</column-sortable>\n            <column-filter-wrapper>\n                <number-range-filter column="age"/>\n            </column-filter-wrapper>\n        </th>\n        <th class="col-md-2" style="width: {{columnSizes.username}}%;" ng-if="columnSizes.username > 0">\n            <column-sortable column="username">Username</column-sortable>\n            <column-filter-wrapper>\n                <freetext-filter column="username"/>\n            </column-filter-wrapper>\n        </th>\n        <th class="col-md-2" style="width: {{columnSizes.ip}}%" ng-if="columnSizes.ip > 0">\n            <column-sortable column="ip" reversed="false" start-mode="1">Host</column-sortable>\n            <column-filter-wrapper>\n                <freetext-filter column="ip"/>\n            </column-filter-wrapper>\n        </th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr dir-paginate="nzbDownload in nzbDownloads | itemsPerPage:limit" total-items="totalDownloads"\n        current-page="pagination.current" pagination-id="downloads">\n        <td class="narrow-row">{{ ::nzbDownload.time | reformatDate }}</td>\n        <td class="narrow-row">{{ ::nzbDownload.searchResult.indexer.name }}</td>\n        <td class="narrow-row">\n            <span ng-style="{\'visibility\':!nzbDownload.searchResult.indexerGuid ? \'hidden\' : \'initial\'}">\n                <save-or-send-file search-result-id="nzbDownload.searchResult.id" type="nzbDownload.searchResult.downloadType"></save-or-send-file>\n                <span ng-switch on="::nzbDownload.searchResult.downloadType">\n                    <span ng-switch-when="TORRENT">\n                        <a target="_blank" href="gettorrent/user/{{ ::nzbDownload.searchResult.id }}"\n                           style="vertical-align: middle; margin-left: 3px; margin-right: 3px"\n                           class="no-underline result-torrent-download-link"\n                           uib-tooltip="Download torrent"\n                           tooltip-placement="top"\n                           tooltip-trigger="mouseenter"><span class="glyphicon glyphicon-save"></span>\n                        </a>\n                    </span>\n                    <span ng-switch-default>\n                        <a target="_blank" href="getnzb/user/{{ ::nzbDownload.searchResult.id }}"\n                           style="vertical-align: middle; margin-left: 3px; margin-right: 3px"\n                           class="no-underline result-nzb-download-link"\n                           uib-tooltip="Download NZB"\n                           tooltip-placement="top"\n                           tooltip-trigger="mouseenter"><span class="glyphicon glyphicon-save"></span>\n                        </a>\n                        <addable-nzbs searchresult="::nzbDownload.searchResult" always-ask="true"></addable-nzbs>\n                    </span>\n                </span>\n                <a target="_blank" href="{{ ::nzbDownload.searchResult.details | dereferer }}"\n                   ng-if="nzbDownload.searchResult.details">{{ ::nzbDownload.searchResult.title }}</a><span\n                    ng-if="!nzbDownload.searchResult.details">{{ nzbDownload.searchResult.title }}</span>\n            </span>\n        </td>\n        <td class="narrow-row">\n            <span ng-bind-html="getStatusIcon(nzbDownload.status)" uib-tooltip="{{nzbDownload.status}}"></span>\n        </td>\n        <td class="narrow-row">{{ ::nzbDownload.accessSource === "INTERNAL" ? "Internal" : "API"}}</td>\n        <td class="narrow-row">{{ ::nzbDownload.age }}</td>\n        <td class="narrow-row" ng-if="columnSizes.username > 0">{{ ::nzbDownload.username }}</td>\n        <td class="narrow-row" ng-if="columnSizes.ip > 0">{{ ::nzbDownload.ip }}</td>\n    </tr>\n    </tbody>\n</table>\n</div>\n\n<dir-pagination-controls on-page-change="pageChanged(newPageNumber)"\n                         pagination-id="downloads"></dir-pagination-controls>\n');
$templateCache.put('static/html/states/header.html','<nav class="navbar navbar-default navbar-static-top">\n    <div class="container">\n        <div class="navbar-collapse" id="bs-example-navbar-collapse-1">\n    \n            <ul class="nav navbar-nav">\n                <li ui-sref-active="active" ng-if="showSearch"><a ui-sref="root.search" ui-sref-opts="{inherit: false, reload: true}">Search</a></li>\n                <li ui-sref-active="{\'active\':\'root.stats\'}" ng-if="showStats && bootstrapped.safeConfig.keepHistory"><a ui-sref="root.stats.indexers">History & Stats</a></li>\n                <li ui-sref-active="{\'active\':\'root.stats\'}" ng-if="showStats && !bootstrapped.safeConfig.keepHistory"><a ui-sref="root.stats.indexers">Indexer statuses</a></li>\n                <li ui-sref-active="{\'active\':\'root.config\'}" ng-if="showAdmin"><a ui-sref="root.config.main">Config</a></li>\n                <li ui-sref-active="{\'active\':\'root.system\'}" ng-if="showAdmin"><a ui-sref="root.system.control">System</a></li>\n            </ul>\n            <ul class="nav navbar-nav navbar-right" ng-if="showLoginout">\n                <li><a href="" ng-click="loginout()"\n                       uib-tooltip="{{ loginlogoutText}}"\n                       tooltip-placement="bottom"\n                       tooltip-trigger="mouseenter"\n                ><span class="glyphicon glyphicon-off" style="margin-left: 5px"></span></a></li>\n            </ul>\n\n        </div>\n    </div>\n</nav>');
$templateCache.put('static/html/states/indexer-statuses.html','<div class="table-responsive">\r\n<table class="table indexer-statuses-table">\r\n  <caption>Indexer statuses sorted by state, then name. Go to to the config to reenable any disabled indexers\r\n  </caption>\r\n  <thead>\r\n  <tr>\r\n    <th class="col-md-2" style="width:10%">Indexer</th>\r\n    <th class="col-md-1" style="width:3%">State</th>\r\n    <th class="col-md-2" style="width:10%">Disabled at</th>\r\n    <th class="col-md-2" style="width:10%">Disabled until</th>\r\n    <th class="col-md-7" style="width:35%">Last error <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                                            uib-tooltip="Only shown when the indexer is currently disabled."></span></th>\r\n    <th class="col-md-2" style="width:6%">API hits <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                                         uib-tooltip="Shows the number of API hits either since the last limit reset time or for the last 24 hours, and the limit if configured."></span></th>\r\n    <th class="col-md-2" style="width:8%">Downloads <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                                          uib-tooltip="Shows the number of downloads either since the last limit reset time or for the last 24 hours, and the limit if configured."></span></th>\r\n    <th class="col-md-2" style="width:10%">Next hit allowed <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                                                  uib-tooltip="Either the next time the API limit is reset (if a certain hour of day is configured) or when the next hit will be allowed by the rolling limit window."></span>\r\n    </th>\r\n    <th class="col-md-2" style="width:8%">VIP expiry</th>\r\n  </tr>\r\n  </thead>\r\n\r\n  <tbody>\r\n  <tr ng-repeat="indexerStatus in statuses">\r\n    <td>{{ indexerStatus.indexer }}</td>\r\n    <td>\r\n            <span class="label" ng-class="getLabelClass(indexerStatus.state)">\r\n            <i ng-if="indexerStatus.state === \'ENABLED\'" class="fa fa-check" uib-tooltip="Enabled" tooltip-placement="top" tooltip-trigger="mouseenter"></i>\r\n            <i ng-if="indexerStatus.state === \'DISABLED_SYSTEM\'" class="fa fa-times" uib-tooltip="Disabled by system" tooltip-placement="top" tooltip-trigger="mouseenter"></i>\r\n            <i ng-if="indexerStatus.state === \'DISABLED_SYSTEM_TEMPORARY\'" class="fa fa-times" uib-tooltip="Temporarily disabled by system" tooltip-placement="top" tooltip-trigger="mouseenter"></i>\r\n            <i ng-if="indexerStatus.state === \'DISABLED_USER\'" class="fa fa-times" uib-tooltip="Disabled by user" tooltip-placement="top" tooltip-trigger="mouseenter"></i>\r\n            </span>\r\n    </td>\r\n    <td>\r\n      <span>{{ indexerStatus.disabledAt | reformatDate}}</span>\r\n    </td>\r\n    <td>\r\n      <span ng-if="indexerStatus.state === \'DISABLED_SYSTEM_TEMPORARY\'">{{ indexerStatus.disabledUntil | reformatDate}}</span>\r\n    </td>\r\n    <td class="indexer-status-reason">{{ indexerStatus.lastError }}</td>\r\n    <td>{{::indexerStatus.apiHits}}<span ng-if="indexerStatus.apiHitLimit">/{{::indexerStatus.apiHitLimit}}</span></td>\r\n    <td>{{::indexerStatus.downloadHits}}<span ng-if="indexerStatus.downloadHitLimit">/{{::indexerStatus.downloadHitLimit}}</span></td>\r\n    <td>{{::indexerStatus.apiResetTime | formatTimestamp}}<span ng-if="indexerStatus.downloadResetTime">/{{::indexerStatus.downloadResetTime | formatTimestamp}}</span></td>\r\n    <td>{{::indexerStatus.vipExpirationDate}} <span class="glyphicon glyphicon-exclamation-sign" tooltip-placement="auto top"\r\n                                                    uib-tooltip="{{indexerStatus.expiryWarning}}" ng-if="indexerStatus.expiryWarning"></span></td>\r\n  </tr>\r\n  </tbody>\r\n</table>\r\n</div>\r\n');
$templateCache.put('static/html/states/logged-out.html','<div class="container-fluid">\n    <div class="row">\n        <div class="center-form panel">\n            <div class="panel-body">\n                <h2 class="text-center">You were logged out</h2>\n            </div>\n        </div>\n    </div>\n</div>\n');
$templateCache.put('static/html/states/login.html','<div class="container-fluid">\n    <div class="row">\n        <div class="center-form panel">\n            <div class="panel-body">\n                <h2 class="text-center">Log in</h2>\n                <form method="post" ng-submit="login()" name="loginForm">\n                    <div class="form-group has-feedback">\n                        <input class="form-control input-lg" type="text" name="username" ng-model="user.username"\n                               placeholder="Username" required autofocus auto-focus>\n                        <span class="ion-at form-control-feedback"></span>\n                    </div>\n                    <div class="form-group has-feedback">\n                        <input class="form-control input-lg" type="password" name="password" ng-model="user.password"\n                               placeholder="Password" required>\n                        <span class="ion-key form-control-feedback"></span>\n                    </div>\n                    <button type="submit" ng-disabled="loginForm.$invalid" class="btn btn-lg  btn-block btn-success">Log\n                        in\n                    </button>\n                    You will be forwarded to the search area.\n                </form>\n            </div>\n        </div>\n    </div>\n</div>\n');
$templateCache.put('static/html/states/main-stats.html','<pattern id="diagonalHatch" patternUnits="userSpaceOnUse" width="4" height="4">\r\n    <path d="M-1,1 l2,-2\r\n           M0,4 l4,-4\r\n           M3,5 l2,-2"></path>\r\n</pattern>\r\n<div class="row" style="margin-top: 30px; margin-bottom: 30px">\r\n    <div class="col-md-6" style="font-size: x-small; text-align: justify; text-justify: auto">\r\n        Disclaimer: Don\'t read too much into these stats. Which indexer is picked for a download depends on its score\r\n        and some more or less random values like posting time of the NZB.\r\n        Some indexers might have nightly downtime which would influence the percentage of successful accesses.\r\n    </div>\r\n    <div class="col-md-4">\r\n        <p class="input-group">\r\n            <span class="input-group-addon" id="after-addon">After</span>\r\n            <input type="text" class="form-control" uib-datepicker-popup ng-model="afterDate" is-open="after.opened"\r\n                   datepicker-options="dateOptions" ng-required="true" close-text="Close"\r\n                   ng-keypress="onKeypress($event)"/>\r\n            <span class="input-group-btn input-group-btn2">\r\n            <button type="button" class="btn btn-default" ng-click="openAfter()"><i\r\n                    class="glyphicon glyphicon-calendar"></i></button>\r\n          </span>\r\n        </p>\r\n    </div>\r\n    <div class="col-md-4">\r\n        <p class="input-group">\r\n            <span class="input-group-addon" id="before-addon">Before</span>\r\n            <input type="text" class="form-control" uib-datepicker-popup ng-model="beforeDate" is-open="before.opened"\r\n                   datepicker-options="dateOptions" ng-required="true" close-text="Close"\r\n                   ng-keypress="onKeypress($event)"/>\r\n            <span class="input-group-btn input-group-btn2">\r\n            <button type="button" class="btn btn-default" ng-click="openBefore()"><i\r\n                    class="glyphicon glyphicon-calendar"></i></button>\r\n          </span>\r\n        </p>\r\n    </div>\r\n    <div class="col-md-3">\r\n        <label>Show disabled indexers</label>\r\n        <input bs-switch type="checkbox" ng-model="foo.includeDisabledIndexersInStats"\r\n               switch-change="toggleIncludeDisabledIndexers()" switch-size="mini"/>\r\n    </div>\r\n    <div class="col-md-3">\r\n        <button type="button" class="btn btn-info" ng-click="refresh()">Refresh</button>\r\n    </div>\r\n</div>\r\n\r\n\r\n<div cg-busy="{promise:statsLoadingPromise,message:\'Calculating stats\', delay:100}">\r\n    <div class="row">\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                <input bs-switch type="checkbox" ng-model="foo.statsSwichState.avgResponseTimes" switch-size="mini"\r\n                       ng-change="onStatsSwitchToggle(\'avgResponseTimes\')">\r\n                </span>\r\n    \r\n    \r\n                Avg. response times (in ms) <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                                  uib-tooltip="Response time is the time an API request takes, from start to completion of the web call"></span>\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.avgResponseTimes">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>Indexer</th>\r\n                        <th>Avg. response time (ms)</th>\r\n                        <th>Delta</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="avgResponseTime in stats.avgResponseTimes">\r\n                        <td>{{ avgResponseTime.indexer }}</td>\r\n                        <td>{{ avgResponseTime.avgResponseTime }}</td>\r\n                        <td>{{ avgResponseTime.delta }}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart>\r\n                    <nvd3 options="avgResponseTimesChart.options" data="avgResponseTimesChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n\r\n\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time" tooltip-placement="auto top">\r\n                <input bs-switch type="checkbox" ng-model="foo.statsSwichState.avgIndexerUniquenessScore" switch-size="mini" ng-change="onStatsSwitchToggle(\'avgIndexerUniquenessScore\')">\r\n                </span>\r\n                Indexer scores <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                     uib-tooltip="Is not being calculated depending on the after and before dates set above but for the whole time an indexer has been used."></span>\r\n            </div>\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>Indexer</th>\r\n                        <th>Avg. score <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                             uib-tooltip="The results uniqueness score determines how unique a downloaded result is to the indexer. A high score means that the indexer often returned results which were either downloaded from that indexer or *could\'ve been\' downloaded from it. See also https://github.com/theotherp/nzbhydra2/wiki/Indexer-results-uniqueness-score"></span>\r\n                        </th>\r\n                        <th># of dl searches <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top" uib-tooltip="Number of searches, which resulted in a download and where this indexer was searched"></span></th>\r\n                        <th>Unique downloads <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                                   uib-tooltip="Number of downloads, where no other indexer provided the same result (i.e. without this indexer you would\'ve missed this particular result)"></span></th>\r\n                    </tr>\r\n                    in\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="entry in stats.indexerScores">\r\n                        <td>{{ entry.indexerName }}</td>\r\n                        <td>{{ entry.averageUniquenessScore }}</td>\r\n                        <td>{{ entry.involvedSearches }}</td>\r\n                        <td>{{ entry.uniqueDownloads }}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row">\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                <input bs-switch type="checkbox" ng-model="foo.statsSwichState.indexerApiAccessStats" switch-size="mini"\r\n                       ng-change="onStatsSwitchToggle(\'indexerApiAccessStats\')">\r\n                </span>\r\n                <caption>Indexer API accesses <span class="glyphicon glyphicon-question-sign" tooltip-placement="top"\r\n                                                    uib-tooltip="An API access is considered failed only when the indexer could not be reached, not if auth was unsuccessful or Hydra had an unexpected error. The average calculation only spans the time since the first search with the indexer."></span>\r\n                </caption>\r\n            </div>\r\n            <table class="table" style="margin-top: 9px" ng-show="foo.statsSwichState.indexerApiAccessStats">\r\n                <thead>\r\n                <tr>\r\n                    <th>Indexer</th>\r\n                    <th>Avg. per day</th>\r\n                    <th>% successful</th>\r\n                    <th>% failed</th>\r\n                </tr>\r\n                </thead>\r\n                <tbody>\r\n                <tr ng-repeat="avgIndexerAccessSuccess in stats.indexerApiAccessStats">\r\n                    <td>{{ avgIndexerAccessSuccess.indexerName }}</td>\r\n                    <td>{{ avgIndexerAccessSuccess.averageAccessesPerDay | number: 0 }}</td>\r\n                    <td>{{ avgIndexerAccessSuccess.percentSuccessful | number: 0}}</td>\r\n                    <td>{{ avgIndexerAccessSuccess.percentConnectionError | number: 0 }}</td>\r\n                </tr>\r\n                </tbody>\r\n            </table>\r\n        </div>\r\n\r\n\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                <input bs-switch type="checkbox" ng-model="foo.statsSwichState.indexerDownloadShares" switch-size="mini"\r\n                       ng-change="onStatsSwitchToggle(\'indexerDownloadShares\')">\r\n                </span>\r\n                NZB downloads per indexer <span class="glyphicon glyphicon-question-sign" tooltip-placement="top"\r\n                                                uib-tooltip="Only downloads by enabled indexers are taken into account and displayed"></span></caption>\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.indexerDownloadShares">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>Indexer</th>\r\n                        <th>Total</th>\r\n                        <th>% of all enabled</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="indexerDownloads in stats.indexerDownloadShares">\r\n                        <td>{{ indexerDownloads.indexerName }}</td>\r\n                        <td>{{ indexerDownloads.total | number: 0}}</td>\r\n                        <td>{{ indexerDownloads.share | number: 0 }}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart>\r\n                    <nvd3 options="indexerDownloadSharesChart.options" data="indexerDownloadSharesChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n\r\n\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row">\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                <input bs-switch type="checkbox" ng-model="foo.statsSwichState.downloadsPerAgeStats" switch-size="mini"\r\n                       ng-change="onStatsSwitchToggle(\'downloadsPerAgeStats\')">\r\n                </span>\r\n                NZB downloads per age (in 100 day steps, all downloads)\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.downloadsPerAgeStats">\r\n                <table class="table">\r\n                    <tbody>\r\n                    <tr>\r\n                        <td>Average age</td>\r\n                        <td>{{ stats.downloadsPerAgeStats.averageAge}}</td>\r\n                    </tr>\r\n                    <tr>\r\n                        <td>% older than 1000 days</td>\r\n                        <td>{{ stats.downloadsPerAgeStats.percentOlder1000 | number : 1}}</td>\r\n                    </tr>\r\n                    <tr>\r\n                        <td>% older than 2000 days</td>\r\n                        <td>{{ stats.downloadsPerAgeStats.percentOlder2000 | number : 1}}</td>\r\n                    </tr>\r\n                    <tr>\r\n                        <td>% older than 3000 days</td>\r\n                        <td>{{ stats.downloadsPerAgeStats.percentOlder3000 | number : 1}}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="downloadsPerAge">\r\n                    <nvd3 options="downloadsPerAgeChart.options" data="downloadsPerAgeChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                <input bs-switch type="checkbox" ng-model="foo.statsSwichState.successfulDownloadsPerIndexer"\r\n                       switch-size="mini" ng-change="onStatsSwitchToggle(\'successfulDownloadsPerIndexer\')">\r\n                    </span>\r\n                Successful downloads per indexer <span class="glyphicon glyphicon-question-sign" tooltip-placement="top"\r\n                                                       uib-tooltip="Only works if user scripts report the actual download result of a NZB\'s content. Shows percentage of successful downloads of all downloads with reported status."></span>\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.successfulDownloadsPerIndexer">\r\n                <table class="table">\r\n                    <thead>\r\n                    <th>Indexer</th>\r\n                    <th>% of successful downloads</th>\r\n                    <th># of all downloads</th>\r\n                    <th># of successful downloads</th>\r\n                    <th># of unsuccessful downloads</th>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="stat in stats.successfulDownloadsPerIndexer">\r\n                        <td>{{ stat.indexerName}}</td>\r\n                        <td>{{ stat.percentSuccessful | number : 1}}</td>\r\n                        <td>{{ stat.countAll | number : 0}}</td>\r\n                        <td>{{ stat.countSuccessful | number : 0}}</td>\r\n                        <td>{{ stat.countError | number : 0}}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="successfulDownloadsPerIndexerChart">\r\n                    <nvd3 options="successfulDownloadsPerIndexerChart.options"\r\n                          data="successfulDownloadsPerIndexerChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n\r\n        </div>\r\n    </div>\r\n\r\n\r\n    <div class="row">\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.searchSharesPerUser"\r\n                           switch-size="mini" ng-change="onStatsSwitchToggle(\'searchSharesPerUser\')">\r\n                    </span>\r\n\r\n                Searches per username\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.searchSharesPerUser">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>User</th>\r\n                        <th>Percentage</th>\r\n                        <th>Count</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="stat in stats.searchSharesPerUser">\r\n                        <td>{{ stat.key }}</td>\r\n                        <td>{{ stat.percentage | number : 1}}</td>\r\n                        <td>{{ stat.count }}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="searchSharesPerUserChart">\r\n                    <nvd3 options="searchSharesPerUserChart.options" data="searchSharesPerUserChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.downloadSharesPerUser"\r\n                           switch-size="mini" ng-change="onStatsSwitchToggle(\'downloadSharesPerUser\')">\r\n                </span>\r\n                Downloads per username\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.downloadSharesPerUser">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>User</th>\r\n                        <th>Percentage</th>\r\n                        <th>Count</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="stat in downloadSharesPerUser">\r\n                        <td>{{ stat.user }}</td>\r\n                        <td>{{ stat.percentage | number : 1}}</td>\r\n                        <td>{{ stat.count}}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="downloadSharesPerUserChart">\r\n                    <nvd3 options="downloadSharesPerUserChart.options" data="downloadSharesPerUserChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row">\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.searchSharesPerIp" switch-size="mini"\r\n                           ng-change="onStatsSwitchToggle(\'searchSharesPerIp\')">\r\n                    </span>\r\n    \r\n                Searches per host\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.searchSharesPerIp">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>Host</th>\r\n                        <th>Percentage</th>\r\n                        <th>Count</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="stat in stats.searchSharesPerIp">\r\n                        <td>{{ stat.key }}</td>\r\n                        <td>{{ stat.percentage | number : 1}}</td>\r\n                        <td>{{ stat.count }}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="searchSharesPerIpChart">\r\n                    <nvd3 options="searchSharesPerIpChart.options" data="searchSharesPerIpChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.downloadSharesPerIp"\r\n                           switch-size="mini" ng-change="onStatsSwitchToggle(\'downloadSharesPerIp\')">\r\n                </span>\r\n                Downloads per host\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.downloadSharesPerIp">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>Host</th>\r\n                        <th>Percentage</th>\r\n                        <th>Count</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="stat in downloadSharesPerIp">\r\n                        <td>{{ stat.key }}</td>\r\n                        <td>{{ stat.percentage | number : 1}}</td>\r\n                        <td>{{ stat.count}}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="downloadSharesPerIpChart">\r\n                    <nvd3 options="downloadSharesPerIpChart.options" data="downloadSharesPerIpChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row">\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.userAgentSearchShares"\r\n                           switch-size="mini" ng-change="onStatsSwitchToggle(\'userAgentSearchShares\')">\r\n                </span>\r\n                API Searches per user agent <span class="glyphicon glyphicon-question-sign" tooltip-placement="auto top"\r\n                                                  uib-tooltip="Some tools don\'t use specific user agents. They will most likely show up as \'Mozilla\' or as \'Other\'"></span>\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.userAgentSearchShares">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>User agent</th>\r\n                        <th>Percentage</th>\r\n                        <th>Count</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="stat in stats.userAgentSearchShares">\r\n                        <td>{{ stat.userAgent }}</td>\r\n                        <td>{{ stat.percentage | number : 1}}</td>\r\n                        <td>{{ stat.count }}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="userAgentSearchSharesChart">\r\n                    <nvd3 options="userAgentSearchSharesChart.options" data="userAgentSearchSharesChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.userAgentDownloadShares"\r\n                           switch-size="mini" ng-change="onStatsSwitchToggle(\'userAgentDownloadShares\')">\r\n                </span>\r\n                API downloads per user agent <span class="glyphicon glyphicon-question-sign"\r\n                                                   tooltip-placement="auto top"\r\n                                                   uib-tooltip="Some tools don\'t use specific user agents. They will most likely show up as \'Mozilla\' or as \'Other\'"></span>\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.userAgentDownloadShares">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>User agent</th>\r\n                        <th>Percentage</th>\r\n                        <th>Count</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="stat in stats.userAgentDownloadShares">\r\n                        <td>{{ stat.userAgent }}</td>\r\n                        <td>{{ stat.percentage | number : 1}}</td>\r\n                        <td>{{ stat.count }}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="userAgentDownloadSharesChart">\r\n                    <nvd3 options="userAgentDownloadSharesChart.options"\r\n                          data="userAgentDownloadSharesChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n\r\n\r\n    </div>\r\n\r\n\r\n    <div class="row">\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.searchesPerDayOfWeek"\r\n                           switch-size="mini" ng-change="onStatsSwitchToggle(\'searchesPerDayOfWeek\')">\r\n                </span>\r\n                Searches per day of week\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.searchesPerDayOfWeek">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>Day of the week</th>\r\n                        <th>Searches</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="stat in stats.searchesPerDayOfWeek">\r\n                        <td>{{ stat.day }}</td>\r\n                        <td>{{ stat.count }}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="weeklyChart">\r\n                    <nvd3 options="searchesPerDayOfWeekChart.options" data="searchesPerDayOfWeekChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n\r\n\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.searchesPerHourOfDay"\r\n                           switch-size="mini" ng-change="onStatsSwitchToggle(\'searchesPerHourOfDay\')">\r\n                </span>\r\n                Searches per hour of day\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.searchesPerHourOfDay">\r\n                <table>\r\n                    <table class="table">\r\n                        <thead>\r\n                        <tr>\r\n                            <th>Hour of the day</th>\r\n                            <th>Searches</th>\r\n                        </tr>\r\n                        </thead>\r\n                        <tbody>\r\n                        <tr ng-repeat="stat in stats.searchesPerHourOfDay">\r\n                            <td>{{ stat.hour }}</td>\r\n                            <td>{{ stat.count }}</td>\r\n                        </tr>\r\n                        </tbody>\r\n                    </table>\r\n                </table>\r\n\r\n                <chart class="dailyChart">\r\n                    <nvd3 options="searchesPerHourOfDayChart.options" data="searchesPerHourOfDayChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n\r\n        </div>\r\n    </div>\r\n\r\n\r\n    <div class="row">\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.downloadsPerDayOfWeek"\r\n                           switch-size="mini" ng-change="onStatsSwitchToggle(\'downloadsPerDayOfWeek\')">\r\n                </span>\r\n                NZB downloads per day of week\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.downloadsPerDayOfWeek">\r\n                <table class="table">\r\n                    <thead>\r\n                    <tr>\r\n                        <th>Day of the week</th>\r\n                        <th>Downloads</th>\r\n                    </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                    <tr ng-repeat="stat in stats.downloadsPerDayOfWeek">\r\n                        <td>{{ stat.day }}</td>\r\n                        <td>{{ stat.count }}</td>\r\n                    </tr>\r\n                    </tbody>\r\n                </table>\r\n\r\n                <chart class="weeklyChart">\r\n                    <nvd3 options="downloadsPerDayOfWeekChart.options" data="downloadsPerDayOfWeekChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n\r\n\r\n        <div class="col-md-10 stat-box">\r\n            <div class="caption">\r\n                <span uib-tooltip="Hiding a stat will disable its calculation and may improve overall loading time"\r\n                      tooltip-placement="auto top">\r\n                    <input bs-switch type="checkbox" ng-model="foo.statsSwichState.downloadsPerHourOfDay"\r\n                           switch-size="mini" ng-change="onStatsSwitchToggle(\'downloadsPerHourOfDay\')">\r\n                </span>\r\n                NZB downloads per hour of day\r\n            </div>\r\n            <tab-or-chart display="chart" ng-show="foo.statsSwichState.downloadsPerHourOfDay">\r\n                <table>\r\n                    <table class="table">\r\n                        <thead>\r\n                        <tr>\r\n                            <th>Hour of the day</th>\r\n                            <th>Downloads</th>\r\n                        </tr>\r\n                        </thead>\r\n                        <tbody>\r\n                        <tr ng-repeat="stat in stats.downloadsPerHourOfDay">\r\n                            <td>{{ stat.hour }}</td>\r\n                            <td>{{ stat.count }}</td>\r\n                        </tr>\r\n                        </tbody>\r\n                    </table>\r\n                </table>\r\n\r\n                <chart class="dailyChart">\r\n                    <nvd3 options="downloadsPerHourOfDayChart.options" data="downloadsPerHourOfDayChart.data"></nvd3>\r\n                </chart>\r\n            </tab-or-chart>\r\n        </div>\r\n    </div>\r\n\r\n\r\n</div>\r\n');
$templateCache.put('static/html/states/notification-history.html','<div id="content">\n  <div class="row" style="margin-top: 30px; margin-bottom: 20px">\n    <div class="col-md-5"></div>\n    <div class="col-md-10" style="text-align: center">\n      <dir-pagination-controls on-page-change="update()" pagination-id="notification"></dir-pagination-controls>\n    </div>\n    <div class="col-md-5" style="text-align: right">\n      <button class="btn btn-default" ng-click="update()"><span class="glyphicon glyphicon-refresh"></span></button>\n    </div>\n  </div>\n  <div class="table-responsive">\n  <table class="table">\n    <thead>\n    <tr>\n      <th class="col-md-2" style="width: {{columnSizes.time}}%;">\n        <column-sortable column="time" style="width: 10%" reversed="false" start-mode="2">Time\n        </column-sortable>\n        <column-filter-wrapper>\n          <time-filter column="time" selected="preselectedTimeInterval"/>\n        </column-filter-wrapper>\n      </th>\n      <th class="col-md-8" style="width: {{columnSizes.type}}%">\n        <column-sortable column="NOTIFICATION_EVENT_TYPE" reversed="false" start-mode="1">Type\n        </column-sortable>\n        <column-filter-wrapper>\n          <checkboxes-filter column="NOTIFICATION_EVENT_TYPE" entries="eventTypesForFiltering" preselect="true" show-invert="true"/>\n        </column-filter-wrapper>\n      </th>\n\n      <th style="width: {{columnSizes.title}}%">\n        Title\n      </th>\n      <th style="width: {{columnSizes.body}}%">\n        Body\n      </th>\n      <th style="width: {{columnSizes.urls}}%">\n        URLs\n      </th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr dir-paginate="notification in notifications | itemsPerPage: limit" total-items="totalNotifications"\n        current-page="pagination.current" pagination-id="notifications">\n      <td class="narrow-row">{{ notification.time | reformatDate }}</td>\n      <td class="narrow-row" ng-bind-html="formatEventType(notification)"></td>\n      <td class="narrow-row">{{ ::notification.title }}</td>\n      <td class="narrow-row" ng-bind-html="formatEventBody(notification)"></td>\n      <td class="narrow-row">{{ ::notification.urls }}</td>\n      </td>\n    </tr>\n    </tbody>\n  </table>\n  </div>\n    <dir-pagination-controls on-page-change="pageChanged(newPageNumber)" pagination-id="notifications"></dir-pagination-controls>\n\n</div>\n');
$templateCache.put('static/html/states/search-history.html','<div id="content">\r\n  <div class="row" style="margin-top: 30px; margin-bottom: 20px">\r\n    <div class="col-md-5"></div>\r\n    <div class="col-md-10" style="text-align: center">\r\n      <dir-pagination-controls on-page-change="update()" pagination-id="searches"></dir-pagination-controls>\r\n    </div>\r\n    <div class="col-md-5" style="text-align: right">\r\n      <label>\r\n        <input type="checkbox" ng-model="foo.showUserAgentInHistory" ng-change="toggleShowUserAgentInHistory(foo.showUserAgentInHistory)">\r\n        Show user agents\r\n      </label>\r\n      <button class="btn btn-default" ng-click="update()"><span class="glyphicon glyphicon-refresh"></span></button>\r\n    </div>\r\n  </div>\r\n  <div class="table-responsive">\r\n  <table class="table">\r\n    <thead>\r\n    <tr>\r\n      <th class="col-md-2" style="width: {{columnSizes.time}}%;">\r\n        <column-sortable column="time" style="width: 10%" reversed="false" start-mode="2">Time\r\n        </column-sortable>\r\n        <column-filter-wrapper>\r\n          <time-filter column="time" selected="preselectedTimeInterval"/>\r\n        </column-filter-wrapper>\r\n      </th>\r\n      <th class="col-md-8" style="width: {{columnSizes.query}}%">\r\n        <column-sortable column="query" reversed="false" start-mode="1">Query\r\n        </column-sortable>\r\n        <column-filter-wrapper>\r\n          <freetext-filter column="query"/>\r\n        </column-filter-wrapper>\r\n      </th>\r\n      <th class="col-md-8" style="width: {{columnSizes.userAgent}}%" ng-if="foo.showUserAgentInHistory">\r\n        <column-sortable column="user_agent" reversed="false" start-mode="1">User agent\r\n        </column-sortable>\r\n        <column-filter-wrapper>\r\n          <freetext-filter column="user_agent"/>\r\n        </column-filter-wrapper>\r\n      </th>\r\n      <th style="width: {{columnSizes.category}}%">\r\n        <column-sortable column="category_name" reversed="false" start-mode="1">Category\r\n        </column-sortable>\r\n        <column-filter-wrapper>\r\n          <checkboxes-filter column="category_name" entries="categoriesForFiltering" preselect="true"\r\n                             show-invert="true"/>\r\n        </column-filter-wrapper>\r\n      </th>\r\n      <th style="width: {{columnSizes.additionalParameters}}%">\r\n        Additional parameters\r\n      </th>\r\n      <th class="col-md-1" style="width: {{columnSizes.source}}%">\r\n        <column-sortable column="source" reversed="false" start-mode="1">Source\r\n        </column-sortable>\r\n        <column-filter-wrapper>\r\n          <boolean-filter column="source" options="accessOptionsForFiltering" preselect="0"/>\r\n        </column-filter-wrapper>\r\n      </th>\r\n      <th class="col-md-2" style="width: {{columnSizes.username}}%" ng-if="columnSizes.username > 0">\r\n        <column-sortable column="username" reversed="false" start-mode="1">User</column-sortable>\r\n        <column-filter-wrapper>\r\n          <freetext-filter column="username"/>\r\n        </column-filter-wrapper>\r\n      </th>\r\n      <th class="col-md-2" style="width: {{columnSizes.ip}}%" ng-if="columnSizes.ip > 0">\r\n        <column-sortable column="ip" reversed="false" start-mode="1">Host</column-sortable>\r\n        <column-filter-wrapper>\r\n          <freetext-filter column="ip"/>\r\n        </column-filter-wrapper>\r\n      </th>\r\n      <th>Details</th>\r\n    </tr>\r\n    </thead>\r\n    <tbody>\r\n    <tr dir-paginate="request in searchRequests | itemsPerPage: limit" total-items="totalRequests"\r\n        current-page="pagination.current" pagination-id="searches">\r\n      <td class="narrow-row">{{ request.time | reformatDate }}</td>\r\n      <td class="narrow-row">\r\n        <a href="" ng-click="openSearch(request)"\r\n           uib-tooltip="Repeat this search with all currently enabled indexers." tooltip-placement="top"\r\n           tooltip-trigger="mouseenter"\r\n        ><span class="glyphicon glyphicon-search"></span></a>\r\n        <span ng-class="{\'history-title\': request.title != null || (request.query == null && request.identifiers.length === 0 && request.season ==null && request.episode ==null)}">\r\n                    {{ formatQuery(request) }}\r\n                </span>\r\n      </td>\r\n      <td class="narrow-row" ng-if="foo.showUserAgentInHistory">{{ ::request.userAgent }}</td>\r\n      <td class="narrow-row">{{ ::request.categoryName }}</td>\r\n      <td class="narrow-row" ng-bind-html="formatAdditional(request)"></td>\r\n      <td class="narrow-row">{{ ::request.source === "INTERNAL" ? "Internal" : "API"}}</td>\r\n      <td class="narrow-row" ng-if="columnSizes.username > 0">{{ ::request.username }}</td>\r\n      <td class="narrow-row" ng-if="columnSizes.ip > 0">{{ ::request.ip }}</td>\r\n      <td class="narrow-row"><span ng-click="showDetails(request.id)" class="glyphicon glyphicon-eye-open"></span>\r\n      </td>\r\n    </tr>\r\n    </tbody>\r\n  </table>\r\n  </div>\r\n  <dir-pagination-controls on-page-change="pageChanged(newPageNumber)"\r\n                           pagination-id="searches"></dir-pagination-controls>\r\n\r\n</div>\r\n');
$templateCache.put('static/html/states/search-results.html','<span ng-show="doShowResults">\n<div class="row d-flex justify-content-center" ng-if="indexersearches.length" style="margin-top: 25px">\n    <div class="col-xs-20 col-sm-18 col-md-14 col-lg-10">\n        <uib-accordion close-others="oneAtATime" id="search-results-accordion">\n            <div uib-accordion-group panel-class="panel-indexer-statuses" is-open="foo.indexerStatusesExpanded"\n                 is-disabled="true" class="">\n                <uib-accordion-heading>\n                    <span class="indexer-statuses-accordion">\n                        <span ng-click="toggleIndexerStatuses()">Indexer statuses</span><span ng-if="countRejected > 0"> / Rejected results</span> <i\n                            class="pull-right glyphicon"\n                            ng-class="{\'glyphicon-chevron-down\': foo.indexerStatusesExpanded, \'glyphicon-chevron-right\': !foo.indexerStatusesExpanded}"\n                            ng-click="toggleIndexerStatuses()"></i>\n                    </span>\n                </uib-accordion-heading>\n                <table class="table">\n                    <thead>\n                    <tr>\n                        <th class="col-md-6 text-left">\n                            Indexer\n                        </th>\n                        <th class="col-md-2 text-left">\n                            Results\n                        </th>\n                        <th class="col-md-4 text-left">\n                            Response time\n                        </th>\n                        <th class="col-md-9 text-left">\n                            Status\n                        </th>\n                    </tr>\n                    </thead>\n                    <tbody>\n                        <tr ng-repeat-start="ps in indexersearches " ng-if="0"></tr>\n                        <!-- First result in the list, show regularly -->\n                        <tr>\n                            <td class="text-left">\n                                {{ ::ps.indexerName }}\n                            </td>\n                            <td class="text-left">\n                                <span ng-if="::ps.didSearch">\n                                    <span ng-if="::!ps.totalResultsKnown && ps.numberOfAvailableResults > 0">&gt;</span>{{ ::ps.numberOfAvailableResults }}\n                                </span>\n                                    </td>\n                                    <td class="text-left">\n                                <span ng-if="::ps.didSearch">\n                                    {{ ::ps.responseTime }}ms\n                                </span>\n                                    </td>\n                                    <td class="text-left">\n                                <span ng-if="::ps.didSearch">\n                                    <span class="glyphicon"\n                                          ng-class="{\'glyphicon-ok\' : ps.wasSuccessful, \'glyphicon-remove\' : !ps.wasSuccessful}"></span>\n                                    <span ng-if="::!ps.wasSuccessful">{{ ::ps.errorMessage }}</span>\n                                </span>\n\n                                <span ng-if="::!ps.didSearch">Did not search.</span>\n                            </td>\n                        </tr>\n                        <tr ng-repeat-end ng-if="0"></tr>\n\n\n                        <tr ng-repeat-start="ps in ::notPickedIndexersWithReason" ng-if="0"></tr>\n                        <tr>\n                            <td class="text-left">\n                                {{ ::ps.indexer }}\n                            </td>\n                            <td class="text-left">\n                            </td>\n                            <td class="text-left">\n                            </td>\n                            <td class="text-left">\n                                <span class="glyphicon glyphicon-minus"></span>\n                                {{::ps.reason}}\n                            </td>\n                        </tr>\n                        <tr ng-repeat-end ng-if="0"></tr>\n                    </tbody>\n                </table>\n\n                <table class="table" style="margin-bottom: 0px; margin-top: 5px" ng-if="countRejected > 0">\n                    <thead>\n                        <tr>\n                            <th class="col-md-5 text-left">\n                            </th>\n                            <th class="col-md-5 text-left" style="text-align: right">\n                                Reject reason\n                            </th>\n                            <th class="col-md-5 text-left">\n                                Count\n                            </th>\n                            <th class="col-md-5 text-left">\n                            </th>\n                        </tr>\n                    </thead>\n                    <tbody>\n                    <tr ng-repeat="entry in rejected | filter: filterRejectedZero(entry)">\n                        <td>\n                        </td>\n                        <td style="text-align: right">\n                            {{ entry[0] }}\n                        </td>\n                        <td>\n                            {{ entry[1] }}\n                        </td>\n                        <td>\n                        </td>\n                    </tr>\n                    </tbody>\n                </table>\n            </div>\n        </uib-accordion>\n    </div>\n</div>\n\n<div class="row" ng-if="::indexersearches.length == 0" style="margin-top: 50px">\n    <div class="well">\n        <h2>No indexers were picked for this search</h2>\n        <div style="width: 520px; margin: auto;text-align: left;">\n            Reasons:\n            <ul style="padding-left: 15px">\n                <li ng-repeat="tuple in ::notPickedIndexersWithReason">{{::tuple.indexer}}: {{::tuple.reason}}</li>\n            </ul>\n        </div>\n    </div>\n</div>\n\n<div class="row" ng-if="::indexersearches.length > 0 && (numberOfAvailableResults === 0)" style="margin-top: 50px" id="no-search-results">\n    <div class="well">\n        <h2 ng-if="!anyIndexersSearchedSuccessfully">Unable to search any indexer successfully; no results available</h2>\n        <h2 ng-if="!anyResultsRejected && anyIndexersSearchedSuccessfully">No results were found for this search</h2>\n    </div>\n</div>\n<div ng-if="::indexersearches.length > 0 && numberOfAvailableResults > 0" style="margin-top: 10px">\n    <div class="row my-5">\n        <div class="col-md-8 text-left">\n            <div class="d-flex flex-wrap">\n                <div id="display-options" class="pe-2 mb-2"\n                    multiselect-dropdown options="optionsOptions" selected-model="optionsSelectedModel"\n                    settings="optionsExtraSettings" events="optionsEvents"\n                ></div>\n\n                <div selection-button invert-selection="invertSelection" select-all="selectAll" deselect-all="deselectAll"\n                    id="search-results-selection-button" class="pe-2 mb-2"></div>\n\n                <download-nzbs-button search-results="selected" callback="downloadNzbsCallback(result)"></download-nzbs-button>\n                <download-nzbzip-button search-results="selected" search-title="searchTitle"\n                                        callback="downloadNzbsCallback(result)" ng-if="foo.showResultsAsZipButton && allowZipDownload"></download-nzbzip-button>\n                <copy-links-button search-results="selected" ng-if="!(foo.showResultsAsZipButton && allowZipDownload)"></copy-links-button>\n            </div>\n        </div>\n\n        <div class="col-md-4 search-results-pagination">\n            <dir-pagination-controls auto-hide="false" max-size="5"></dir-pagination-controls>\n        </div>\n        <div class="col-md-8 text-right">\n\n\n            <div>\n                <span class="badge"\n                    uib-tooltip-html="getRejectedReasonsTooltip()"\n                    tooltip-class="rejected-tooltip"\n                    tooltip-placement="top"\n                    tooltip-trigger="click"\n                >\n                    <span ng-if="numberOfLoadedResults <= numberOfAvailableResults">\n                        Loaded {{ numberOfLoadedResults }} ({{ numberOfFilteredResults }} filtered, {{numberOfDuplicateResults}} duplicates) of <span ng-if="totalAvailableUnknown">&gt;</span>{{ numberOfAvailableResults }} results (rejected {{ numberOfRejectedResults }})\n                    </span>\n                    <span ng-if="numberOfLoadedResults > numberOfAvailableResults">\n                    Loaded all {{ numberOfLoadedResults }} results (rejected {{ numberOfRejectedResults }})\n                    </span>\n                </span>\n\n                <div class="btn-group">\n                    <!--Add tooltip div to body to prevent div being insert in btn-group and changing layout because more children are there -->\n                    <button class="btn btn-default" ng-click="loadMore(false)" ng-disabled="!loadMoreEnabled"\n                            tooltip-append-to-body="true"\n                            uib-tooltip="Click to load more results from the indexers. May reset some filters"\n                            tooltip-placement="top"\n                            tooltip-trigger="mouseenter"\n                    >Load more\n                        <img src="static/img/spinner.gif" ng-if="loadingMore"/>\n                    </button>\n                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"\n                            aria-haspopup="true" aria-expanded="false" ng-disabled="!loadMoreEnabled">\n                        <span class="caret"></span>\n                        <span class="sr-only">Toggle Dropdown</span>\n                    </button>\n                    <ul class="dropdown-menu">\n                        <li><a href="#" ng-click="loadMore(true)"\n                            uib-tooltip="Click to load all of the results from the indexers. May take a while and a lot of API requests..."\n                            tooltip-placement="top"\n                            tooltip-trigger="mouseenter"\n                        >Load all results</a></li>\n                    </ul>\n                </div>\n\n            </div>\n        </div>\n    </div>\n\n    <div class="row" ng-if="::showEmbyResults">\n        <div class="col-md-6"></div>\n        <div class="col-md-8">\n    <div class="alert alert-success" role="alert">\n        <span ng-if="embyType===\'show\'">\n            This show is already available on the server. Please check if the episodes you are interested in are available or request them using Ombi.\n        </span>\n        <span ng-if="embyType===\'movie\'">\n            This movie is already available on the server. Please check if the quality matches the one you want..\n        </span>\n    </div>\n            </div>\n    </div>\n    \n    <div class="row" ng-if="::(isShowFilterButtons)">\n        <div class="col-md-20">\n            <div class="btn-toolbar" role="toolbar" style="margin: auto; display:inline-block">\n                <div class="btn-group btn-group-xs" role="group" ng-if="isShowFilterButtonsVideo">\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.source.camts" uib-btn-checkbox>CAM / TS\n                    </button>\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.source.tv" uib-btn-checkbox>TV\n                    </button>\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.source.web" uib-btn-checkbox>WEB\n                    </button>\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.source.dvd" uib-btn-checkbox>DVD\n                    </button>\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.source.bluray" uib-btn-checkbox>\n                        Blu-Ray\n                    </button>\n                </div>\n                <div class="btn-group btn-group-xs" role="group" ng-if="isShowFilterButtonsVideo">\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.quality.q480p" uib-btn-checkbox>480p\n                    </button>\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.quality.q720p" uib-btn-checkbox>720p\n                    </button>\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.quality.q1080p" uib-btn-checkbox>\n                        1080p\n                    </button>\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.quality.q2160p" uib-btn-checkbox>\n                        2160p\n                    </button>\n                </div>\n                <div class="btn-group btn-group-xs" role="group" ng-if="isShowFilterButtonsVideo">\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.other.q3d" uib-btn-checkbox>3D\n                    </button>\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.other.x265" uib-btn-checkbox>x265\n                    </button>\n                    <button type="button" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.other.hevc" uib-btn-checkbox>HEVC\n                    </button>\n                </div>\n                <div class="btn-group btn-group-xs" role="group">\n                    <button ng-repeat="entry in customFilterButtons" class="btn btn-default filter-button" ng-change="onFilterButtonsModelChange()"\n                            uncheckable ng-model="filterButtonsModel.custom[entry]" uib-btn-checkbox>{{entry}}\n\n                    </button>\n\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <table class="table table-hover search-results-table">\n        <thead class="search-results-header">\n        <tr class="search-results-header-row">\n            <th class="col-md-13 cursor-default search-results-cell result-title">\n                <column-sortable column="title" reversed="false" start-mode="1">Title\n                </column-sortable>\n                <column-filter-wrapper inline="true">\n                    <freetext-filter column="title" on-key="true" id="title-filter" placeholder="Filter results"\n                                     tooltip="Filter in title words. Prepend words with ! to exclude them. Wrap in \'/\' to use regular expressions."\n                                     no-focus="true"/>\n                </column-filter-wrapper>\n            </th>\n            <th class="col-md-1 cursor-default search-results-cell result-indexer"\n                style="vertical-align: top; text-align: right">\n                <column-sortable column="indexer" reversed="false" start-mode="1">Indexer\n                </column-sortable>\n                <column-filter-wrapper>\n                    <checkboxes-filter column="indexer" entries="indexersForFiltering" preselect="true"\n                                       show-invert="true" id="indexer-filter"/>\n                </column-filter-wrapper>\n            </th>\n            <th class="col-md-1 cursor-default search-results-cell result-category"\n                style="vertical-align: top; text-align: right">\n                <column-sortable column="category" reversed="false" start-mode="1">Category\n                </column-sortable>\n                <column-filter-wrapper>\n                    <checkboxes-filter column="category" entries="categoriesForFiltering" preselect="true"\n                                       show-invert="true" id="category-filter"/>\n                </column-filter-wrapper>\n            </th>\n            <th class="col-md-1 cursor-default search-results-cell result-size"\n                style="vertical-align: top; text-align: right">\n                <column-sortable column="size" reversed="false" start-mode="2">Size\n                </column-sortable>\n                <column-filter-wrapper>\n                    <number-range-filter column="size" addon="MB" id="size-filter"/>\n                </column-filter-wrapper>\n            </th>\n            <th class="col-md-1 cursor-default search-results-cell result-details"\n                style="vertical-align: top; text-align: right"\n                tooltip-append-to-body="true"\n                uib-tooltip="Displays grabs and for torrents also seeders / peers, with sort and filter effecting seeders if available, otherwise grabs. You can enable that or filtering and sorting the sum of all values is used (see display options)"\n                tooltip-placement="top"\n                tooltip-trigger="mouseenter"\n            >\n\n                <column-sortable column="grabs" reversed="false" start-mode="2">Details\n                </column-sortable>\n                <column-filter-wrapper>\n                    <number-range-filter column="grabs" id="grabs-filter"/>\n                </column-filter-wrapper>\n            </th>\n            <th class="col-md-1 cursor-default search-results-cell result-age"\n                style="vertical-align: top; text-align: right">\n                <column-sortable column="epoch" reversed="true" start-mode="2">Age\n                </column-sortable>\n                <column-filter-wrapper>\n                    <number-range-filter column="epoch" addon="days" id="age-filter" tooltip="Suffix with h or m to filter by hours or minutes, respectively"/>\n                </column-filter-wrapper>\n            </th>\n            <th class="col-md-2 search-results-cell result-links" style="vertical-align: top">\n                Links\n            </th>\n        </tr>\n        </thead>\n        <tbody>\n        <tr>\n            <th style="text-align: center; margin-top: 5px" colspan="67" ng-if="allResultsFiltered || numberOfAcceptedResults === 0">\n                <h2 ng-if="allResultsFiltered">All results are currently filtered</h2>\n                <h2 ng-if="numberOfAcceptedResults === 0">All found results have been rejected</h2>\n            </th>\n        </tr>\n        </tbody>\n\n       <tbody dir-paginate-start="result in filteredResults | itemsPerPage:limitTo track by result.searchResultId"\n              ng-show="0"></tbody>\n        <tbody search-result result="result" on-finish-render search-results-controller-shared="shared" class="search-result-tbody" style="{{::result.style}}"></tbody>\n        <tbody dir-paginate-end ng-show="0"></tbody>\n        <tbody>{{result.title}}</tbody>\n\n    </table>\n\n    <dir-pagination-controls auto-hide="false" on-page-change="onPageChange(newPageNumber, oldPageNumber)"></dir-pagination-controls>\n</div>\n</span>\n');
$templateCache.put('static/html/states/search.html','<script type="text/ng-template" id="autocompleteTemplate.html">\r\n  <a>\r\n      <span ng-if="match.model.posterUrl">\r\n    <img ng-src="{{ match.model.posterUrl }}" style="width: 50px"></span> {{ match.model.title\r\n      }} <span ng-if="match.model.year">( {{ match.model.year }} )</span>\r\n  </a>\r\n</script>\r\n\r\n<div ng-if="::availableIndexers.length == 0">\r\n  <div class="row d-sm-flex justify-content-center">\r\n    <div class="col-xs-20 col-sm-18 col-md-10 alert alert-info" role="alert">\r\n      No indexers are configured or enabled. Please go to the <a ui-sref="root.config.indexers"\r\n                                                                 style="text-decoration: underline">indexer\r\n      configuration</a> and add or enable some.\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div ng-show="::availableIndexers.length > 0">\r\n    <div class="row d-sm-flex justify-content-center">\r\n\r\n        <div class="col-xs-20 col-sm-18 col-md-14">\r\n            <form class="form-horizontal">\r\n                <div class="form-group">\r\n\r\n                    <label class="col-sm-2 control-label">Search</label>\r\n\r\n                    <div class="col-sm-18">\r\n                        <div class="input-group">\r\n                            <span class="input-group-btn input-group-btn2">\r\n                                <button type="button" class="btn btn-default dropdown-toggle search-category-button"\r\n                                      data-toggle="dropdown" aria-expanded="false" id="searchCategoryDropdownButton"\r\n                                      ng-cloak>\r\n                                    {{ category.name }} <span class="caret"></span>\r\n                                </button>\r\n                                <ul class="dropdown-menu dropdown-menu-right" role="menu"\r\n                                    style="right: auto; top:initial; margin:0px;">\r\n\r\n                                    <li ng-repeat="category in categories">\r\n                                        <a href="" class="searchCategoryButton search-category-option"\r\n                                           ng-click="toggleCategory(category)">{{ category.name }}</a>\r\n                                    </li>\r\n                                </ul>\r\n                            </span>\r\n                            <span class="input-group-addon by-id-checkbox" ng-if="isAskById"\r\n                                  uib-tooltip="If enabled the search is done using an ID from TheTVDB or IMDB. The ID is retrieved using autocomplete."\r\n                                  tooltip-placement="top"\r\n                                  tooltip-trigger="mouseenter"\r\n                                  style="border-right-width: 0; width: 40px">\r\n                                <input type="checkbox" name="by-id" id="by-id" ng-model="isById.value"\r\n                                       style="margin-top:0;">\r\n                            </span>\r\n\r\n                            <div class="input-group-addon"\r\n                                 style="border-right-style: none; max-width: 250px; overflow: hidden; text-overflow: ellipsis; padding-right: 6px; width: {{selectedItemWidth}}"\r\n                                 ng-show="selectedItem.title">\r\n                                <button style="position: relative; top: -9px; right:-3px; font-size: xx-small; float: right; z-index: 1000; margin: 0; padding: 0; border: none; background-color: unset"\r\n                                        ng-click="clearAutocomplete()" id="clear-autocomplete-button">\r\n                                    <span class="glyphicon glyphicon-remove" style="font-size: xx-small;"></span>\r\n                                </button>\r\n                                <span id="selected-item-title">\r\n                                    {{selectedItem.title}}\r\n                                </span>\r\n                            </div>\r\n                            <input id="searchfield" type="search" ngtype="search" ng-model="query"\r\n                                ng-enter="onTypeAheadEnter()" placeholder="Search" typeahead-min-length="2"\r\n                                typeahead-wait-ms="typeAheadWait" ng-keydown="onTypeAheadKeyDown($event)"\r\n                                uib-typeahead="item as item.label for item in getAutocomplete($viewValue)"\r\n                                typeahead-template-url="autocompleteTemplate.html"\r\n                                ng-class="{\'autocompleteLoading\': (loadingItems && autocompleteActive), \'search-border\': !seriesSelected}"\r\n                                typeahead-loading="loadingItems"\r\n                                typeahead-on-select="selectAutocompleteItem($item)" class="form-control"\r\n                                focus-on="focus-query-box"\r\n                                autofocus auto-focus\r\n                                uib-tooltip="{{searchBoxTooltip}}"\r\n                                tooltip-placement="top"\r\n                                tooltip-trigger="mouseenter"\r\n                                style="border-right: none"\r\n                                ng-on-drop="onDropOnQueryInput($event)">\r\n                            <button style="position: absolute; top: 2px; right:{{seriesSelected() ? 185 : 105}}px; font-size: xx-small; float: right; z-index: 1000; margin: 0; padding: 0; border: none; background-color: unset"\r\n                                ng-click="clearQuery()" id="clear-query-button">\r\n                                <span class="glyphicon glyphicon-remove" style="font-size: xx-small;"></span>\r\n                            </button>\r\n                            <span class="input-group-btn" style="width:40px; border-left: none" ng-show="seriesSelected()">\r\n                                <input type="text" class="form-control season-input" placeholder="S" name="season"\r\n                                     id="seriesSearchS" style="width:40px; " ng-model="season"\r\n                                     ng-enter="initiateSearch()"\r\n                                     uib-tooltip="Enter a season to search for."\r\n                                     tooltip-placement="top"\r\n                                     tooltip-trigger="mouseenter">\r\n                            </span>\r\n                            <span class="input-group-btn" style="width:40px;" ng-show="seriesSelected()">\r\n                                <input type="text" class="form-control episode-input" placeholder="E" name="episode"\r\n                                     id="seriesSearchE" style="width:40px;" ng-model="episode"\r\n                                     ng-enter="initiateSearch()"\r\n                                     uib-tooltip="Enter an episode to search for."\r\n                                     tooltip-placement="top"\r\n                                     tooltip-trigger="mouseenter">\r\n                            </span>\r\n                            <span class="input-group-btn input-group-btn1" style="border-left-width: 1px">\r\n                                <div class="btn-group" uib-dropdown is-open="status.isopen">\r\n                                    <button id="history-dropdown-button" type="button" class="btn btn-default"\r\n                                        uib-dropdown-toggle\r\n                                        ng-enter="initiateSearch()"\r\n                                        uib-tooltip="Search history"\r\n                                        tooltip-placement="top"\r\n                                        tooltip-trigger="mouseenter">\r\n                                        <span class="glyphicon glyphicon-time" style="margin-right: 3px"></span><span class="caret"></span>\r\n                                    </button>\r\n                                    <ul class="dropdown-menu" uib-dropdown-menu\r\n                                        template-url="static/html/search-searchhistory-dropdown.html"\r\n                                        aria-labelledby="button-template-url">\r\n                                    </ul>\r\n                                </div>\r\n                            </span>\r\n\r\n                            <span class="input-group-btn input-group-btn2" style="width:51px;">\r\n                                <button class="btn btn-default" type="button" id="startsearch"\r\n                                        ng-click="initiateSearch()">Go!</button>\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </form>\r\n\r\n            <div ng-if="::showIndexerSelection">\r\n                <form class="form-horizontal">\r\n                    <div class="form-group">\r\n                        <label class="col-sm-2 control-label">Indexers</label>\r\n\r\n                        <div class="col-sm-18">\r\n                            <div class="d-flex flex-wrap align-items-center">\r\n                                <div indexer-selection-button available-indexers="availableIndexers"\r\n                                    selected-indexers="selectedIndexers" class="indexer-selection-button" style="margin-right: 10px;">\r\n                                </div>\r\n                                <label ng-repeat="indexer in availableIndexers" class="mb-0 mx-2 my-3">\r\n                                    <input type="checkbox" ng-class="{\'indexer-checkbox\': $index > 0}"\r\n                                        class="indexer-selection-checkbox" data-checklist-model="selectedIndexers"\r\n                                        data-checklist-value="indexer.name" indexer-name="{{indexer.name}}"> {{ indexer.name }}\r\n                                </label>\r\n\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </form>\r\n            </div>\r\n\r\n            <form class="form-horizontal form-search">\r\n                <div class="form-group">\r\n                    <div class="col-xs-20 col-sm-10">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-4 control-label">Age</label>\r\n                            <div class="col-xs-8 pe-2">\r\n                                <div class="input-group">\r\n                                    <span class="input-group-addon">Min</span>\r\n                                    <input type="number" class="form-control" id="minage" ng-model="minage" ng-enter="initiateSearch()">\r\n                                    <span class="input-group-addon">days</span>\r\n                                </div>\r\n                            </div>\r\n                            <div class="col-xs-8 ps-0">\r\n                                <div class="input-group">\r\n                                    <span class="input-group-addon">Max</span>\r\n                                    <input type="number" class="form-control" id="maxage" ng-model="maxage" ng-enter="initiateSearch()">\r\n                                    <span class="input-group-addon">days</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                    <div class="col-xs-20 col-sm-10">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-4 control-label">Size</label>\r\n\r\n                            <div class="col-xs-8 pe-2">\r\n                                <div class="input-group">\r\n                                    <span class="input-group-addon">Min</span>\r\n                                    <input type="number" class="form-control" id="minsize" ng-model="minsize" ng-enter="initiateSearch()">\r\n                                    <span class="input-group-addon">MB</span>\r\n                                </div>\r\n                            </div>\r\n                            <div class="col-xs-8 ps-0">\r\n                                <div class="input-group">\r\n                                    <span class="input-group-addon">Max</span>\r\n                                    <input type="number" class="form-control" id="maxsize" ng-model="maxsize" ng-enter="initiateSearch()">\r\n                                    <span class="input-group-addon">MB</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </form>\r\n\r\n        </div>\r\n\r\n    </div>\r\n\r\n    <!-- Search results go here -->\r\n    <div ui-view="results"></div>\r\n</div>\r\n');
$templateCache.put('static/html/states/stats.html','<ul class="nav nav-tabs" role="tablist">\r\n  <li role="presentation" ui-sref-active="active"><a ui-sref="root.stats.indexers" role="tab">Indexer statuses</a></li>\r\n  <li role="presentation" ui-sref-active="active" ng-if="bootstrapped.safeConfig.keepHistory"><a ui-sref="root.stats.searches" role="tab">Search history</a></li>\r\n  <li role="presentation" ui-sref-active="active" ng-if="bootstrapped.safeConfig.keepHistory"><a ui-sref="root.stats.downloads" role="tab">Download history</a></li>\r\n  <li role="presentation" ui-sref-active="active"><a ui-sref="root.stats.notifications" role="tab">Notification history</a></li>\r\n  <li role="presentation" ui-sref-active="active" ng-if="bootstrapped.safeConfig.keepHistory"><a ui-sref="root.stats.main" role="tab">Stats</a></li>\r\n</ul>\r\n\r\n<div ui-view="stats"></div>\r\n');
$templateCache.put('static/html/states/system.html','<ul class="nav nav-tabs" role="tablist">\n    <li ng-repeat="tab in allTabs" ng-class="{\'active\': $index == activeTab}">\n        <a href="" ng-click="goToSystemState($index)">{{ tab.name }}</a>\n    </li>\n</ul>\n\n<div class="tab-content" style="text-align: center">\n\n    <div class="system-tab-content" ng-if="activeTab==0">\n        <button class="btn btn-default" type="button" ng-click="shutdown()">Shutdown</button>\n        <button class="btn btn-default" type="button" ng-click="restart()">Restart</button>\n        <br>\n        <button class="btn btn-info" type="button" ng-click="reloadConfig()" style="margin-top: 20px">Reload config from\n            file\n        </button>\n        <br>\n        <button class="btn btn-info" type="button" ng-click="migrate()" style="margin-top: 20px">Migrate from NZBHydra\n            1\n        </button>\n    </div>\n\n    <div class="system-tab-content" ng-if="activeTab==1">\n        <hydraupdates></hydraupdates>\n    </div>\n\n    <div class="system-tab-content" ng-if="activeTab==2">\n        <hydralog></hydralog>\n    </div>\n\n    <div class="system-tab-content" ng-if="activeTab==3">\n        <hydra-tasks></hydra-tasks>\n    </div>\n\n    <div class="system-tab-content" ng-if="activeTab==4" style="text-align: center">\n        <hydrabackup></hydrabackup>\n    </div>\n\n    <div class="system-tab-content" ng-if="activeTab==5">\n        <ng-include src="\'static/html/bugreport.html\'"></ng-include>\n    </div>\n\n    <div class="system-tab-content" ng-if="activeTab==6" style="text-align: left">\n        <hydra-news></hydra-news>\n    </div>\n\n    <div class="system-tab-content" ng-if="activeTab==7">\n        <ng-include src="\'static/html/about.html\'"></ng-include>\n    </div>\n</div>\n\n');
$templateCache.put('static/html/update-modal.html','<!--\n  ~  (C) Copyright 2017 TheOtherP (theotherp@posteo.net)\n  ~\n  ~  Licensed under the Apache License, Version 2.0 (the "License");\n  ~  you may not use this file except in compliance with the License.\n  ~  You may obtain a copy of the License at\n  ~\n  ~      http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~  Unless required by applicable law or agreed to in writing, software\n  ~  distributed under the License is distributed on an "AS IS" BASIS,\n  ~  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n  ~  See the License for the specific language governing permissions and\n  ~  limitations under the License.\n  -->\n\n<div class="modal-header">\n    <h3 class="modal-title">Update in progress</h3>\n</div>\n<div class="modal-body" style="text-align: left">\n    <img src="static/img/spinner.gif" ng-if="!messages"/>\n\n    <div ng-if="messages" style="text-align: left">\n\n        <ul style="padding-left: 0">\n            <li ng-repeat="message in messages" style="list-style-type: none">\n                {{message}} <img src="static/img/spinner.gif" ng-show="$last"/>\n            </li>\n\n        </ul>\n\n    </div>\n</div>\n');
$templateCache.put('static/html/welcome-modal.html','<div class="modal-header">\r\n    <h3 class="modal-title">Welcome to NZBHydra 2</h3>\r\n</div>\r\n<div class="modal-body" style="text-align: left">\r\n    This seems to be the first time that you started NZBHydra 2.\r\n    <br><br>\r\n    If you\'re already using NZBHydra 1 (python based) you can <a href="#" ng-click="startMigration()">migrate your\r\n    data</a>.\r\n    <br><br>\r\n    If you\'re a new user (or don\'t want to migrate your data right now) you can start by <a href="#"\r\n                                                                                            ng-click="goToConfig()">configuring\r\n    NZBHydra 2</a>.\r\n    <br>\r\n    You will not be able to use it until you\'ve added at least one indexer.\r\n    <br><br>\r\n    If you\'re stuck you can refer to <a href="https://github.com/theotherp/nzbhydra2/wiki">the wiki</a> or the online\r\n    help (available from the config).<br>\r\n    If you haven\'t found an answer there you\'re welcome to <a href="https://github.com/theotherp/nzbhydra2/issues">raise\r\n    a GitHub issue</a>.\r\n\r\n</div>\r\n<div class="modal-footer">\r\n    <button class="btn btn-success" type="button" ng-click="close()">Close</button>\r\n</div>\r\n');}]);