/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Strings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Map;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.lang3.tuple.Pair;
import org.nzbhydra.NativeHints;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.BaseConfigHandler;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.ConfigReaderWriter;
import org.nzbhydra.config.migration.ConfigMigration;
import org.nzbhydra.debuginfos.DebugInfosProvider;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.misc.BrowserOpener;
import org.nzbhydra.web.UrlCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.embedded.tomcat.ConnectorStartFailedException;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.error.YAMLException;

/*
 * Exception performing whole class analysis ignored.
 */
@ImportRuntimeHints(value={NativeHints.class})
@Configuration(proxyBeanMethods=false)
@EnableAutoConfiguration(exclude={AopAutoConfiguration.class, CacheAutoConfiguration.class})
@ComponentScan
@RestController
@EnableCaching
@EnableScheduling
@EnableTransactionManagement
public class NzbHydra {
    private static final Logger logger = LoggerFactory.getLogger(NzbHydra.class);
    public static final String BROWSER_DISABLED = "browser.disabled";
    public static final long USABLE_MB_NEEDED = 500L;
    public static String[] originalArgs;
    private static ConfigurableApplicationContext applicationContext;
    private static String dataFolder;
    private static boolean wasRestarted;
    private static boolean anySettingsOverwritten;
    private static final ConfigReaderWriter CONFIG_READER_WRITER;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private UrlCalculator urlCalculator;
    @Autowired
    private BrowserOpener browserOpener;
    @Autowired
    private GenericStorage genericStorage;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private BaseConfigHandler baseConfigHandler;
    @Autowired
    private DebugInfosProvider debugInfosProvider;

    public static void main(String[] args) throws Exception {
        if (NzbHydra.isNativeBuild()) {
            logger.warn("Running for native build");
            String dataFolder = "./data";
            NzbHydra.setDataFolder((String)dataFolder);
            System.setProperty("nzbhydra.dataFolder", dataFolder);
            System.setProperty("spring.datasource.url", "jdbc:h2:mem:testdb;NON_KEYWORDS=YEAR,DATA,KEY");
            NzbHydra.setApplicationPropertiesFromConfig();
            SpringApplication hydraApplication = new SpringApplication(new Class[]{NzbHydra.class});
            applicationContext = hydraApplication.run(args);
            logger.info("Native application returned");
            return;
        }
        OptionParser parser = new OptionParser();
        parser.accepts("datafolder", "Define path to main data folder. Must start with ./ for relative paths").withRequiredArg().defaultsTo((Object)"./data", (Object[])new String[0]);
        parser.accepts("host", "Run on this host").withOptionalArg();
        parser.accepts("nobrowser", "Don't open browser to Hydra");
        parser.accepts("port", "Run on this port (default: 5076)").withOptionalArg();
        parser.accepts("baseurl", "Set base URL (e.g. /nzbhydra)").withOptionalArg();
        parser.accepts("help", "Print help");
        parser.accepts("version", "Print version");
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException e) {
            logger.error("Invalid startup options detected: {}", (Object)e.getMessage());
            System.exit(1);
        }
        NzbHydra.setDataFolder((OptionSet)options);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
        } else if (options.has("version")) {
            System.out.println((String)DebugInfosProvider.getVersionAndBuildTimestamp().getLeft());
        } else if (System.getProperty("fromWrapper") == null && Arrays.stream(args).noneMatch(x -> x.equals("directstart"))) {
            logger.info("NZBHydra 2 must be started using the wrapper for restart and updates to work. If for some reason you need to start it from the JAR directly provide the command line argument \"directstart\"");
        } else {
            NzbHydra.startup((String[])args, (OptionSet)options);
        }
    }

    private static void setDataFolder(OptionSet options) throws IOException {
        dataFolder = options.has("datafolder") ? (String)options.valueOf("datafolder") : "./data";
        File dataFolderFile = new File(dataFolder);
        dataFolder = dataFolderFile.getCanonicalPath();
    }

    protected static void startup(String[] args, OptionSet options) throws Exception {
        block6: {
            long requiredSpaceBytes;
            long usableSpaceBytes;
            Pair versionAndBuildTimestamp = DebugInfosProvider.getVersionAndBuildTimestamp();
            logger.info("Version: {}", versionAndBuildTimestamp.getLeft());
            logger.info("Build timestamp: {}", versionAndBuildTimestamp.getRight());
            File dataFolderFile = new File(dataFolder);
            if (!dataFolderFile.exists() && !dataFolderFile.mkdirs()) {
                logger.error("Unable to read or write data folder {}", (Object)dataFolder);
                System.exit(1);
            }
            if ((usableSpaceBytes = dataFolderFile.getUsableSpace()) < (requiredSpaceBytes = 524288000L)) {
                long usableSpaceMB = usableSpaceBytes / 0x100000L;
                logger.error("Insufficient disk space in data folder {}. Required: {} MB, Available: {} MB", new Object[]{dataFolder, 500L, usableSpaceMB});
                System.exit(1);
            }
            if (NzbHydra.isOsWindows()) {
                String programFiles = Strings.nullToEmpty((String)System.getenv("PROGRAMFILES")).toLowerCase();
                String programFilesx86 = Strings.nullToEmpty((String)System.getenv("PROGRAMFILES(X86)")).toLowerCase();
                if (dataFolderFile.getAbsolutePath().toLowerCase().contains(programFiles) || dataFolderFile.getAbsolutePath().toLowerCase().contains(programFilesx86)) {
                    logger.error("NZBHydra 2 may not work properly when run your windows program files folder. Please put it somewhere else");
                    System.exit(1);
                }
            }
            try {
                System.setProperty("nzbhydra.dataFolder", dataFolder);
                File yamlFile = new File(dataFolder, "nzbhydra.yml");
                NzbHydra.initializeAndValidateAndMigrateYamlFile((File)yamlFile);
                NzbHydra.useIfSet((OptionSet)options, (String)"host", (String)"server.address");
                NzbHydra.useIfSet((OptionSet)options, (String)"port", (String)"server.port");
                NzbHydra.useIfSet((OptionSet)options, (String)"baseurl", (String)"server.servlet.context-path");
                NzbHydra.useIfSet((OptionSet)options, (String)"nobrowser", (String)"browser.disabled", (String)"true");
                NzbHydra.setApplicationPropertiesFromConfig();
                SpringApplication hydraApplication = new SpringApplication(new Class[]{NzbHydra.class});
                originalArgs = args;
                wasRestarted = Arrays.asList(args).contains("restarted");
                hydraApplication.setHeadless(true);
                applicationContext = hydraApplication.run(args);
            }
            catch (Exception e) {
                if (e instanceof SpringApplication.AbandonedRunException) break block6;
                NzbHydra.handleException((Exception)e);
            }
        }
    }

    private static void setApplicationPropertiesFromConfig() throws IOException {
        BaseConfig baseConfig = CONFIG_READER_WRITER.loadSavedConfig();
        NzbHydra.setApplicationProperty((String)"main.host", (String)"MAIN_HOST", (String)baseConfig.getMain().getHost());
        NzbHydra.setApplicationProperty((String)"main.port", (String)"MAIN_PORT", (String)String.valueOf(baseConfig.getMain().getPort()));
        NzbHydra.setApplicationProperty((String)"main.urlBase", (String)"MAIN_URL_BASE", (String)baseConfig.getMain().getUrlBase().orElse("/"));
        NzbHydra.setApplicationProperty((String)"main.ssl", (String)"MAIN_SSL", (String)String.valueOf(baseConfig.getMain().isSsl()));
        NzbHydra.setApplicationProperty((String)"main.sslKeyStore", (String)"MAIN_SSL_KEY_STORE", (String)baseConfig.getMain().getSslKeyStore());
        NzbHydra.setApplicationProperty((String)"main.sslKeyStorePassword", (String)"MAIN_SSL_KEY_STORE_PASSWORD", (String)baseConfig.getMain().getSslKeyStorePassword());
        NzbHydra.setApplicationProperty((String)"main.databaseCompactTime", (String)"MAIN_DATABASE_COMPACT_TIME", (String)String.valueOf(baseConfig.getMain().getDatabaseCompactTime()));
        NzbHydra.setApplicationProperty((String)"main.databaseRetentionTime", (String)"MAIN_DATABASE_RETENTION_TIME", (String)String.valueOf(baseConfig.getMain().getDatabaseRetentionTime()));
        NzbHydra.setApplicationProperty((String)"main.databaseWriteDelay", (String)"MAIN_DATABASE_WRITE_DELA", (String)String.valueOf(baseConfig.getMain().getDatabaseWriteDelay()));
        NzbHydra.setApplicationProperty((String)"main.logging.consolelevel", (String)"MAIN_LOGGING_CONSOLELEVEL", (String)baseConfig.getMain().getLogging().getConsolelevel());
        NzbHydra.setApplicationProperty((String)"main.logging.logfilelevel", (String)"MAIN_LOGGING_LOGFILELEVEL", (String)baseConfig.getMain().getLogging().getLogfilelevel());
        NzbHydra.setApplicationProperty((String)"main.logging.logMaxHistory", (String)"MAIN_LOGGING_LOG_MAX_HISTORY", (String)String.valueOf(baseConfig.getMain().getLogging().getLogMaxHistory()));
        if (baseConfig.getMain().getLogging().getMarkersToLog().contains(LoggingMarkers.SERVER.getName())) {
            System.setProperty("logback.access.enabled", "true");
        } else {
            System.setProperty("logback.access.enabled", "false");
        }
        if (baseConfig.getMain().getLogging().getMarkersToLog().contains(LoggingMarkers.HTTPS.getName())) {
            System.setProperty("javax.net.debug", "ssl:handshake:verbose:keymanager:trustmanager");
            if (System.getProperty("dontRedirectConsole") == null) {
                File systemErrLogFile = new File(NzbHydra.getDataFolder(), "logs/system.err.log");
                File systemOutLogFile = new File(NzbHydra.getDataFolder(), "logs/system.out.log");
                logger.info("Enabling SSL debugging. Will write to {}", (Object)systemErrLogFile);
                System.setErr(new PrintStream(Files.newOutputStream(systemErrLogFile.toPath(), new OpenOption[0])));
                logger.info("Redirecting console output to system.out.log. You will not see any more log output in the console until you disable the HTTPS marker and restart NZBHydra");
                System.setOut(new PrintStream(Files.newOutputStream(systemOutLogFile.toPath(), new OpenOption[0])));
            }
        }
    }

    private static void setApplicationProperty(String key, String envKey, String value) {
        if (value != null && System.getProperty(key) == null && System.getenv(envKey) == null) {
            System.setProperty(key, value);
            logger.debug("Setting {} to {}", (Object)key, (Object)value);
        }
    }

    private static void initializeAndValidateAndMigrateYamlFile(File yamlFile) throws IOException {
        if (NzbHydra.isNativeBuild()) {
            return;
        }
        CONFIG_READER_WRITER.initializeIfNeeded(yamlFile);
        CONFIG_READER_WRITER.validateExistingConfig();
        Map map = CONFIG_READER_WRITER.loadSavedConfigAsMap();
        Map migrated = new ConfigMigration().migrate(map);
        CONFIG_READER_WRITER.save(migrated, yamlFile);
    }

    private static void handleException(Exception e) throws Exception {
        Object msg;
        if (e.getClass().getName().contains("SilentExitException")) {
            return;
        }
        if (e instanceof YAMLException || e instanceof JsonProcessingException) {
            msg = "The file " + new File(dataFolder, "nzbhydra.yml").getAbsolutePath() + " could not be parsed properly. It might be corrupted. Try restoring it from a backup. Error message: " + e.getMessage();
            logger.error((String)msg);
        }
        if (e instanceof ConnectorStartFailedException) {
            msg = "The selected port is already in use. Either shut the other application down or select another port";
            logger.error((String)msg);
        }
        if (e.getMessage() != null && e.getMessage().contains("Detected applied migration not resolved locally")) {
            msg = "The existing database was created by a newer version of the program than the one you're running. Make sure to get the latest release. ";
            logger.error((String)msg);
        } else {
            msg = "An unexpected error occurred during startup:\n" + String.valueOf(e);
            logger.error("An unexpected error occurred during startup", (Throwable)e);
        }
        logger.error("FATAL: " + (String)msg, (Throwable)e);
        throw e;
    }

    public static boolean isOsWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    @PostConstruct
    public void warnIfSettingsOverwritten() {
        if (anySettingsOverwritten) {
            logger.warn("Overwritten settings will be displayed with their original value in the config section of the GUI");
        }
    }

    private static void useIfSet(OptionSet options, String optionKey, String propertyName) {
        NzbHydra.useIfSet((OptionSet)options, (String)optionKey, (String)propertyName, (String)((String)options.valueOf(optionKey)));
    }

    private static void useIfSet(OptionSet options, String optionKey, String propertyName, String propertyValue) {
        if (options.has(optionKey)) {
            logger.debug("Setting property {} to value {}", (Object)propertyName, (Object)propertyValue);
            System.setProperty(propertyName, propertyValue);
            anySettingsOverwritten = true;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static String getDataFolder() {
        return dataFolder;
    }

    @EventListener
    public void startupDone(ApplicationReadyEvent event) {
        try {
            this.configProvider.getBaseConfig().setGenericStorage(new ConfigReaderWriter().loadSavedConfig().getGenericStorage());
            if (this.genericStorage.get("FirstStart", LocalDateTime.class).isEmpty()) {
                logger.info("First start of NZBHydra detected");
                this.genericStorage.save("FirstStart", (Serializable)LocalDateTime.now());
                this.baseConfigHandler.save(false);
            }
            if (DebugInfosProvider.isRunInDocker()) {
                logger.info("You seem to be running NZBHydra 2 in docker. You can access Hydra using your local address and the IP you provided");
            } else {
                if (this.configProvider.getBaseConfig().getMain().isStartupBrowser() && !"true".equals(System.getProperty("browser.disabled"))) {
                    if (wasRestarted) {
                        logger.info("Not opening browser after restart");
                        return;
                    }
                    logger.debug("Opening browser");
                    this.browserOpener.openBrowser();
                }
                URI uri = this.urlCalculator.getLocalBaseUriBuilder().build().toUri();
                logger.info("You can access NZBHydra 2 in your browser via {}", (Object)uri);
            }
        }
        catch (Exception e) {
            logger.error("Unable to complete startup initialization", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        logger.info("Shutting down");
    }

    @Bean
    @Primary
    public CacheManager genericCacheManager() {
        return new CaffeineCacheManager(new String[]{"infos", "titles", "updates", "dev"});
    }

    public static void setDataFolder(String dataFolder) {
        NzbHydra.dataFolder = dataFolder;
    }

    public static boolean isNativeBuild() {
        String hydraNativeBuildEnv = System.getenv("HYDRA_NATIVE_BUILD");
        String hydraNativeBuildProperty = System.getProperty("HYDRA_NATIVE_BUILD");
        return hydraNativeBuildEnv != null || hydraNativeBuildProperty != null;
    }

    static {
        dataFolder = null;
        wasRestarted = false;
        anySettingsOverwritten = false;
        CONFIG_READER_WRITER = new ConfigReaderWriter();
    }
}

