/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.api.stats;

import java.util.List;
import java.util.Objects;
import org.nzbhydra.api.IllegalAccessException;
import org.nzbhydra.api.WrongApiKeyException;
import org.nzbhydra.api.stats.ApiHistoryRequest;
import org.nzbhydra.api.stats.ApiStatsRequest;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.downloading.FileDownloadEntity;
import org.nzbhydra.historystats.History;
import org.nzbhydra.historystats.Stats;
import org.nzbhydra.historystats.StatsResponse;
import org.nzbhydra.indexers.status.IndexerStatusesAndLimits;
import org.nzbhydra.searching.db.SearchEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExternalApiStats {
    private static final Logger logger = LoggerFactory.getLogger(ExternalApiStats.class);
    @Value(value="${nzbhydra.dev.noApiKey:false}")
    private boolean noApiKeyNeeded = false;
    @Autowired
    protected ConfigProvider configProvider;
    @Autowired
    private Stats stats;
    @Autowired
    private IndexerStatusesAndLimits indexerStatuses;
    @Autowired
    private History history;

    @RequestMapping(value={"/api/stats"}, consumes={"*/*"}, produces={"application/json"})
    public StatsResponse apiStats(@RequestBody ApiStatsRequest request) throws Exception {
        this.verifyAccessAllowed(request.getApikey());
        return this.stats.getAllStats(request.getRequest());
    }

    @RequestMapping(value={"/api/stats/indexers"}, consumes={"*/*"}, produces={"application/json"})
    public List<IndexerStatusesAndLimits.IndexerStatus> indexerStatuses(@RequestBody ApiHistoryRequest request) throws Exception {
        this.verifyAccessAllowed(request.getApikey());
        return this.indexerStatuses.getSortedStatuses();
    }

    @RequestMapping(value={"/api/history/searches"}, consumes={"*/*"}, produces={"application/json"})
    public Page<SearchEntity> apiHistorySearches(@RequestBody ApiHistoryRequest request) throws Exception {
        this.verifyAccessAllowed(request.getApikey());
        return this.history.getHistory(request.getRequest(), "SEARCH x", SearchEntity.class);
    }

    @RequestMapping(value={"/api/history/downloads"}, consumes={"*/*"}, produces={"application/json"})
    public Page<FileDownloadEntity> apiHistoryDownloads(@RequestBody ApiHistoryRequest request) throws Exception {
        this.verifyAccessAllowed(request.getApikey());
        return this.history.getHistory(request.getRequest(), "INDEXERNZBDOWNLOAD x left join SEARCHRESULT s on x.SEARCH_RESULT_ID = s.ID LEFT JOIN INDEXER i ON s.INDEXER_ID = i.ID", FileDownloadEntity.class);
    }

    protected void verifyAccessAllowed(String apikey) throws IllegalAccessException {
        if (!this.noApiKeyNeeded && !Objects.equals(apikey, this.configProvider.getBaseConfig().getMain().getApiKey())) {
            logger.error("Received API call with wrong API key");
            throw new WrongApiKeyException("Wrong api key");
        }
        if (!this.configProvider.getBaseConfig().getAuth().isAllowApiStats()) {
            throw new IllegalAccessException("Stats access forbidden");
        }
    }
}

