/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.auth.AuthConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class HydraAnonymousAuthenticationFilter
extends AnonymousAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(HydraAnonymousAuthenticationFilter.class);
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private String key = "anonymous";
    private Object principal = "AnonymousUser";
    private List<GrantedAuthority> authorities = new ArrayList();
    private boolean enabled = false;

    public HydraAnonymousAuthenticationFilter(@Autowired ConfigProvider configProvider) {
        super("anonymous", (Object)"anonymousUser", AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
        this.updateAuthorities(configProvider.getBaseConfig().getAuth());
    }

    public void enable() {
        this.enabled = true;
    }

    @EventListener
    public void handleConfigChangedEvent(ConfigChangedEvent event) {
        this.updateAuthorities(event.getNewConfig().getAuth());
        if (!this.authorities.isEmpty()) {
            this.enable();
        }
    }

    private void updateAuthorities(AuthConfig authConfig) {
        ArrayList<String> anonymousUserRoles = new ArrayList<String>();
        if (!authConfig.isRestrictSearch()) {
            anonymousUserRoles.add("ROLE_USER");
            logger.info("Granting basic user rights to anonymous users");
        }
        if (!authConfig.isRestrictStats()) {
            anonymousUserRoles.add("ROLE_STATS");
            logger.info("Granting stats rights to anonymous users");
        }
        if (!authConfig.isRestrictAdmin()) {
            anonymousUserRoles.add("ROLE_ADMIN");
            logger.info("Granting admin rights to anonymous users");
        }
        if (!anonymousUserRoles.isEmpty()) {
            anonymousUserRoles.add("ROLE_ANONYMOUS");
        }
        this.authorities = AuthorityUtils.createAuthorityList((String[])anonymousUserRoles.toArray(new String[0]));
    }

    public void afterPropertiesSet() {
        Assert.hasLength((String)this.key, (String)"key must have length");
        Assert.notNull((Object)this.principal, (String)"Anonymous authentication principal must be set");
        Assert.notNull((Object)this.authorities, (String)"Anonymous authorities must be set");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.enabled && SecurityContextHolder.getContext().getAuthentication() == null & !this.authorities.isEmpty()) {
            SecurityContextHolder.getContext().setAuthentication(this.createAuthentication((HttpServletRequest)req));
        }
        chain.doFilter(req, res);
    }

    protected Authentication createAuthentication(HttpServletRequest request) {
        AnonymousAuthenticationToken auth = new AnonymousAuthenticationToken(this.key, this.principal, (Collection)this.authorities);
        auth.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return auth;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public List<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }
}

