/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.nzbhydra.auth.LoginAndAccessAttemptService;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.auth.AuthConfig;
import org.nzbhydra.config.auth.UserAuthConfig;
import org.nzbhydra.web.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Component;

@Component
public class HydraUserDetailsManager
implements UserDetailsManager {
    private static final Logger logger = LoggerFactory.getLogger(HydraUserDetailsManager.class);
    private final Map<String, UserDetails> users = new HashMap();
    @Autowired
    private LoginAndAccessAttemptService attemptService;

    public HydraUserDetailsManager(@Autowired BaseConfig baseConfig) {
        this.updateUsers(baseConfig.getAuth());
    }

    private void updateUsers(AuthConfig authConfig) {
        this.users.clear();
        for (UserAuthConfig userAuthConfig : authConfig.getUsers()) {
            ArrayList<SimpleGrantedAuthority> userRoles = new ArrayList<SimpleGrantedAuthority>();
            if (userAuthConfig.isMaySeeAdmin() || !authConfig.isRestrictAdmin()) {
                userRoles.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
                userRoles.add(new SimpleGrantedAuthority("ROLE_STATS"));
                userRoles.add(new SimpleGrantedAuthority("ROLE_DETAILS"));
                userRoles.add(new SimpleGrantedAuthority("ROLE_SHOW_INDEXERS"));
            } else {
                if (userAuthConfig.isMaySeeStats() || !authConfig.isRestrictStats()) {
                    userRoles.add(new SimpleGrantedAuthority("ROLE_STATS"));
                }
                if (userAuthConfig.isMaySeeDetailsDl() || !authConfig.isRestrictDetailsDl()) {
                    userRoles.add(new SimpleGrantedAuthority("ROLE_DETAILS"));
                }
                if (userAuthConfig.isShowIndexerSelection() || !authConfig.isRestrictIndexerSelection()) {
                    userRoles.add(new SimpleGrantedAuthority("ROLE_SHOW_INDEXERS"));
                }
            }
            userRoles.add(new SimpleGrantedAuthority("ROLE_USER"));
            User user = new User(userAuthConfig.getUsername(), userAuthConfig.getPassword(), userRoles);
            this.users.put(userAuthConfig.getUsername(), user);
        }
    }

    public void createUser(UserDetails user) {
    }

    public void updateUser(UserDetails user) {
    }

    public void deleteUser(String username) {
    }

    public void changePassword(String oldPassword, String newPassword) {
    }

    public boolean userExists(String username) {
        return this.users.containsKey(username.toLowerCase());
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if (SessionStorage.IP.get() != null && this.attemptService.isBlocked((String)SessionStorage.IP.get())) {
            logger.warn("Blocking access from IP {} because the maximum amount of attempts was reached", SessionStorage.IP.get());
            throw new RuntimeException("IP " + (String)SessionStorage.IP.get() + " is currently blocked");
        }
        UserDetails user = (UserDetails)this.users.get(username);
        if (user == null) {
            throw new UsernameNotFoundException(username);
        }
        return new User(user.getUsername(), user.getPassword(), user.isEnabled(), user.isAccountNonExpired(), user.isCredentialsNonExpired(), user.isAccountNonLocked(), user.getAuthorities());
    }

    @EventListener
    public void handleConfigChangedEvent(ConfigChangedEvent event) {
        this.updateUsers(event.getNewConfig().getAuth());
    }
}

