/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import com.google.common.base.Objects;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class HydraWebAuthenticationDetails
extends WebAuthenticationDetails {
    private final String filteredIp;

    public HydraWebAuthenticationDetails(HttpServletRequest request) {
        super(request);
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null) {
            ip = request.getHeader("X-Real-IP");
        }
        ip = ip != null ? ip.split(",")[0] : request.getRemoteAddr();
        this.filteredIp = ip;
    }

    public String getFilteredIp() {
        return this.filteredIp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HydraWebAuthenticationDetails)) {
            return false;
        }
        HydraWebAuthenticationDetails that = (HydraWebAuthenticationDetails)o;
        return Objects.equal((Object)this.filteredIp, (Object)that.filteredIp);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.filteredIp});
    }
}

