/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.nzbhydra.web.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoginAndAccessAttemptService {
    private static final Logger logger = LoggerFactory.getLogger(LoginAndAccessAttemptService.class);
    private final int MAX_ATTEMPTS = 5;
    private final LoadingCache<String, Integer> attemptsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    public void accessSucceeded(String key) {
        if (key == null) {
            logger.warn("Unable to log successul login by empty IP/host");
            return;
        }
        this.attemptsCache.invalidate((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessFailed(String key) {
        LoadingCache loadingCache = this.attemptsCache;
        synchronized (loadingCache) {
            if (key == null) {
                logger.warn("Unable to log failed login by empty IP/host");
                return;
            }
            int attempts = (Integer)this.attemptsCache.getUnchecked((Object)key);
            this.attemptsCache.put((Object)key, (Object)(++attempts));
            logger.warn("{} failed access attempts from IP/host {} in the last 24 hours. Will block access after {} failed attempts", new Object[]{attempts, SessionStorage.IP.get(), 5});
        }
    }

    public boolean isBlocked(String key) {
        return (Integer)this.attemptsCache.getUnchecked((Object)key) >= 5;
    }

    public boolean wasUnsuccessfulBefore(String key) {
        if (key == null) {
            logger.warn("Unable to determine unsuccessul login by empty IP/host. Will assume this access is OK");
            return true;
        }
        return (Integer)this.attemptsCache.getUnchecked((Object)key) > 0;
    }
}

