/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.backup;

import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Optional;
import org.nzbhydra.backup.BackupAndRestore;
import org.nzbhydra.backup.BackupData;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.tasks.HydraTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackupTask {
    private static final Logger logger = LoggerFactory.getLogger(BackupTask.class);
    private static final long HOUR = 3600000L;
    public static final String KEY = "BackupData";
    @Autowired
    private BackupAndRestore backupAndRestore;
    @Autowired
    private GenericStorage genericStorage;
    @Autowired
    private ConfigProvider configProvider;
    protected Clock clock = Clock.systemUTC();

    @HydraTask(configId="Backup", name="Backup", interval=3600000L)
    public void createBackup() {
        boolean backupEnabled = this.configProvider.getBaseConfig().getMain().getBackupEveryXDays().isPresent();
        if (!backupEnabled) {
            logger.debug("Automatic backup is disabled");
            return;
        }
        int backupEveryXDays = (Integer)this.configProvider.getBaseConfig().getMain().getBackupEveryXDays().get();
        Optional firstStartOptional = this.genericStorage.get("FirstStart", LocalDateTime.class);
        if (firstStartOptional.isEmpty()) {
            logger.debug("First start date time not set (for some reason), aborting backup");
            return;
        }
        long daysSinceFirstStart = ChronoUnit.DAYS.between((Temporal)firstStartOptional.get(), LocalDateTime.now(this.clock));
        if (daysSinceFirstStart < (long)backupEveryXDays) {
            logger.debug("{} days since first start but backup is to be executed every {} days", (Object)daysSinceFirstStart, (Object)backupEveryXDays);
            return;
        }
        Optional backupData = this.genericStorage.get(KEY, BackupData.class);
        if (backupData.isEmpty()) {
            logger.debug("Executing first backup: {} days since first start and backup is to be executed every {} days", (Object)daysSinceFirstStart, (Object)backupEveryXDays);
            this.executeBackup();
            return;
        }
        long daysSinceLastBackup = ChronoUnit.DAYS.between(((BackupData)backupData.get()).getLastBackup(), LocalDateTime.now(this.clock));
        if (daysSinceLastBackup >= (long)backupEveryXDays) {
            logger.debug("Executing backup: {} days since last backup and backup is to be executed every {} days", (Object)daysSinceLastBackup, (Object)backupEveryXDays);
            this.executeBackup();
        }
    }

    private void executeBackup() {
        try {
            logger.info("Starting weekly backup");
            this.backupAndRestore.backup(false);
            this.genericStorage.save(KEY, (Serializable)new BackupData(LocalDateTime.now(this.clock)));
        }
        catch (Exception e) {
            logger.error("An error occured while doing a background backup", (Throwable)e);
        }
    }
}

