/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.cache;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.nzbhydra.logging.LoggingMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.support.AbstractValueAdaptingCache;

public class DiskCache
extends AbstractValueAdaptingCache {
    private static final Logger logger = LoggerFactory.getLogger(DiskCache.class);
    private static final int MAX_ENTRIES = 500;
    private static final int MAX_ENTRIES_SIZE_MB = 50;
    private static final Map<String, Instant> ACCESS_MAP = new HashMap();
    private final File cacheDir;
    private final String name;

    public DiskCache(File cacheDir, String name) {
        super(false);
        this.cacheDir = cacheDir;
        this.name = name;
        boolean created = cacheDir.mkdirs();
        if (!cacheDir.exists()) {
            throw new RuntimeException("Error creating cache dir " + cacheDir.getAbsolutePath());
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        if (key instanceof String) {
            String keyString = (String)key;
            ACCESS_MAP.put(keyString, Instant.now());
            File keyFile = this.buildKeyFile(keyString);
            if (keyFile.exists()) {
                return (T)Files.readAllBytes(keyFile.toPath());
            }
            T value = valueLoader.call();
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                Files.write(keyFile.toPath(), bytes, new OpenOption[0]);
                return value;
            }
            throw new RuntimeException("Illegal type for value " + String.valueOf(value.getClass()));
        }
        throw new RuntimeException("Illegal type for key " + String.valueOf(key.getClass()));
    }

    public void put(Object key, Object value) {
        String keyString;
        block5: {
            block4: {
                if (!(key instanceof String)) break block4;
                keyString = (String)key;
                if (value instanceof byte[]) break block5;
            }
            throw new RuntimeException("Illegal type for key " + String.valueOf(key.getClass()) + " and/or value " + String.valueOf(value.getClass()));
        }
        byte[] valueBytes = (byte[])value;
        logger.debug(LoggingMarkers.DISK_CACHE, "Writing entry with key {} and size {}", (Object)keyString, (Object)valueBytes.length);
        Files.write(this.buildKeyFile(keyString).toPath(), valueBytes, new OpenOption[0]);
        ACCESS_MAP.put(keyString, Instant.now());
        this.cleanAfterPut();
    }

    private void cleanAfterPut() {
        while (ACCESS_MAP.size() > 500) {
            logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "{} entries in cache - exceeds limit of {}", (Object)ACCESS_MAP.size(), (Object)500);
            this.deleteOldestEntry();
        }
        while (Arrays.stream(this.cacheDir.listFiles()).mapToDouble(File::length).sum() / 1048576.0 > 50.0) {
            logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Cache takes up too much space (more than {})", (Object)50);
            this.deleteOldestEntry();
        }
    }

    private void deleteOldestEntry() {
        Optional oldestEntry = ACCESS_MAP.entrySet().stream().min(Map.Entry.comparingByValue());
        if (oldestEntry.isPresent()) {
            logger.debug(LoggingMarkers.DISK_CACHE, "Removing oldest entry {}", oldestEntry.get());
            ACCESS_MAP.remove(oldestEntry.get().getKey());
            FileUtils.deleteQuietly((File)this.buildKeyFile((String)oldestEntry.get().getKey()));
        }
    }

    @NotNull
    private File buildKeyFile(String keyString) {
        String sanitizedKey = keyString.replaceAll("[/\\\\:*?\"<>|.]", "_");
        return new File(this.cacheDir, sanitizedKey);
    }

    public void evict(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            File keyFile = this.buildKeyFile(keyString);
            if (keyFile.exists()) {
                logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Evicting entry {}", (Object)keyString);
                ACCESS_MAP.remove(keyString);
                FileUtils.deleteQuietly((File)keyFile);
            } else {
                logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Can't evict not existing entry {}", (Object)keyString);
            }
        }
    }

    public void clear() {
        if (!this.cacheDir.exists()) {
            return;
        }
        logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Clearing cache");
        FileUtils.cleanDirectory((File)this.cacheDir);
        ACCESS_MAP.clear();
    }

    protected Object lookup(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            File keyFile = this.buildKeyFile(keyString);
            if (keyFile.exists()) {
                logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Found entry for key {}", (Object)keyString);
                return Files.readAllBytes(keyFile.toPath());
            }
            logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Did not find entry for key {}", (Object)keyString);
        }
        return null;
    }
}

