/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.ConfigReaderWriter;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.validation.BaseConfigValidator;
import org.nzbhydra.logging.LoggingMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class BaseConfigHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseConfigHandler.class);
    private final ConfigReaderWriter configReaderWriter = new ConfigReaderWriter();
    private final Lock saveLock = new ReentrantLock();
    private BaseConfig toSave;
    private TimerTask delayedSaveTimerTask;
    public boolean initialized = false;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private BaseConfig baseConfig;
    @Autowired
    private BaseConfigValidator baseConfigValidator;

    @PostConstruct
    public void init() throws IOException {
        if (this.initialized) {
            logger.warn("Init method called again. This can only happen during a faulty shutdown");
            return;
        }
        logger.info("Using data folder {}", (Object)NzbHydra.getDataFolder());
        this.replace(this.configReaderWriter.loadSavedConfig(), false);
        if (this.baseConfig.getMain().getApiKey() == null) {
            this.baseConfigValidator.initializeNewConfig(this.baseConfig);
        }
        this.configReaderWriter.save(this.baseConfig);
        this.delayedSaveTimerTask = new /* Unavailable Anonymous Inner Class!! */;
        Timer delayedSaveTimer = new Timer("delayedConfigSave", false);
        delayedSaveTimer.scheduleAtFixedRate(this.delayedSaveTimerTask, 10000L, 10000L);
        this.initialized = true;
    }

    public void replace(BaseConfig newConfig) {
        this.replace(newConfig, true);
    }

    public void replace(BaseConfig newConfig, boolean fireConfigChangedEvent) {
        BaseConfig oldBaseConfig = this.configReaderWriter.getCopy(this.baseConfig);
        this.baseConfig.setMain(newConfig.getMain());
        this.baseConfig.setIndexers(newConfig.getIndexers().stream().sorted(Comparator.comparing(IndexerConfig::getName)).collect(Collectors.toList()));
        this.baseConfig.setCategoriesConfig(newConfig.getCategoriesConfig());
        this.baseConfig.setSearching(newConfig.getSearching());
        this.baseConfig.setDownloading(newConfig.getDownloading());
        this.baseConfig.setAuth(newConfig.getAuth());
        this.baseConfig.setGenericStorage(newConfig.getGenericStorage());
        this.baseConfig.setNotificationConfig(newConfig.getNotificationConfig());
        this.baseConfig.setEmby(newConfig.getEmby());
        this.baseConfig.setExternalTools(newConfig.getExternalTools());
        if (fireConfigChangedEvent) {
            ConfigChangedEvent configChangedEvent = new ConfigChangedEvent((Object)this, oldBaseConfig, newConfig);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)configChangedEvent);
        }
    }

    public void save(boolean saveInstantly) {
        this.saveLock.lock();
        if (saveInstantly) {
            logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Saving instantly");
            this.configReaderWriter.save(this.baseConfig);
            this.toSave = null;
        } else {
            logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Delaying save");
            this.toSave = this.baseConfig;
        }
        this.saveLock.unlock();
    }

    public void load() throws IOException {
        this.replace(this.configReaderWriter.loadSavedConfig());
    }

    @PreDestroy
    public void onShutdown() {
        this.saveToSave();
        this.delayedSaveTimerTask.cancel();
    }

    private void saveToSave() {
        this.saveLock.lock();
        if (this.toSave != null) {
            logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Executing delayed save");
            this.configReaderWriter.save(this.toSave);
            this.toSave = null;
        }
        this.saveLock.unlock();
    }
}

