/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.migration;

import java.util.List;
import java.util.Map;
import org.nzbhydra.config.migration.ConfigMigration;
import org.nzbhydra.config.migration.ConfigMigrationStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMigrationStep014to015
implements ConfigMigrationStep {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMigration.class);

    public int forVersion() {
        return 14;
    }

    public Map<String, Object> migrate(Map<String, Object> toMigrate) {
        try {
            Map searching = this.getFromMap(toMigrate, "searching");
            List userAgents = (List)searching.get("userAgents");
            if (userAgents.stream().noneMatch(x -> x.toLowerCase().contains("lidarr"))) {
                userAgents.add("Lidarr");
                logger.info("Added Lidarr to known user agents");
            }
            if (userAgents.stream().noneMatch(x -> x.toLowerCase().contains("readarr"))) {
                userAgents.add("Readarr");
                logger.info("Added Readarr to known user agents");
            }
            searching.put("userAgents", userAgents);
        }
        catch (Exception e) {
            logger.error("Error while adding new entries to known user agents", (Throwable)e);
        }
        return toMigrate;
    }
}

