/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.migration;

import java.util.List;
import java.util.Map;
import org.nzbhydra.config.migration.ConfigMigrationStep;
import org.nzbhydra.config.sensitive.SensitiveDataObfuscator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMigrationStep022to023
implements ConfigMigrationStep {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMigrationStep022to023.class);

    public int forVersion() {
        return 22;
    }

    public Map<String, Object> migrate(Map<String, Object> toMigrate) {
        Map auth;
        Map emby;
        List toolsList;
        Map externalTools;
        Map notificationConfig;
        List downloaders;
        Map downloading;
        List indexers;
        logger.info("Migrating config to encrypt sensitive data fields");
        int encryptedCount = 0;
        Map main = (Map)toMigrate.get("main");
        if (main != null) {
            encryptedCount += this.migrateField(main, "apiKey", "Main API key");
            encryptedCount += this.migrateField(main, "proxyUsername", "Proxy username");
            encryptedCount += this.migrateField(main, "proxyPassword", "Proxy password");
            encryptedCount += this.migrateField(main, "sslKeyStorePassword", "SSL keystore password");
            encryptedCount += this.migrateField(main, "dereferer", "Dereferer");
        }
        if ((indexers = (List)toMigrate.get("indexers")) != null) {
            for (Map indexer : indexers) {
                String name = (String)indexer.get("name");
                encryptedCount += this.migrateField(indexer, "apiKey", "Indexer " + (String)name + " API key");
                encryptedCount += this.migrateField(indexer, "username", "Indexer " + (String)name + " username");
                encryptedCount += this.migrateField(indexer, "password", "Indexer " + (String)name + " password");
            }
        }
        if ((downloading = (Map)toMigrate.get("downloading")) != null && (downloaders = (List)downloading.get("downloaders")) != null) {
            for (Object downloader : downloaders) {
                String name = (String)downloader.get("name");
                encryptedCount += this.migrateField((Map)downloader, "apiKey", "Downloader " + name + " API key");
                encryptedCount += this.migrateField((Map)downloader, "username", "Downloader " + name + " username");
                encryptedCount += this.migrateField((Map)downloader, "password", "Downloader " + name + " password");
            }
        }
        if ((notificationConfig = (Map)toMigrate.get("notificationConfig")) != null) {
            encryptedCount += this.migrateField(notificationConfig, "appriseApiUrl", "Apprise API URL");
            encryptedCount += this.migrateField(notificationConfig, "appriseUrls", "Apprise URLs");
            List entries = (List)notificationConfig.get("entries");
            if (entries != null) {
                for (Object entry : entries) {
                    String eventType = (String)entry.get("eventType");
                    encryptedCount += this.migrateField((Map)entry, "messageBody", "Notification " + eventType + " message body");
                }
            }
        }
        if ((externalTools = (Map)toMigrate.get("externalTools")) != null && (toolsList = (List)externalTools.get("externalTools")) != null) {
            for (Map tool : toolsList) {
                String name = (String)tool.get("name");
                encryptedCount += this.migrateField(tool, "apiKey", "External tool " + name + " API key");
            }
        }
        if ((emby = (Map)toMigrate.get("emby")) != null) {
            encryptedCount += this.migrateField(emby, "embyApiKey", "Emby API key");
        }
        if ((auth = (Map)toMigrate.get("auth")) != null) {
            encryptedCount += this.migrateField(auth, "rememberMeKey", "Remember-me key");
        }
        main.put("configVersion", 23);
        logger.info("Successfully encrypted {} sensitive data fields", (Object)encryptedCount);
        return toMigrate;
    }

    private int migrateField(Map<String, Object> config, String fieldName, String description) {
        String stringValue;
        Object value = config.get(fieldName);
        if (value instanceof String && SensitiveDataObfuscator.needsEncryption((String)(stringValue = (String)value))) {
            String encrypted = SensitiveDataObfuscator.encrypt((String)stringValue);
            config.put(fieldName, encrypted);
            logger.debug("Encrypted {}", (Object)description);
            return 1;
        }
        return 0;
    }
}

