/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.safeconfig;

import java.util.List;
import lombok.Generated;
import org.nzbhydra.config.SearchingConfig;

public class SafeSearchingConfig {
    private final boolean ignoreTemporarilyDisabled;
    private final Integer coverSize;
    private final Integer maxAge;
    private final boolean showQuickFilterButtons;
    private final boolean alwaysShowQuickFilterButtons;
    private final List<String> customQuickFilterButtons;
    private final List<String> preselectQuickFilterButtons;
    private final int loadLimitInternal;
    private final boolean showQualityIndicator;

    public SafeSearchingConfig(SearchingConfig searchingConfig) {
        this.coverSize = searchingConfig.getCoverSize();
        this.showQuickFilterButtons = searchingConfig.isShowQuickFilterButtons();
        this.alwaysShowQuickFilterButtons = searchingConfig.isAlwaysShowQuickFilterButtons();
        this.customQuickFilterButtons = searchingConfig.getCustomQuickFilterButtons();
        this.preselectQuickFilterButtons = searchingConfig.getPreselectQuickFilterButtons();
        this.maxAge = searchingConfig.getMaxAge().orElse(null);
        this.ignoreTemporarilyDisabled = searchingConfig.isIgnoreTemporarilyDisabled();
        this.loadLimitInternal = searchingConfig.getLoadLimitInternal();
        this.showQualityIndicator = searchingConfig.isShowMovieQualityIndicator();
    }

    @Generated
    public boolean isIgnoreTemporarilyDisabled() {
        return this.ignoreTemporarilyDisabled;
    }

    @Generated
    public Integer getCoverSize() {
        return this.coverSize;
    }

    @Generated
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @Generated
    public boolean isShowQuickFilterButtons() {
        return this.showQuickFilterButtons;
    }

    @Generated
    public boolean isAlwaysShowQuickFilterButtons() {
        return this.alwaysShowQuickFilterButtons;
    }

    @Generated
    public List<String> getCustomQuickFilterButtons() {
        return this.customQuickFilterButtons;
    }

    @Generated
    public List<String> getPreselectQuickFilterButtons() {
        return this.preselectQuickFilterButtons;
    }

    @Generated
    public int getLoadLimitInternal() {
        return this.loadLimitInternal;
    }

    @Generated
    public boolean isShowQualityIndicator() {
        return this.showQualityIndicator;
    }
}

