/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.sensitive;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveDataObfuscator {
    private static final Logger logger = LoggerFactory.getLogger(SensitiveDataObfuscator.class);
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String KEY_ALGORITHM = "AES";
    private static final String ENCRYPTED_PREFIX = "{OBF}";
    private static final String MASTER_KEY = "NZBHydra2-Obfuscation-Key-2024!";
    private static final byte[] IV = "NZBHydra2IV12345".getBytes(StandardCharsets.UTF_8);
    private static SecretKeySpec secretKey;

    public static String encrypt(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (value.startsWith(ENCRYPTED_PREFIX)) {
            return value;
        }
        if (value.startsWith("{bcrypt}") || value.startsWith("{noop}") || value.startsWith("{NOOP}")) {
            return value;
        }
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(IV);
            cipher.init(1, (Key)secretKey, ivSpec);
            byte[] encrypted = cipher.doFinal(value.getBytes(StandardCharsets.UTF_8));
            String encoded = Base64.getEncoder().encodeToString(encrypted);
            return ENCRYPTED_PREFIX + encoded;
        }
        catch (Exception e) {
            logger.error("Failed to encrypt sensitive data", (Throwable)e);
            return value;
        }
    }

    public static String decrypt(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (!value.startsWith(ENCRYPTED_PREFIX)) {
            return value;
        }
        try {
            String encrypted = value.substring(ENCRYPTED_PREFIX.length());
            byte[] decodedBytes = Base64.getDecoder().decode(encrypted);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(IV);
            cipher.init(2, (Key)secretKey, ivSpec);
            byte[] decrypted = cipher.doFinal(decodedBytes);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error("Failed to decrypt sensitive data", (Throwable)e);
            return value;
        }
    }

    public static boolean isEncrypted(String value) {
        return value != null && value.startsWith(ENCRYPTED_PREFIX);
    }

    public static boolean needsEncryption(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        if (value.startsWith(ENCRYPTED_PREFIX)) {
            return false;
        }
        return !value.startsWith("{bcrypt}") && !value.startsWith("{noop}") && !value.startsWith("{NOOP}");
    }

    static {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            byte[] key = sha.digest(MASTER_KEY.getBytes(StandardCharsets.UTF_8));
            key = Arrays.copyOf(key, 16);
            secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
        }
        catch (Exception e) {
            logger.error("Failed to initialize encryption key", (Throwable)e);
        }
    }
}

