/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import com.google.common.base.Joiner;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.SearchSourceRestriction;
import org.nzbhydra.config.category.CategoriesConfig;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidationTools;
import org.nzbhydra.config.validation.ConfigValidator;
import org.nzbhydra.searching.CategoryProvider;
import org.springframework.stereotype.Component;

@Component
public class CategoriesConfigValidator
implements ConfigValidator<CategoriesConfig> {
    public boolean doesValidate(Class<?> clazz) {
        return clazz == CategoriesConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, CategoriesConfig newConfig) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        ArrayList<CallSite> warnings = new ArrayList<CallSite>();
        for (Category category : newConfig.getCategories()) {
            if (category.getNewznabCategories() == null || category.getNewznabCategories().isEmpty()) {
                errors.add((CallSite)((Object)("Category \"" + category.getName() + "\" does not have any newznab categories configured")));
            } else {
                boolean nonBaseNewznabCategoryDefined;
                Optional<Integer> baseNewznabCategory = category.getNewznabCategories().stream().flatMap(Collection::stream).filter(x -> x % 1000 == 0).findFirst();
                if (baseNewznabCategory.isPresent() && (nonBaseNewznabCategoryDefined = category.getNewznabCategories().stream().flatMap(Collection::stream).anyMatch(x -> !x.equals(baseNewznabCategory.get()) && CategoryProvider.checkCategoryMatchingMainCategory((int)x, (int)((Integer)baseNewznabCategory.get()))))) {
                    warnings.add((CallSite)((Object)("Category " + category.getName() + " uses the main category \"" + String.valueOf(baseNewznabCategory.get()) + "\". It does not make sense to configure sublevel categories already contained by their parent category.")));
                }
            }
            if (category.getRequiredRegex().isPresent()) {
                ConfigValidationTools.checkRegex(errors, (String)((String)category.getRequiredRegex().get()), (String)("Category \"" + category.getName() + "\" uses an invalid required regex"));
            }
            if (category.getForbiddenRegex().isPresent()) {
                ConfigValidationTools.checkRegex(errors, (String)((String)category.getForbiddenRegex().get()), (String)("Category \"" + category.getName() + "\" uses an invalid forbidden regex"));
            }
            if (category.getApplyRestrictionsType() != SearchSourceRestriction.NONE) continue;
            if (!category.getRequiredWords().isEmpty() || !category.getForbiddenWords().isEmpty()) {
                warnings.add((CallSite)((Object)("You selected not to apply any word restrictions on category \"" + category.getName() + "\" but supplied forbidden or required words")));
            }
            if (!category.getRequiredRegex().isPresent() && !category.getForbiddenRegex().isPresent()) continue;
            warnings.add((CallSite)((Object)("You selected not to apply any word restrictions on category \"" + category.getName() + "\" but supplied a forbidden or required regex")));
        }
        List allNewznabCategories = newConfig.getCategories().stream().flatMap(x -> x.getNewznabCategories().stream().flatMap(Collection::stream)).toList();
        List duplicateNewznabCategories = allNewznabCategories.stream().filter(x -> Collections.frequency(allNewznabCategories, 1) > 1).collect(Collectors.toList());
        if (!duplicateNewznabCategories.isEmpty()) {
            errors.add((CallSite)((Object)("The following newznab categories are assigned to multiple indexers: " + Joiner.on((String)", ").join(duplicateNewznabCategories))));
        }
        if (!"All".equals(newConfig.getDefaultCategory()) && newConfig.getCategories().stream().noneMatch(x -> x.getName().equals(newConfig.getDefaultCategory()))) {
            errors.add((CallSite)((Object)("Category \"" + newConfig.getDefaultCategory() + "\" set as default category but no such category exists")));
        }
        return new ConfigValidationResult(errors.isEmpty(), false, errors, warnings);
    }
}

