/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.downloading.DownloadingConfig;
import org.nzbhydra.config.downloading.FileDownloadAccessType;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidator;
import org.nzbhydra.config.validation.DownloaderConfigValidator;
import org.nzbhydra.downloading.DownloaderType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DownloadingConfigValidator
implements ConfigValidator<DownloadingConfig> {
    @Autowired
    private DownloaderConfigValidator downloaderConfigValidator;

    public boolean doesValidate(Class<?> clazz) {
        return clazz == DownloadingConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, DownloadingConfig newConfig) {
        File file;
        ArrayList errors = new ArrayList();
        if (newConfig.getSaveTorrentsTo().isPresent()) {
            file = new File((String)newConfig.getSaveTorrentsTo().get());
            this.validateBlackholeFolder(errors, file, (String)newConfig.getSaveTorrentsTo().get(), "Torrent");
        }
        if (newConfig.getSaveNzbsTo().isPresent()) {
            file = new File((String)newConfig.getSaveNzbsTo().get());
            this.validateBlackholeFolder(errors, file, (String)newConfig.getSaveNzbsTo().get(), "NZB");
        }
        List<ConfigValidationResult> validationResults = newConfig.getDownloaders().stream().map(downloaderConfig -> this.downloaderConfigValidator.validateConfig(oldBaseConfig, newBaseConfig, downloaderConfig)).toList();
        List downloaderErrors = validationResults.stream().map(ConfigValidationResult::getErrorMessages).flatMap(Collection::stream).toList();
        errors.addAll(downloaderErrors);
        ArrayList<String> warnings = new ArrayList<String>();
        if (DownloadingConfigValidator.isEnabledWithoutRedirect((BaseConfig)newBaseConfig, (String)"nzbs.in")) {
            warnings.add("nzbs.in forbids NZBHydra to download NZBs directly. The NZB access type \"Redirect to indexer\" will automatically be used for this indexer.");
        }
        if (DownloadingConfigValidator.isEnabledWithoutRedirect((BaseConfig)newBaseConfig, (String)"omgwtfnzbs")) {
            warnings.add("omgwftnzbs forbids NZBHydra to download NZBs directly. The NZB access type \"Redirect to indexer\" will automatically be used for this indexer.");
        }
        if (DownloadingConfigValidator.isEnabledWithoutRedirect((BaseConfig)newBaseConfig, (String)"nzbfinder")) {
            warnings.add("NZB Finder forbids NZBHydra to download NZBs directly. The NZB access type \"Redirect to indexer\" will automatically be used for this indexer.");
        }
        warnings.addAll(validationResults.stream().map(ConfigValidationResult::getWarningMessages).flatMap(Collection::stream).toList());
        return new ConfigValidationResult(errors.isEmpty(), false, errors, warnings);
    }

    private static boolean isEnabledWithoutRedirect(BaseConfig newBaseConfig, String hostContains) {
        if (newBaseConfig.getDownloading().getDownloaders().stream().anyMatch(x -> x.isEnabled() && x.getDownloaderType() != DownloaderType.TORBOX)) {
            boolean indexerEnabled = newBaseConfig.getIndexers().stream().anyMatch(x -> x.getHost().toLowerCase().contains(hostContains) && x.getState() == IndexerConfig.State.ENABLED);
            return indexerEnabled && newBaseConfig.getDownloading().getNzbAccessType() != FileDownloadAccessType.REDIRECT;
        }
        return false;
    }

    private void validateBlackholeFolder(List<String> errors, File file, String blackholeSettings, String blackholeType) {
        boolean created;
        if (!file.isAbsolute()) {
            errors.add(blackholeType + " black hole folder " + blackholeSettings + " is not absolute");
        }
        if (file.exists() && !file.isDirectory()) {
            errors.add(blackholeType + " black hole folder " + file.getAbsolutePath() + " is a file");
        }
        if (!file.exists() && !(created = file.mkdir())) {
            errors.add(blackholeType + " black hole folder " + file.getAbsolutePath() + " could not be created");
        }
    }
}

