/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import com.google.common.base.Strings;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidator;
import org.nzbhydra.searching.IndexerForSearchSelector;
import org.springframework.stereotype.Component;

@Component
public class IndexerConfigValidator
implements ConfigValidator<IndexerConfig> {
    public boolean doesValidate(Class<?> clazz) {
        return clazz == IndexerConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, IndexerConfig newConfig) {
        String newExpirationDate;
        ConfigValidationResult validationResult = new ConfigValidationResult();
        for (String schedule : newConfig.getSchedule()) {
            Matcher matcher = IndexerForSearchSelector.SCHEDULER_PATTERN.matcher(schedule);
            if (matcher.matches()) continue;
            validationResult.getErrorMessages().add("Indexer " + newConfig.getName() + " contains an invalid schedule: " + schedule);
        }
        if (newConfig.getHitLimit().isPresent() && (Integer)newConfig.getHitLimit().get() <= 0) {
            validationResult.getErrorMessages().add("Indexer " + newConfig.getName() + " has a hit limit of 0 or lower which doesn't make sense: ");
        }
        if (newConfig.getDownloadLimit().isPresent() && (Integer)newConfig.getDownloadLimit().get() <= 0) {
            validationResult.getErrorMessages().add("Indexer " + newConfig.getName() + " has a download limit of 0 or lower which doesn't make sense: ");
        }
        if ((newExpirationDate = newConfig.getVipExpirationDate()) != null && !newExpirationDate.equals("Lifetime")) {
            try {
                DateTimeFormatter.ofPattern("yyyy-MM-dd").parse(newExpirationDate);
            }
            catch (Exception e) {
                validationResult.getErrorMessages().add("Invalid expiry date for indexer " + newConfig.getName() + ". Either use 'Lifetime' or use the format `YYYY-MM-DD");
            }
        }
        newConfig.getCustomParameters().forEach(x -> {
            if (Strings.isNullOrEmpty((String)x) || StringUtils.countMatches((CharSequence)x, (char)'=') > 1) {
                validationResult.getErrorMessages().add("The custom paramater " + x + " is invalid. You must use the format name=value.");
            }
        });
        newConfig.getAttributeWhitelist().forEach(x -> {
            if (Strings.isNullOrEmpty((String)x) || StringUtils.countMatches((CharSequence)x, (char)'=') != 1) {
                validationResult.getErrorMessages().add("The attribute whitelist entry '" + x + "' is invalid. You must use the format name=value or name=value1,value2.");
            }
        });
        return validationResult;
    }

    public IndexerConfig prepareForSaving(BaseConfig oldBaseConfig, IndexerConfig newConfig) {
        if (newConfig.getState() == IndexerConfig.State.ENABLED || newConfig.getState() == IndexerConfig.State.DISABLED_USER) {
            newConfig.setDisabledUntil(null);
            newConfig.setDisabledLevel(0);
            newConfig.setLastError(null);
        }
        return newConfig;
    }
}

