/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.SearchSourceRestriction;
import org.nzbhydra.config.SearchingConfig;
import org.nzbhydra.config.searching.CustomQueryAndTitleMapping;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidationTools;
import org.nzbhydra.config.validation.ConfigValidator;
import org.nzbhydra.searching.CustomQueryAndTitleMappingHandler;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SearchingConfigValidator
implements ConfigValidator<SearchingConfig> {
    private static final Logger logger = LoggerFactory.getLogger(SearchingConfigValidator.class);

    public boolean doesValidate(Class<?> clazz) {
        return clazz == SearchingConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, SearchingConfig newConfig) {
        ArrayList<Object> errors = new ArrayList<Object>();
        ArrayList<String> warnings = new ArrayList<String>();
        ConfigValidationTools.checkRegex(errors, (String)newConfig.getRequiredRegex().orElse(null), (String)"The required regex in \"Searching\" is invalid");
        ConfigValidationTools.checkRegex(errors, (String)newConfig.getForbiddenRegex().orElse(null), (String)"The forbidden in \"Searching\" is invalid");
        if (newConfig.getApplyRestrictions() == SearchSourceRestriction.NONE) {
            if (!newConfig.getRequiredWords().isEmpty() || !newConfig.getForbiddenWords().isEmpty()) {
                warnings.add("You selected not to apply any word restrictions in \"Searching\" but supplied forbidden or required words there");
            }
            if (newConfig.getRequiredRegex().isPresent() || newConfig.getForbiddenRegex().isPresent()) {
                warnings.add("You selected not to apply any word restrictions in \"Searching\" but supplied a forbidden or required regex there");
            }
        }
        CustomQueryAndTitleMappingHandler customQueryAndTitleMappingHandler = new CustomQueryAndTitleMappingHandler(newBaseConfig);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setTitle("test title");
        searchRequest.setQuery("test query");
        for (CustomQueryAndTitleMapping customCustomQueryAndTitleMapping : newConfig.getCustomMappings()) {
            try {
                customQueryAndTitleMappingHandler.mapSearchRequest(searchRequest, Collections.singletonList(customCustomQueryAndTitleMapping));
            }
            catch (Exception e) {
                errors.add(String.format("Unable to process mapping %s:}\n%s", customCustomQueryAndTitleMapping.toString(), e.getMessage()));
            }
            if (customCustomQueryAndTitleMapping.getFrom().contains("{episode:")) {
                errors.add("The group 'episode' is not allowed in custom mapping input patterns.");
            }
            if (!customCustomQueryAndTitleMapping.getFrom().contains("{season:")) continue;
            errors.add("The group 'season' is not allowed in custom mapping input patterns.");
        }
        List<String> emptyTrailing = newConfig.getRemoveTrailing().stream().filter(Strings::isNullOrEmpty).toList();
        if (!emptyTrailing.isEmpty()) {
            errors.add("Trailing values to remove contains empty values");
        }
        for (String quickFilterButton : newConfig.getCustomQuickFilterButtons()) {
            if (quickFilterButton == null) {
                errors.add("Empty quick filter button entry");
                continue;
            }
            if (quickFilterButton.matches("[^=]+=[^=]+")) continue;
            errors.add("Quick filter button \"" + quickFilterButton + "\" does not match the format \"DisplayName=Required1,Required2\"");
        }
        return new ConfigValidationResult(errors.isEmpty(), false, errors, warnings);
    }

    public SearchingConfig prepareForSaving(BaseConfig oldBaseConfig, SearchingConfig newConfig) {
        Set customQuickfilterNames = newConfig.getCustomQuickFilterButtons().stream().map(x -> x.split("=")[0]).collect(Collectors.toSet());
        Iterator iterator = newConfig.getPreselectQuickFilterButtons().iterator();
        while (iterator.hasNext()) {
            String preselectQuickFilterButton = (String)iterator.next();
            String[] split = preselectQuickFilterButton.split("\\|");
            if (!"custom".equals(split[0]) || customQuickfilterNames.contains(split[1])) continue;
            logger.info("Custom quickfilter {} doesn't exist anymore, removing it from list of filters to preselect.", (Object)preselectQuickFilterButton);
            iterator.remove();
        }
        return newConfig;
    }
}

