/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.List;
import java.util.Map;
import org.nzbhydra.config.sensitive.HiddenInUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SensitiveDataConfigValidator {
    private static final Logger logger = LoggerFactory.getLogger(SensitiveDataConfigValidator.class);
    private static final String UNCHANGED_MARKER = "***UNCHANGED***";

    public void prepareForDisplay(Object config) {
        if (config == null) {
            return;
        }
        this.processSensitiveFields(config, true);
    }

    public void prepareForSaving(Object oldConfig, Object newConfig) {
        if (oldConfig == null || newConfig == null) {
            return;
        }
        this.processSensitiveFieldsForSaving(oldConfig, newConfig);
    }

    private void processSensitiveFields(Object obj, boolean forDisplay) {
        Class<?> clazz;
        if (obj == null) {
            return;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object item : list) {
                this.processSensitiveFields(item, forDisplay);
            }
            return;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Object value : map.values()) {
                this.processSensitiveFields(value, forDisplay);
            }
            return;
        }
        if (clazz.isPrimitive() || clazz == String.class || clazz.isEnum()) {
            return;
        }
        String className = clazz.getName();
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.sun.")) {
            return;
        }
        for (clazz = obj.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    String fieldName;
                    String value;
                    if (field.isSynthetic()) continue;
                    try {
                        field.setAccessible(true);
                    }
                    catch (InaccessibleObjectException e) {
                        continue;
                    }
                    Object fieldValue = field.get(obj);
                    if (fieldValue == null) continue;
                    if (field.getType() == String.class && forDisplay && field.isAnnotationPresent(HiddenInUI.class) && (value = (String)fieldValue) != null && !value.isEmpty()) {
                        field.set(obj, UNCHANGED_MARKER);
                        continue;
                    }
                    if (field.getType().isPrimitive() || field.getType() == String.class || (fieldName = field.getName()).equals("parent") || fieldName.equals("this$0")) continue;
                    this.processSensitiveFields(fieldValue, forDisplay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void processSensitiveFieldsForSaving(Object oldObj, Object newObj) {
        if (oldObj == null || newObj == null) {
            return;
        }
        Class<?> clazz = newObj.getClass();
        if (newObj instanceof List) {
            List newList = (List)newObj;
            if (oldObj instanceof List) {
                List oldList = (List)oldObj;
                for (int i = 0; i < newList.size(); ++i) {
                    Object newItem = newList.get(i);
                    Object oldItem = this.findCorrespondingOldItem(oldList, newItem, i);
                    if (oldItem == null) continue;
                    this.processSensitiveFieldsForSaving(oldItem, newItem);
                }
                return;
            }
        }
        if (clazz.isPrimitive() || clazz == String.class || clazz.isEnum()) {
            return;
        }
        String className = clazz.getName();
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.sun.")) {
            return;
        }
        while (clazz != null && clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    String fieldName;
                    String newValue;
                    if (field.isSynthetic()) continue;
                    try {
                        field.setAccessible(true);
                    }
                    catch (InaccessibleObjectException e) {
                        continue;
                    }
                    Object newFieldValue = field.get(newObj);
                    Object oldFieldValue = field.get(oldObj);
                    if (field.getType() == String.class && newFieldValue != null && UNCHANGED_MARKER.equals(newValue = (String)newFieldValue) && oldFieldValue != null) {
                        field.set(newObj, oldFieldValue);
                        continue;
                    }
                    if (newFieldValue == null || oldFieldValue == null || field.getType().isPrimitive() || field.getType() == String.class || (fieldName = field.getName()).equals("parent") || fieldName.equals("this$0")) continue;
                    this.processSensitiveFieldsForSaving(oldFieldValue, newFieldValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private Object findCorrespondingOldItem(List<?> oldList, Object newItem, int index) {
        if (index < oldList.size()) {
            Object oldItem = oldList.get(index);
            try {
                Field nameField = newItem.getClass().getDeclaredField("name");
                try {
                    nameField.setAccessible(true);
                }
                catch (InaccessibleObjectException e) {
                    return oldItem;
                }
                Object newName = nameField.get(newItem);
                if (newName != null) {
                    for (Object old : oldList) {
                        Object oldName = nameField.get(old);
                        if (!newName.equals(oldName)) continue;
                        return old;
                    }
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return oldItem;
        }
        return null;
    }
}

