/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.auth.UserAuthConfig;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidator;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class UserAuthConfigValidator
implements ConfigValidator<UserAuthConfig> {
    private static final String BCRYPT_PREFIX = "{bcrypt}";
    private static final String UNCHANGED_PASSWORD_MARKER = "***UNCHANGED***";
    private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    public boolean doesValidate(Class<?> clazz) {
        return clazz == UserAuthConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, UserAuthConfig newConfig) {
        return new ConfigValidationResult();
    }

    public UserAuthConfig prepareForSaving(BaseConfig oldBaseConfig, UserAuthConfig newConfig) {
        if (newConfig.getPassword() != null) {
            if (UNCHANGED_PASSWORD_MARKER.equals(newConfig.getPassword())) {
                UserAuthConfig oldUserConfig = this.findCorrespondingOldUserConfig(oldBaseConfig, newConfig);
                if (oldUserConfig != null && oldUserConfig.getPassword() != null) {
                    newConfig.setPassword(oldUserConfig.getPassword());
                }
            } else if (!newConfig.getPassword().startsWith(BCRYPT_PREFIX) && !newConfig.getPassword().startsWith("{noop}")) {
                String hashedPassword = this.passwordEncoder.encode((CharSequence)newConfig.getPassword());
                newConfig.setPassword(BCRYPT_PREFIX + hashedPassword);
            } else if (newConfig.getPassword().startsWith("{noop}")) {
                String plainPassword = newConfig.getPassword().substring("{noop}".length());
                String hashedPassword = this.passwordEncoder.encode((CharSequence)plainPassword);
                newConfig.setPassword(BCRYPT_PREFIX + hashedPassword);
            }
        }
        return newConfig;
    }

    public UserAuthConfig updateAfterLoading(UserAuthConfig newConfig) {
        if (newConfig.getPassword() != null && (newConfig.getPassword().startsWith(BCRYPT_PREFIX) || newConfig.getPassword().startsWith("{noop}"))) {
            newConfig.setPassword(UNCHANGED_PASSWORD_MARKER);
        }
        return newConfig;
    }

    private UserAuthConfig findCorrespondingOldUserConfig(BaseConfig oldBaseConfig, UserAuthConfig newConfig) {
        if (oldBaseConfig == null || oldBaseConfig.getAuth() == null || oldBaseConfig.getAuth().getUsers() == null) {
            return null;
        }
        return oldBaseConfig.getAuth().getUsers().stream().filter(user -> user.getUsername() != null && user.getUsername().equals(newConfig.getUsername())).findFirst().orElse(null);
    }
}

