/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.database;

import jakarta.annotation.PreDestroy;
import java.io.File;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class DatabaseCompactOnShutdown {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseCompactOnShutdown.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ConfigProvider configProvider;

    @PreDestroy
    public void compactOnShutdown() {
        try {
            File databaseFile = new File(NzbHydra.getDataFolder(), "database/nzbhydra.mv.db");
            log.info("Compacting database on shutdown, using up to {}ms. Size before: {}", (Object)this.configProvider.getBaseConfig().getMain().getDatabaseCompactTime(), (Object)FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)databaseFile)));
            this.jdbcTemplate.execute("SHUTDOWN COMPACT");
            log.info("H2 database compacted successfully on shutdown. File after: {}", (Object)FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)databaseFile)));
        }
        catch (Exception e) {
            log.error("Failed to compact H2 database on shutdown", (Throwable)e);
        }
    }
}

