/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.database;

import com.google.common.base.Joiner;
import com.google.common.io.FileWriteMode;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.flywaydb.core.Flyway;
import org.nzbhydra.NzbHydra;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseRecreation {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseRecreation.class);
    private static final Map<String, String> SCHEMA_VERSION_CHANGES = new LinkedHashMap();

    public static void runDatabaseScript() throws Exception {
        File databaseFile = new File(NzbHydra.getDataFolder(), "database/nzbhydra.mv.db");
        File databaseScriptFile = new File(NzbHydra.getDataFolder(), "databaseScript.sql");
        File databaseScriptFileNew = new File(NzbHydra.getDataFolder(), "databaseScriptNew.sql");
        File restoreScriptFile = new File(NzbHydra.getDataFolder(), "database/script.sql");
        String dbConnectionUrl = "jdbc:h2:file:" + databaseFile.getAbsolutePath().replace(".mv.db", "");
        Class.forName("org.h2.Driver");
        DatabaseRecreation.migrateToH2v2IfNeeded((File)databaseFile, (String)dbConnectionUrl);
        if (restoreScriptFile.exists() && !databaseScriptFile.exists()) {
            logger.info("No database file found but script.sql - restoring database");
            try (Connection connection = DriverManager.getConnection(dbConnectionUrl, "sa", "sa");){
                connection.createStatement().executeUpdate("runscript from '%s';".formatted(restoreScriptFile.getCanonicalPath().replace("\\", "/")));
                restoreScriptFile.delete();
            }
        }
    }

    private static void migrateToH2v2IfNeeded(File databaseFile, String dbConnectionUrl) throws Exception {
        if (!databaseFile.exists()) {
            logger.debug("No database file found - no recreation needed");
            return;
        }
        try {
            char[] buffer;
            try (FileReader fileReader = new FileReader(databaseFile);){
                buffer = new char[1024];
                int n = fileReader.read(buffer);
            }
            String header = new String(buffer).trim();
            if (!header.contains("format:1")) {
                if (header.contains("format:2")) {
                    logger.info("Determined existing database to be version 2. No migration needed.");
                    return;
                }
                logger.error("Unable to determine database version from header {}", (Object)header);
                throw new RuntimeException("Invalid database file header");
            }
            logger.info("Determined existing database to be version 1.4. Migration needed.");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to open database file " + String.valueOf(databaseFile), e);
        }
        boolean isUpgrade14To210 = true;
        if (isUpgrade14To210) {
            String scriptFilePath;
            File h2NewJar;
            File h2OldJar;
            String javaExecutable;
            try {
                File[] traceFiles = databaseFile.getParentFile().listFiles((FilenameFilter)new WildcardFileFilter("*.trace.db"));
                if (traceFiles != null) {
                    for (File traceFile : traceFiles) {
                        traceFile.delete();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to delete trace files", (Throwable)e);
            }
            File backupDatabaseFile = null;
            try {
                javaExecutable = DatabaseRecreation.getJavaExecutable();
                h2OldJar = DatabaseRecreation.downloadJarFile((String)"https://repo1.maven.org/maven2/com/h2database/h2/1.4.200/h2-1.4.200.jar");
                h2NewJar = DatabaseRecreation.downloadJarFile((String)"https://repo1.maven.org/maven2/com/h2database/h2/2.1.214/h2-2.1.214.jar");
            }
            catch (Exception e) {
                logger.error("Error migrating old database. Unable to download h2 jars");
                throw e;
            }
            try {
                File scriptFile = Files.createTempFile("nzbhydra", ".sql", new FileAttribute[0]).toFile();
                scriptFile.deleteOnExit();
                scriptFilePath = scriptFile.getCanonicalPath();
                logger.info("Running database migration from 1.4 to 2");
                backupDatabaseFile = new File(databaseFile.getParent(), databaseFile.getName() + ".old.bak." + System.currentTimeMillis());
                logger.info("Copying old database file {} to backup {} which will be automatically deleted after 14 days", (Object)databaseFile, (Object)backupDatabaseFile);
                Files.copy(databaseFile.toPath(), backupDatabaseFile.toPath(), new CopyOption[0]);
                String updatePasswordQuery = "alter user sa set password 'sa'";
                DatabaseRecreation.updatePassword((String)dbConnectionUrl, (String)javaExecutable, (File)h2OldJar, (String)"alter user sa set password 'sa'");
                DatabaseRecreation.runH2Command(Arrays.asList(javaExecutable, "-Xmx700M", "-cp", h2OldJar.toString(), "org.h2.tools.Script", "-url", dbConnectionUrl, "-user", "sa", "-password", "sa", "-script", scriptFilePath), (String)"Database export failed.");
            }
            catch (Exception e) {
                logger.error("Error migrating old database file to new one");
                if (backupDatabaseFile != null && backupDatabaseFile.exists() && backupDatabaseFile != null && backupDatabaseFile.exists()) {
                    backupDatabaseFile.delete();
                }
                throw e;
            }
            try {
                boolean deleted = databaseFile.delete();
                if (!deleted) {
                    throw new RuntimeException("Unable to delete old database file " + String.valueOf(databaseFile));
                }
                DatabaseRecreation.runH2Command(Arrays.asList(javaExecutable, "-Xmx700M", "-cp", h2NewJar.toString(), "org.h2.tools.RunScript", "-url", dbConnectionUrl, "-user", "sa", "-password", "sa", "-script", scriptFilePath, "-options", "FROM_1X"), (String)"Database import failed.");
                Flyway flyway = Flyway.configure().dataSource(dbConnectionUrl, "sa", "sa").baselineDescription("INITIAL").baselineVersion("1").load();
                flyway.baseline();
            }
            catch (Exception e) {
                logger.error("Error while trying to migrate database to 2.0");
                if (backupDatabaseFile != null && backupDatabaseFile.exists()) {
                    logger.info("Restoring database file {} from backup {}", (Object)databaseFile, (Object)backupDatabaseFile);
                    Files.move(backupDatabaseFile.toPath(), databaseFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static void updatePassword(String dbConnectionUrl, String javaExecutable, File h2OldJar, String updatePasswordQuery) throws IOException, InterruptedException {
        try {
            DatabaseRecreation.runH2Command(Arrays.asList(javaExecutable, "-cp", h2OldJar.toString(), "org.h2.tools.Shell", "-url", dbConnectionUrl, "-user", "sa", "-sql", NzbHydra.isOsWindows() ? "\"" + updatePasswordQuery + "\"" : updatePasswordQuery), (String)"Password update failed.");
        }
        catch (Exception e) {
            DatabaseRecreation.runH2Command(Arrays.asList(javaExecutable, "-cp", h2OldJar.toString(), "org.h2.tools.Shell", "-url", dbConnectionUrl, "-user", "sa", "-password", "sa", "-sql", NzbHydra.isOsWindows() ? "\"" + updatePasswordQuery + "\"" : updatePasswordQuery), (String)"Password update failed.");
        }
    }

    private static void runH2Command(List<String> updatePassCommand, String errorMessage) throws IOException, InterruptedException {
        logger.info("Running command: " + Joiner.on((String)" ").join(updatePassCommand));
        Process process = new ProcessBuilder(updatePassCommand).redirectErrorStream(true).inheritIO().start();
        int result = process.waitFor();
        if (result != 0) {
            throw new RuntimeException(errorMessage + ". Code: " + result);
        }
    }

    private static File downloadJarFile(String url) throws IOException {
        File jarFile;
        ClientHttpRequest request = new OkHttp3ClientHttpRequestFactory().createRequest(URI.create(url), HttpMethod.GET);
        try (ClientHttpResponse response = request.execute();){
            jarFile = Files.createTempFile("nzbhydra", ".jar", new FileAttribute[0]).toFile();
            logger.debug("Downloaded file from {} to {}. Will be deleted on exit", (Object)url, (Object)jarFile);
            jarFile.deleteOnExit();
            try (InputStream body = response.getBody();){
                com.google.common.io.Files.asByteSink((File)jarFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom(body);
            }
            if (response.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Unable to download database library. Response: " + String.valueOf(response.getStatusCode()));
            }
        }
        return jarFile;
    }

    private static String getJavaExecutable() {
        Object javaExecutable = System.getProperty("os.name").startsWith("Win") ? System.getProperties().getProperty("java.home") + File.separator + "bin" + File.separator + "java.exe" : System.getProperties().getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        if (new File((String)javaExecutable).exists()) {
            logger.debug("Determined java executable: {}", javaExecutable);
        } else {
            logger.debug("Java executable not found. Trying just java and hope it's in path");
            javaExecutable = "java";
        }
        return javaExecutable;
    }
}

