/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.debuginfos;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.Diff;
import org.nzbhydra.Jackson;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.ConfigReaderWriter;
import org.nzbhydra.config.category.CategoriesConfig;
import org.nzbhydra.debuginfos.DebugInfosProvider;
import org.nzbhydra.logging.LogAnonymizer;
import org.nzbhydra.logging.LogContentProvider;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.misc.TempFileProvider;
import org.nzbhydra.problemdetection.OutdatedWrapperDetector;
import org.nzbhydra.update.UpdateManager;
import org.nzbhydra.webaccess.HydraOkHttp3ClientHttpRequestFactory;
import org.nzbhydra.webaccess.Ssl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.management.ThreadDumpEndpoint;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DebugInfosProvider {
    private static final Logger logger = LoggerFactory.getLogger(DebugInfosProvider.class);
    private static final int LOG_METRICS_EVERY_SECONDS = 5;
    @Autowired
    private LogAnonymizer logAnonymizer;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private UpdateManager updateManager;
    @Autowired
    private LogContentProvider logContentProvider;
    @Autowired
    private HydraOkHttp3ClientHttpRequestFactory requestFactory;
    @Autowired
    private OutdatedWrapperDetector outdatedWrapperDetector;
    @Autowired
    private MetricsEndpoint metricsEndpoint;
    @Autowired
    private ThreadDumpEndpoint threadDumpEndpoint;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private OutdatedWrapperDetector wrapperDetector;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private Ssl ssl;
    @Value(value="spring.datasource.url")
    private String datasourceUrl;
    private final List<TimeAndThreadCpuUsages> timeAndThreadCpuUsagesList = new ArrayList();
    private final Map<String, Long> lastThreadCpuTimes = new HashMap();
    @Autowired
    private TempFileProvider tempFileProvider;

    @PostConstruct
    public void logMetrics() {
        try {
            if (!this.configProvider.getBaseConfig().getMain().getLogging().getMarkersToLog().contains(LoggingMarkers.PERFORMANCE.getName())) {
                return;
            }
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutorService.schedule(() -> {
                logger.debug(LoggingMarkers.PERFORMANCE, "Will log performance metrics every {} seconds", (Object)5);
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
                executor.scheduleAtFixedRate(() -> {
                    String message;
                    try {
                        String cpuMetric = "process.cpu.usage";
                        message = "Process CPU usage: " + this.formatSample("process.cpu.usage", ((MetricsEndpoint.Sample)this.metricsEndpoint.metric("process.cpu.usage", Collections.emptyList()).getMeasurements().get(0)).getValue());
                        logger.debug(LoggingMarkers.PERFORMANCE, message);
                    }
                    catch (Exception e) {
                        logger.debug(LoggingMarkers.PERFORMANCE, "Error while logging CPU usage", (Throwable)e);
                    }
                    try {
                        String memoryMetric = "jvm.memory.used";
                        message = "Process memory usage: " + this.formatSample("jvm.memory.used", ((MetricsEndpoint.Sample)this.metricsEndpoint.metric("jvm.memory.used", null).getMeasurements().get(0)).getValue());
                        logger.debug(LoggingMarkers.PERFORMANCE, message);
                    }
                    catch (Exception e) {
                        logger.debug(LoggingMarkers.PERFORMANCE, "Error while logging memory usage", (Throwable)e);
                    }
                    ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
                    ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
                }, 0L, 5L, TimeUnit.SECONDS);
                int cpuCount = ((MetricsEndpoint.Sample)this.metricsEndpoint.metric("system.cpu.count", null).getMeasurements().get(0)).getValue().intValue();
                ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
                double[] previousUptime = new double[]{this.getUpTimeInMiliseconds()};
                ScheduledExecutorService executor2 = Executors.newScheduledThreadPool(1);
                executor2.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 0L, 5L, TimeUnit.SECONDS);
            }, 5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("Error initializing performance metrics reading", (Throwable)e);
        }
    }

    public List<TimeAndThreadCpuUsages> getThreadCpuUsageChartData() {
        return this.timeAndThreadCpuUsagesList;
    }

    public static Pair<String, String> getVersionAndBuildTimestamp() {
        Properties properties = new Properties();
        try {
            properties.load(DebugInfosProvider.class.getResourceAsStream("/config/application.properties"));
        }
        catch (Exception e) {
            try {
                properties.load(DebugInfosProvider.class.getResourceAsStream("/application.properties"));
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to load application properties", ex);
            }
        }
        return Pair.of((Object)properties.getProperty("build.version"), (Object)properties.getProperty("build.timestamp"));
    }

    private double getUpTimeInMiliseconds() {
        return ((MetricsEndpoint.Sample)this.metricsEndpoint.metric("process.uptime", null).getMeasurements().get(0)).getValue() * 1000.0;
    }

    public byte[] getDebugInfosAsZip() throws IOException {
        File tempFile = this.createDebugInfosZipFile();
        byte[] bytes = Files.readAllBytes(tempFile.toPath());
        tempFile.delete();
        return bytes;
    }

    public File createDebugInfosZipFile() throws IOException {
        File tempFile;
        block20: {
            logger.info("Creating debug infos");
            logger.info("NZBHydra2 version: {}", (Object)this.updateManager.getCurrentVersionString());
            Pair pair = DebugInfosProvider.getVersionAndBuildTimestamp();
            logger.info("NZBHydra2 build: {} ({})", pair.getLeft(), pair.getRight());
            logger.info("Java command line: {}", (Object)System.getProperty("sun.java.command"));
            logger.info("Java runtime name: {}", (Object)System.getProperty("java.runtime.name"));
            logger.info("Java runtime version: {}", (Object)System.getProperty("java.runtime.version"));
            logger.info("Java vm name: {}", (Object)System.getProperty("java.vm.name"));
            logger.info("Java vendor: {}", (Object)System.getProperty("java.vendor"));
            logger.info("Source location: {}", (Object)this.getClass().getProtectionDomain().getCodeSource().getLocation());
            logger.info("OS name: {}", (Object)System.getProperty("os.name"));
            logger.info("OS architecture: {}", (Object)System.getProperty("os.arch"));
            logger.info("User country: {}", (Object)System.getProperty("user.country"));
            logger.info("File encoding: {}", (Object)System.getProperty("file.encoding"));
            logger.info("Datasource URL: {}", (Object)this.datasourceUrl);
            logger.info("Ciphers:");
            logger.info(this.ssl.getSupportedCiphers());
            this.outdatedWrapperDetector.executeCheck();
            this.logNumberOfTableRows("SEARCH");
            this.logNumberOfTableRows("SEARCHRESULT");
            this.logNumberOfTableRows("INDEXERSEARCH");
            this.logNumberOfTableRows("INDEXERAPIACCESS");
            this.logNumberOfTableRows("INDEXERAPIACCESS_SHORT");
            this.logNumberOfTableRows("INDEXERNZBDOWNLOAD");
            this.logDatabaseFolderSize();
            if (DebugInfosProvider.isRunInDocker()) {
                logger.info("Apparently run in docker");
                logger.info("Container info: {}", (Object)this.updateManager.getPackageInfo());
            } else {
                logger.info("Apparently not run in docker");
            }
            String anonymizedConfig = this.getAnonymizedConfig();
            this.logConfigChanges(anonymizedConfig);
            logger.info("Metrics:");
            Set metricsNames = this.metricsEndpoint.listNames().getNames();
            for (String metric : metricsNames) {
                MetricsEndpoint.MetricDescriptor response = this.metricsEndpoint.metric(metric, null);
                logger.info("{}: {}", (Object)metric, (Object)response.getMeasurements().stream().map(x -> x.getStatistic().name() + ": " + this.formatSample(metric, x.getValue())).collect(Collectors.joining(", ")));
            }
            String anonymizedLog = this.logAnonymizer.getAnonymizedLog(this.logContentProvider.getLog());
            tempFile = this.tempFileProvider.getTempFile("debuginfos", ".zip");
            try (FileOutputStream fos = new FileOutputStream(tempFile);
                 ZipOutputStream zos = new ZipOutputStream(fos);){
                this.writeStringToZip(zos, "nzbhydra2.log", anonymizedLog.getBytes(StandardCharsets.UTF_8));
                this.writeStringToZip(zos, "nzbhydra2-config.yaml", anonymizedConfig.getBytes(StandardCharsets.UTF_8));
                this.writeFileIfExists(zos, new File(NzbHydra.getDataFolder(), "database"), "nzbhydra.trace.db");
                File logsFolder = new File(NzbHydra.getDataFolder(), "logs");
                File[] files = logsFolder.listFiles((dir, name) -> name.startsWith("gclog"));
                if (files != null) {
                    for (File file : files) {
                        this.writeFileToZip(zos, file.getName(), file);
                    }
                }
                this.writeFileIfExists(zos, logsFolder, "wrapper.log");
                this.writeFileIfExists(zos, logsFolder, "system.err.log");
                this.writeFileIfExists(zos, logsFolder, "system.out.log");
                File servLogFile = new File(logsFolder, "nzbhydra2.serv.log");
                if (!servLogFile.exists()) break block20;
                try (FileReader reader = new FileReader(servLogFile);){
                    this.writeStringToZip(zos, "nzbhydra2.serv.log", this.logAnonymizer.getAnonymizedLog(IOUtils.toString((Reader)reader)).getBytes());
                }
            }
        }
        logger.debug("Finished creating debug infos ZIP");
        return tempFile;
    }

    private void logConfigChanges(String anonymizedConfig) throws IOException {
        ConfigReaderWriter configReaderWriter = new ConfigReaderWriter();
        BaseConfig originalConfig = configReaderWriter.originalConfig();
        originalConfig.setCategoriesConfig((CategoriesConfig)new DiffableCategoriesConfig(originalConfig.getCategoriesConfig()));
        BaseConfig userConfig = (BaseConfig)Jackson.YAML_MAPPER.readValue(anonymizedConfig, BaseConfig.class);
        userConfig.setCategoriesConfig((CategoriesConfig)new DiffableCategoriesConfig(userConfig.getCategoriesConfig()));
        try {
            Diff configDiff = JaversBuilder.javers().build().compare((Object)originalConfig, (Object)userConfig);
            logger.info("Difference in config:\n{}", (Object)configDiff.prettyPrint());
        }
        catch (Exception e) {
            logger.error("Error building config diff", (Throwable)e);
        }
    }

    public String logThreadDump() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Thread dump:\n");
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                sb.append("Thread name: ").append(entry.getKey().getName()).append("\n");
                for (StackTraceElement element : entry.getValue()) {
                    sb.append("\tat ").append(element.toString()).append("\n");
                }
                sb.append("\n");
            }
            String threadDump = sb.toString();
            logger.debug(threadDump);
            return threadDump;
        }
        catch (Exception e) {
            logger.error("Unable to create thread dump : {}", (Object)e.getMessage());
            return "Unable to create thread dump";
        }
    }

    private String formatSample(String name, Double value) {
        String suffix = "";
        if (value == 0.0) {
            return "0";
        }
        if (name.contains("memory")) {
            value = value / 1048576.0;
            suffix = "MB";
        }
        String pattern = value % 1.0 == 0.0 ? "#,###" : "#,###.00";
        if (name.contains("cpu")) {
            value = 100.0 * value;
            suffix = "%";
            pattern = "##";
        }
        return new DecimalFormat(pattern).format(value) + suffix;
    }

    private void writeFileIfExists(ZipOutputStream zos, File logsFolder, String filename) throws IOException {
        File file = new File(logsFolder, filename);
        if (file.exists()) {
            this.writeFileToZip(zos, filename, file);
        }
    }

    protected void logDatabaseFolderSize() {
        File databaseFolder = new File(NzbHydra.getDataFolder(), "database");
        if (!databaseFolder.exists()) {
            logger.warn("Database folder not found");
            return;
        }
        File[] databaseFiles = databaseFolder.listFiles();
        if (databaseFiles == null) {
            logger.warn("No database files found");
            return;
        }
        long databaseFolderSize = Stream.of(databaseFiles).mapToLong(File::length).sum();
        logger.info("Size of database folder: {}MB", (Object)(databaseFolderSize / 0x100000L));
    }

    protected void logNumberOfTableRows(String tableName) {
        try {
            logger.info("Number of rows in table {}: {}", (Object)tableName, this.entityManager.createNativeQuery("select count(*) from " + tableName).getSingleResult());
        }
        catch (Exception e) {
            logger.error("Unable to get number of rows in table {}", (Object)tableName, (Object)e);
        }
    }

    public static boolean isRunInDocker() {
        return new File("/.dockerenv").exists();
    }

    @Transactional
    public String executeSqlQuery(String sql) throws IOException {
        logger.info("Executing SQL query \"{}\" and returning as CSV", (Object)sql);
        File tempFile = this.tempFileProvider.getTempFile("dbquery", "csv");
        String path = tempFile.getAbsolutePath().replace("\\", "/");
        this.entityManager.createNativeQuery(String.format("CALL CSVWRITE('%s', '%s')", path, sql.replace("'", "''"))).executeUpdate();
        String content = new String(Files.readAllBytes(tempFile.toPath()));
        tempFile.delete();
        return content;
    }

    @Transactional
    public String executeSqlUpdate(String sql) {
        logger.info("Executing SQL query \"{}\"", (Object)sql);
        int affectedRows = this.entityManager.createNativeQuery(sql).executeUpdate();
        return String.valueOf(affectedRows);
    }

    private void writeStringToZip(ZipOutputStream zos, String name, byte[] bytes) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        zipEntry.setSize(bytes.length);
        zos.putNextEntry(zipEntry);
        zos.write(bytes);
        zos.closeEntry();
    }

    private void writeFileToZip(ZipOutputStream zos, String name, File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        this.writeStringToZip(zos, name, bytes);
    }

    private String getAnonymizedConfig() throws JsonProcessingException {
        return Jackson.SENSITIVE_YAML_MAPPER.writeValueAsString((Object)this.configProvider.getBaseConfig());
    }
}

