/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading;

import com.google.common.base.Stopwatch;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.downloading.FileDownloadEvent;
import org.nzbhydra.downloading.FileDownloadRepository;
import org.nzbhydra.downloading.FileDownloadStatus;
import org.nzbhydra.downloading.downloaders.Downloader;
import org.nzbhydra.downloading.downloaders.DownloaderProvider;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.tasks.HydraTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DownloadStatusUpdater {
    private static final long HOUR_SECONDS = 3600L;
    private static final long DAY_SECONDS = 86400L;
    private static final long TEN_SECONDS_MS = 10000L;
    private static final long TEN_MINUTES_MS = 600000L;
    private static final int MIN_SECONDS_SINCE_LAST_DOWNLOAD_TO_CHECK_STATUSES = 21600;
    protected Instant lastDownload = Instant.now();
    protected boolean queueCheckEnabled = true;
    protected boolean historyCheckEnabled = true;
    protected static final Logger logger = LoggerFactory.getLogger(DownloadStatusUpdater.class);
    @Autowired
    protected DownloaderProvider downloaderProvider;
    @Autowired
    protected FileDownloadRepository downloadRepository;
    @Autowired
    private ConfigProvider configProvider;

    @HydraTask(configId="downloadHistoryCheck", name="Download history check", interval=600000L)
    @Transactional
    public void checkHistoryStatus() {
        logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Running download history  check");
        if (!this.configProvider.getBaseConfig().getDownloading().isUpdateStatuses()) {
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Skipping history status update because it's disabled");
            return;
        }
        if (!this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Skipping history status update because no history is kept");
            return;
        }
        List<FileDownloadStatus> statusesToCheck = Arrays.asList(FileDownloadStatus.REQUESTED, FileDownloadStatus.NZB_ADDED, FileDownloadStatus.NZB_DOWNLOAD_SUCCESSFUL);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.checkStatus(statusesToCheck, 86400L, Downloader.StatusCheckType.HISTORY);
        }
        finally {
            logger.debug(LoggingMarkers.PERFORMANCE, "Check of history took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @HydraTask(configId="downloadQueueCheck", name="Download queue check", interval=10000L)
    @Transactional
    public void checkQueueStatus() {
        logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Running download queue check");
        if (!this.configProvider.getBaseConfig().getDownloading().isUpdateStatuses()) {
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Skipping queue status update because it's disabled");
            return;
        }
        if (!this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Skipping history status update because no history is kept");
            return;
        }
        List<FileDownloadStatus> statusesToCheck = Arrays.asList(FileDownloadStatus.REQUESTED);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.checkStatus(statusesToCheck, 3600L, Downloader.StatusCheckType.QUEUE);
        }
        finally {
            logger.debug(LoggingMarkers.PERFORMANCE, "Check of download queue took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @EventListener
    public void onNzbDownloadEvent(FileDownloadEvent downloadEvent) {
        if (!this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
            return;
        }
        this.lastDownload = Instant.now();
        this.queueCheckEnabled = true;
        this.historyCheckEnabled = true;
        logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Received download event. Will enable status updates for the next {} minutes", (Object)360);
    }

    protected void checkStatus(List<FileDownloadStatus> nzbDownloadStatuses, long maxAgeDownloadEntitiesInSeconds, Downloader.StatusCheckType statusCheckType) {
        if (!this.queueCheckEnabled && statusCheckType == Downloader.StatusCheckType.QUEUE || !this.historyCheckEnabled && statusCheckType == Downloader.StatusCheckType.HISTORY) {
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Not executing {} status update because it's disabled", (Object)statusCheckType);
            return;
        }
        if (this.lastDownload.isBefore(Instant.now().minusSeconds(21600L))) {
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Not executing {} status update because last download was {}", (Object)statusCheckType, (Object)this.lastDownload);
            return;
        }
        List downloadsWaitingForUpdate = this.downloadRepository.findByStatusInAndTimeAfterOrderByTimeDesc(nzbDownloadStatuses, Instant.now().minusSeconds(maxAgeDownloadEntitiesInSeconds));
        if (downloadsWaitingForUpdate.isEmpty()) {
            if (statusCheckType == Downloader.StatusCheckType.QUEUE) {
                this.queueCheckEnabled = false;
            } else {
                this.historyCheckEnabled = false;
            }
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Returning and setting {} status update disabled because no current downloads are waiting for updates", (Object)statusCheckType);
            return;
        }
        ArrayList updatedDownloads = new ArrayList();
        logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "{} downloads waiting for {} update", (Object)downloadsWaitingForUpdate.size(), (Object)statusCheckType);
        for (Downloader downloader : this.downloaderProvider.getAllDownloaders()) {
            if (!downloader.isEnabled()) continue;
            updatedDownloads.addAll(downloader.checkForStatusUpdates(downloadsWaitingForUpdate, statusCheckType));
        }
        this.downloadRepository.saveAll(updatedDownloads);
    }

    static {
        logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Will not check for download statuses if last download was more than {} minutes ago", (Object)360);
    }
}

