/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.downloading.FileDownloadAccessType;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.downloading.DownloadException;
import org.nzbhydra.downloading.DownloadResult;
import org.nzbhydra.downloading.FileDownloadEntity;
import org.nzbhydra.downloading.FileDownloadEvent;
import org.nzbhydra.downloading.FileDownloadRepository;
import org.nzbhydra.downloading.FileDownloadStatus;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.FileZipResponse;
import org.nzbhydra.downloading.IndexerSpecificDownloadExceptions;
import org.nzbhydra.downloading.InvalidSearchResultIdException;
import org.nzbhydra.downloading.MagnetLinkRedirectException;
import org.nzbhydra.downloading.SaveOrSendResultsResponse;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessEntityShort;
import org.nzbhydra.indexers.IndexerApiAccessEntityShortRepository;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.misc.TempFileProvider;
import org.nzbhydra.notifications.DownloadNotificationEvent;
import org.nzbhydra.searching.SearchModuleProvider;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.nzbhydra.web.UrlCalculator;
import org.nzbhydra.webaccess.HydraOkHttp3ClientHttpRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class FileHandler {
    private static final Logger logger = LoggerFactory.getLogger(FileHandler.class);
    @Autowired
    protected ConfigProvider configProvider;
    @Autowired
    protected SearchResultRepository searchResultRepository;
    @Autowired
    protected FileDownloadRepository downloadRepository;
    @Autowired
    private IndexerApiAccessEntityShortRepository shortRepository;
    @Autowired
    protected SearchModuleProvider searchModuleProvider;
    @Autowired
    protected HydraOkHttp3ClientHttpRequestFactory clientHttpRequestFactory;
    @Autowired
    protected ApplicationEventPublisher eventPublisher;
    @Autowired
    protected UrlCalculator urlCalculator;
    @Autowired
    private IndexerSpecificDownloadExceptions indexerSpecificDownloadExceptions;
    private final Set<File> temporaryZipFiles = new HashSet();
    @Autowired
    private TempFileProvider tempFileProvider;

    public DownloadResult getFileByGuid(long guid, SearchSource accessSource) throws InvalidSearchResultIdException {
        SearchResultEntity searchResult = this.getResultFromGuid(guid, accessSource);
        IndexerConfig indexerConfig = this.configProvider.getIndexerByName(searchResult.getIndexer().getName());
        FileDownloadAccessType fileDownloadAccessType = this.indexerSpecificDownloadExceptions.getAccessTypeForIndexer(indexerConfig, this.configProvider.getBaseConfig().getDownloading().getNzbAccessType(), searchResult);
        return this.getFileByResult(fileDownloadAccessType, accessSource, searchResult);
    }

    @Transactional
    public DownloadResult getFileByGuid(long guid, FileDownloadAccessType fileDownloadAccessType, SearchSource accessSource) throws InvalidSearchResultIdException {
        SearchResultEntity result = this.getResultFromGuid(guid, accessSource);
        String downloadType = result.getDownloadType() == DownloadType.NZB ? "NZB" : "Torrent";
        logger.info("{} download request for \"{}\" from indexer {}", new Object[]{downloadType, result.getTitle(), result.getIndexer().getName()});
        return this.getFileByResult(fileDownloadAccessType, accessSource, result, new HashSet());
    }

    @NotNull
    private SearchResultEntity getResultFromGuid(long guid, SearchSource accessSource) throws InvalidSearchResultIdException {
        Optional optionalResult = this.searchResultRepository.findById((Object)guid);
        if (optionalResult.isEmpty()) {
            logger.error("Download request with invalid/outdated GUID {}", (Object)guid);
            throw new InvalidSearchResultIdException(guid, accessSource == SearchSource.INTERNAL);
        }
        return (SearchResultEntity)optionalResult.get();
    }

    @Transactional
    public DownloadResult getFileByResult(FileDownloadAccessType fileDownloadAccessType, SearchSource accessSource, SearchResultEntity result) {
        fileDownloadAccessType = this.indexerSpecificDownloadExceptions.getAccessTypeForIndexer(this.configProvider.getIndexerByName(result.getIndexer().getName()), fileDownloadAccessType, result);
        return this.getFileByResult(fileDownloadAccessType, accessSource, result, new HashSet());
    }

    private DownloadResult getFileByResult(FileDownloadAccessType fileDownloadAccessType, SearchSource accessSource, SearchResultEntity result, Set<SearchResultEntity> alreadyTriedDownloading) {
        logger.info("{} download request for \"{}\" from indexer {}", new Object[]{fileDownloadAccessType, result.getTitle(), result.getIndexer().getName()});
        if (fileDownloadAccessType == FileDownloadAccessType.REDIRECT) {
            return this.handleRedirect(accessSource, result, null);
        }
        try {
            DownloadResult downloadResult = this.handleContentDownload(accessSource, result);
            if (downloadResult.isSuccessful()) {
                return downloadResult;
            }
            if (!accessSource.meets(this.configProvider.getBaseConfig().getDownloading().getFallbackForFailed())) {
                return downloadResult;
            }
            alreadyTriedDownloading.add(result);
            Set similarResults = this.searchResultRepository.findAllByTitleLikeIgnoreCase(result.getTitle().replaceAll("[ .\\-_]", "_"));
            Optional<SearchResultEntity> similarResult = similarResults.stream().filter(x -> x != result && !alreadyTriedDownloading.contains(x)).findFirst();
            if (similarResult.isPresent()) {
                logger.info("Falling back from failed download to similar result {}", (Object)similarResult.get());
                return this.getFileByResult(fileDownloadAccessType, accessSource, similarResult.get(), alreadyTriedDownloading);
            }
            logger.info("Unable to find similar result to fall back to. Returning download failure.");
            return downloadResult;
        }
        catch (MagnetLinkRedirectException e) {
            logger.warn("Unable to download magnet link as file");
            return DownloadResult.createErrorResult((String)"Unable to download magnet link as file");
        }
    }

    @Transactional
    public DownloadResult handleContentDownload(SearchSource accessSource, SearchResultEntity result) throws MagnetLinkRedirectException {
        byte[] fileContent;
        if (result.getLink().contains("magnet:")) {
            logger.warn("Unable to download magnet link as file");
            return DownloadResult.createErrorResult((String)"Unable to download magnet link as file");
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            fileContent = this.downloadFile(result);
        }
        catch (DownloadException e) {
            logger.error("Error while downloading NZB from URL {}: Status code: {}. Message: {}", new Object[]{result.getLink(), e.getStatus(), e.getMessage()});
            FileDownloadEntity downloadEntity = new FileDownloadEntity(result, FileDownloadAccessType.PROXY, accessSource, FileDownloadStatus.NZB_DOWNLOAD_ERROR, e.getMessage());
            if (this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
                this.downloadRepository.save((Object)downloadEntity);
            }
            this.shortRepository.save((Object)new IndexerApiAccessEntityShort(result.getIndexer(), false, IndexerApiAccessType.NZB));
            this.publishEvents(result, downloadEntity);
            return DownloadResult.createErrorResult((String)("An error occurred while downloading " + result.getTitle() + " from indexer " + result.getIndexer().getName()), (HttpStatus)HttpStatus.valueOf((int)e.getStatus()), (FileDownloadEntity)downloadEntity);
        }
        long responseTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        logger.info("{} download from indexer successfully completed in {}ms", (Object)(result.getDownloadType() == DownloadType.NZB ? "NZB" : "Torrent"), (Object)responseTime);
        FileDownloadEntity downloadEntity = new FileDownloadEntity(result, FileDownloadAccessType.PROXY, accessSource, FileDownloadStatus.NZB_DOWNLOAD_SUCCESSFUL, null);
        if (this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
            this.downloadRepository.save((Object)downloadEntity);
        }
        this.shortRepository.save((Object)new IndexerApiAccessEntityShort(result.getIndexer(), true, IndexerApiAccessType.NZB));
        this.publishEvents(result, downloadEntity);
        return DownloadResult.createSuccessfulDownloadResult((String)result.getTitle(), (byte[])fileContent, (FileDownloadEntity)downloadEntity);
    }

    @Transactional
    public DownloadResult handleRedirect(SearchSource accessSource, SearchResultEntity result, String actualUrl) {
        logger.debug("Redirecting to {}", (Object)result.getLink());
        FileDownloadEntity downloadEntity = new FileDownloadEntity(result, FileDownloadAccessType.REDIRECT, accessSource, FileDownloadStatus.REQUESTED, null);
        if (this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
            this.downloadRepository.save((Object)downloadEntity);
        }
        this.shortRepository.save((Object)new IndexerApiAccessEntityShort(result.getIndexer(), true, IndexerApiAccessType.NZB));
        this.publishEvents(result, downloadEntity);
        return DownloadResult.createSuccessfulRedirectResult((String)result.getTitle(), (String)(actualUrl != null ? actualUrl : result.getLink()), (FileDownloadEntity)downloadEntity);
    }

    private void publishEvents(SearchResultEntity result, FileDownloadEntity downloadEntity) {
        try {
            this.eventPublisher.publishEvent((Object)new FileDownloadEvent(downloadEntity, result));
            String age = result.getDownloadType() == DownloadType.NZB ? String.valueOf((int)(Duration.between(result.getPubDate(), Instant.now()).get(ChronoUnit.SECONDS) / 86400L)) : "[]";
            String source = result.getDownloadType() == DownloadType.NZB ? "NZB" : "torrent";
            this.eventPublisher.publishEvent((Object)new DownloadNotificationEvent(result.getIndexer().getName(), result.getTitle(), age, source));
        }
        catch (Exception e) {
            logger.error("Error publishing event", (Throwable)e);
        }
    }

    public FileZipResponse getFilesAsZip(List<Long> guids) throws Exception {
        Path tempDirectory;
        try {
            tempDirectory = Files.createTempDirectory("nzbhydra", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        NzbsDownload nzbsDownload = this.getNzbsAsFiles(guids, tempDirectory);
        if (nzbsDownload.files.isEmpty()) {
            return new FileZipResponse(false, null, "No files could be retrieved", Collections.emptyList(), guids);
        }
        File zip = this.createZip(nzbsDownload.files);
        zip.deleteOnExit();
        logger.info("Successfully added {}/{} files to ZIP", (Object)nzbsDownload.files.size(), (Object)guids.size());
        if (nzbsDownload.tempDirectory != null) {
            nzbsDownload.tempDirectory.toFile().delete();
        }
        String message = nzbsDownload.failedIds.isEmpty() ? "All files successfully retrieved" : nzbsDownload.failedIds.size() + " files could not be loaded";
        return new FileZipResponse(true, zip.getAbsolutePath(), message, (Collection)nzbsDownload.successfulIds, (Collection)nzbsDownload.failedIds);
    }

    private NzbsDownload getNzbsAsFiles(Collection<Long> guids, Path targetDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<Long> successfulIds = new ArrayList<Long>();
        ArrayList<Long> failedIds = new ArrayList<Long>();
        for (Long guid : guids) {
            DownloadResult result;
            block8: {
                try {
                    SearchResultEntity searchResult = this.getResultFromGuid(guid.longValue(), SearchSource.INTERNAL);
                    IndexerConfig indexerConfig = this.configProvider.getIndexerByName(searchResult.getIndexer().getName());
                    FileDownloadAccessType accessType = this.indexerSpecificDownloadExceptions.getAccessTypeForIndexer(indexerConfig, FileDownloadAccessType.PROXY, searchResult);
                    if (accessType == FileDownloadAccessType.PROXY) {
                        result = this.getFileByGuid(guid.longValue(), FileDownloadAccessType.PROXY, SearchSource.INTERNAL);
                        break block8;
                    }
                    logger.info("Can't download NZB from indexer {} because it forbids direct access from NZBHydra", (Object)indexerConfig.getName());
                    failedIds.add(guid);
                }
                catch (InvalidSearchResultIdException e) {
                    failedIds.add(guid);
                }
                continue;
            }
            if (!result.isSuccessful()) {
                failedIds.add(guid);
                continue;
            }
            try {
                String title = result.getFileName().replaceAll("[\\\\/:*?\"<>|!]", "_");
                File tempFile = new File(targetDirectory.toFile(), title);
                int counter = 1;
                while (tempFile.exists()) {
                    String newName = FilenameUtils.getBaseName((String)title) + "_" + counter + "." + FilenameUtils.getExtension((String)title);
                    tempFile = new File(targetDirectory.toFile(), newName);
                    ++counter;
                }
                logger.debug("Writing content to temp file {}", (Object)tempFile.getAbsolutePath());
                Files.write(tempFile.toPath(), result.getContent(), new OpenOption[0]);
                files.add(tempFile);
                successfulIds.add(guid);
            }
            catch (IOException e) {
                logger.error("Unable to write file content to temporary file: {}", (Object)e.getMessage());
                failedIds.add(guid);
            }
        }
        return new NzbsDownload(files, successfulIds, failedIds, targetDirectory);
    }

    public File createZip(List<File> nzbFiles) throws Exception {
        logger.info("Creating ZIP with files");
        File tempFile = this.tempFileProvider.getTempFile("nzbs", ".zip");
        this.temporaryZipFiles.add(tempFile);
        tempFile.deleteOnExit();
        logger.debug("Using temp file {}", (Object)tempFile.getAbsolutePath());
        FileOutputStream fos = new FileOutputStream(tempFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (File file : nzbFiles) {
            FileHandler.addToZipFile((File)file, (ZipOutputStream)zos);
            file.delete();
        }
        zos.close();
        fos.close();
        return tempFile;
    }

    private static void addToZipFile(File file, ZipOutputStream zos) throws IOException {
        int length;
        logger.debug("Adding file {} to temporary ZIP file", (Object)file.getAbsolutePath());
        FileInputStream fis = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(file.getName());
        zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeEntry();
        fis.close();
    }

    public NfoResult getNfo(Long searchResultId) {
        Optional optionalResult = this.searchResultRepository.findById((Object)searchResultId);
        if (optionalResult.isEmpty()) {
            logger.error("Download request with invalid/outdated search result ID {}", (Object)searchResultId);
            throw new RuntimeException("Download request with invalid/outdated search result ID " + searchResultId);
        }
        SearchResultEntity result = (SearchResultEntity)optionalResult.get();
        Indexer indexer = this.searchModuleProvider.getIndexerByName(result.getIndexer().getName());
        return indexer.getNfo(result.getIndexerGuid());
    }

    public void updateStatusByEntity(FileDownloadEntity entity, FileDownloadStatus status) {
        FileDownloadStatus oldStatus = entity.getStatus();
        entity.setStatus(status);
        this.downloadRepository.save((Object)entity);
        logger.info("Updated download status of \"{}\" from {} to {}", new Object[]{entity.getSearchResult().getTitle(), oldStatus, status});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] downloadFile(SearchResultEntity result) throws MagnetLinkRedirectException, DownloadException {
        Indexer indexerByName = this.searchModuleProvider.getIndexerByName(result.getIndexer().getName());
        IndexerConfig indexerConfig = indexerByName.getConfig();
        Integer timeout = indexerConfig.getTimeout().orElse(this.configProvider.getBaseConfig().getSearching().getTimeout());
        Request.Builder requestBuilder = new Request.Builder().url(result.getLink());
        indexerConfig.getUserAgent().or(() -> this.configProvider.getBaseConfig().getSearching().getUserAgent()).ifPresent(s -> requestBuilder.header("User-Agent", s));
        Request request = requestBuilder.build();
        OkHttpClient client = this.clientHttpRequestFactory.getOkHttpClient(request.url().uri().getHost(), timeout);
        try (Response response = client.newCall(request).execute();){
            if (response.isRedirect()) {
                byte[] byArray2 = this.handleRedirect(result, response);
                return byArray2;
            }
            if (!response.isSuccessful()) {
                throw new DownloadException(result.getLink(), response.code(), response.message());
            }
            ResponseBody body = response.body();
            if (body == null) {
                throw new DownloadException(result.getLink(), 500, "NZB downloaded is empty");
            }
            byte[] byArray = body.bytes();
            return byArray;
        }
        catch (IOException e) {
            logger.error("Error downloading result", (Throwable)e);
            throw new DownloadException(result.getLink(), 500, "IOException: " + e.getMessage());
        }
    }

    private byte[] handleRedirect(SearchResultEntity result, Response response) throws MagnetLinkRedirectException, DownloadException {
        String locationHeader = response.header("location");
        if (locationHeader != null) {
            if (locationHeader.startsWith("magnet:")) {
                throw new MagnetLinkRedirectException(locationHeader);
            }
            logger.info("Redirecting to URL {}", (Object)locationHeader);
            result.setLink(locationHeader);
            return this.downloadFile(result);
        }
        logger.error("Unable to handle redirect from URL {} because no redirection location is set", (Object)result.getLink());
        throw new DownloadException(result.getLink(), 500, "Unable to handle redirect from URL " + result.getLink() + " because no redirection location is set");
    }

    public SaveOrSendResultsResponse saveNzbToBlackhole(Set<Long> searchResultIds) {
        if (this.configProvider.getBaseConfig().getDownloading().getSaveNzbsTo().isEmpty()) {
            return SaveOrSendResultsResponse.notOk((String)"Black hole folder not set", searchResultIds);
        }
        NzbsDownload nzbsAsFiles = this.getNzbsAsFiles((Collection)Sets.newHashSet(searchResultIds), Paths.get((String)this.configProvider.getBaseConfig().getDownloading().getSaveNzbsTo().get(), new String[0]));
        if (nzbsAsFiles.successfulIds.isEmpty()) {
            return SaveOrSendResultsResponse.notOk((String)"Unable to save file for download NZB for some reason", searchResultIds);
        }
        return new SaveOrSendResultsResponse(true, null, (Collection)nzbsAsFiles.successfulIds, (Collection)nzbsAsFiles.failedIds);
    }

    public Set<File> getTemporaryZipFiles() {
        return this.temporaryZipFiles;
    }
}

