/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.downloading.FileDownloadEvent;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.indexers.IndexerSearchEntity;
import org.nzbhydra.indexers.IndexerSearchRepository;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.nzbhydra.searching.uniqueness.IndexerUniquenessScoreEntity;
import org.nzbhydra.searching.uniqueness.IndexerUniquenessScoreEntityRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class IndexerUniquenessScoreSaver {
    protected static final Logger logger = LoggerFactory.getLogger(IndexerUniquenessScoreSaver.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private SearchResultRepository searchResultRepository;
    @Autowired
    private IndexerSearchRepository indexerSearchRepository;
    @Autowired
    private IndexerUniquenessScoreEntityRepository indexerUniquenessScoreEntityRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private TransactionTemplate transactionTemplate;

    @PostConstruct
    public void init() {
        this.transactionTemplate = new TransactionTemplate(this.transactionManager);
    }

    @EventListener
    public void onNzbDownloadEvent(FileDownloadEvent downloadEvent) {
        if (!this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
            logger.debug("Not saving uniqueness score because no history is kept");
            return;
        }
        this.transactionTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleDownloadEvent(FileDownloadEvent downloadEvent) {
        try {
            SearchResultEntity searchResultEntity = downloadEvent.getSearchResultEntity();
            if (searchResultEntity.getIndexerSearchEntityId() == null) {
                logger.debug("Unable to determine indexer uniqueness score for result {} because no indexer search is saved", (Object)searchResultEntity.getTitle());
                return;
            }
            IndexerSearchEntity indexerSearchEntity = (IndexerSearchEntity)this.indexerSearchRepository.getReferenceById((Object)searchResultEntity.getIndexerSearchEntityId());
            Set allIndexerSearchesInvolved = this.getIndexersInvolved(indexerSearchEntity);
            Set indexersContainingSameResult = this.getIndexersFoundSameResult(searchResultEntity, indexerSearchEntity);
            Set involvedIndexersWithoutResult = allIndexerSearchesInvolved.stream().filter(x -> !indexersContainingSameResult.contains(x.getIndexerEntity()) && !x.getIndexerEntity().equals((Object)searchResultEntity.getIndexer())).collect(Collectors.toSet());
            this.saveScoresToDatabase(searchResultEntity.getIndexer(), indexersContainingSameResult, allIndexerSearchesInvolved, involvedIndexersWithoutResult);
            String indexerNamesWithResult = indexersContainingSameResult.stream().map(IndexerEntity::getName).collect(Collectors.joining(", "));
            String indexerNamesWithoutResult = involvedIndexersWithoutResult.stream().map(x -> x.getIndexerEntity().getName()).collect(Collectors.joining(", "));
            if (indexerNamesWithoutResult.isEmpty()) {
                indexerNamesWithoutResult = "<None>";
            }
            if (indexersContainingSameResult.isEmpty()) {
                logger.info("Title: \"{}\". Downloaded unique result from: {}. All other indexers without result: {}", new Object[]{searchResultEntity.getTitle(), searchResultEntity.getIndexer().getName(), indexerNamesWithoutResult});
            } else {
                logger.info("Title: \"{}\". Downloaded from: {}. Indexers with same result: {}. Indexers without result: {}", new Object[]{searchResultEntity.getTitle(), searchResultEntity.getIndexer().getName(), indexerNamesWithResult, indexerNamesWithoutResult});
            }
        }
        catch (Exception e) {
            logger.error("Error while saving data for uniqueness scores", (Throwable)e);
        }
    }

    private void saveScoresToDatabase(IndexerEntity indexerDownloadedFrom, Set<IndexerEntity> indexersContainingSameResult, Set<IndexerSearchEntity> allIndexerSearchesInvolved, Set<IndexerSearchEntity> involvedIndexersWithoutResult) {
        ArrayList<IndexerUniquenessScoreEntity> scoreEntities = new ArrayList<IndexerUniquenessScoreEntity>();
        int involved = allIndexerSearchesInvolved.size();
        int haveResult = indexersContainingSameResult.size() + 1;
        scoreEntities.add(new IndexerUniquenessScoreEntity(indexerDownloadedFrom, involved, haveResult, true));
        scoreEntities.addAll(indexersContainingSameResult.stream().map(x -> new IndexerUniquenessScoreEntity(x, involved, haveResult, true)).toList());
        scoreEntities.addAll(involvedIndexersWithoutResult.stream().map(x -> new IndexerUniquenessScoreEntity(x.getIndexerEntity(), involved, haveResult, false)).toList());
        this.indexerUniquenessScoreEntityRepository.saveAll(scoreEntities);
    }

    private Set<IndexerSearchEntity> getIndexersInvolved(IndexerSearchEntity indexerSearchEntity) {
        return new HashSet(this.indexerSearchRepository.findBySearchEntity(indexerSearchEntity.getSearchEntity())).stream().filter(IndexerSearchEntity::getSuccessful).collect(Collectors.toSet());
    }

    private Set<IndexerEntity> getIndexersFoundSameResult(SearchResultEntity searchResultEntity, IndexerSearchEntity indexerSearchEntity) {
        Set resultsWithSameTitle = this.searchResultRepository.findAllByTitleLikeIgnoreCase(searchResultEntity.getTitle().replaceAll("[ .\\-_]", "_"));
        HashSet<IndexerEntity> indexersContainingSameResult = new HashSet<IndexerEntity>();
        for (SearchResultEntity searchResult : resultsWithSameTitle) {
            if (searchResult.getIndexer().equals((Object)searchResultEntity.getIndexer()) || indexerSearchEntity != null && !indexerSearchEntity.getSuccessful().booleanValue()) continue;
            indexersContainingSameResult.add(searchResult.getIndexer());
        }
        return indexersContainingSameResult;
    }
}

