/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.downloaders;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.downloading.downloaders.Downloader;
import org.nzbhydra.downloading.downloaders.DownloaderProvider;
import org.nzbhydra.downloading.downloaders.DownloaderStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DownloaderStatusRetrieval {
    private static final Logger logger = LoggerFactory.getLogger(DownloaderStatusRetrieval.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private DownloaderProvider downloaderProvider;

    public DownloaderStatus getStatus() {
        DownloaderStatus status;
        Collection allDownloaders = this.downloaderProvider.getAllDownloaders();
        List<Downloader> enabledDownloaders = allDownloaders.stream().filter(Downloader::isEnabled).toList();
        if (enabledDownloaders.isEmpty()) {
            return new DownloaderStatus();
        }
        Optional<Downloader> downloader = enabledDownloaders.stream().filter(x -> enabledDownloaders.size() == 1 || x.getName().equals(this.configProvider.getBaseConfig().getDownloading().getPrimaryDownloader())).findFirst();
        if (downloader.isEmpty()) {
            logger.error("Unable to determine to choose downloader for which to retrieve status.");
            return new DownloaderStatus();
        }
        try {
            status = downloader.get().getStatus();
            status.setUrl(this.configProvider.getBaseConfig().getDownloading().getExternalUrl().orElse(downloader.get().getUrl()));
        }
        catch (Exception e) {
            logger.error("Error while retrieving downloader status", (Throwable)e);
            status = DownloaderStatus.builder().state(DownloaderStatus.State.OFFLINE).build();
        }
        return status;
    }
}

