/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.downloaders;

import java.security.Principal;
import java.util.List;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.downloading.DownloaderConfig;
import org.nzbhydra.downloading.AddFilesRequest;
import org.nzbhydra.downloading.downloaders.AddNzbsResponse;
import org.nzbhydra.downloading.downloaders.Downloader;
import org.nzbhydra.downloading.downloaders.DownloaderProvider;
import org.nzbhydra.downloading.downloaders.DownloaderStatus;
import org.nzbhydra.downloading.downloaders.DownloaderStatusRetrieval;
import org.nzbhydra.searching.DemoDataProvider;
import org.nzbhydra.searching.DemoModeWeb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DownloaderWeb {
    private static final Logger logger = LoggerFactory.getLogger(DownloaderWeb.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private DownloaderProvider downloaderProvider;
    @Autowired
    private DownloaderStatusRetrieval downloaderStatusRetrieval;
    @Autowired
    private DemoDataProvider demoDataProvider;

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/downloader/checkConnection"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public GenericResponse checkConnection(@RequestBody DownloaderConfig downloaderConfig) {
        return this.downloaderProvider.checkConnection(downloaderConfig);
    }

    @Secured(value={"ROLE_STATS"})
    @RequestMapping(value={"/internalapi/downloader/getStatus"}, method={RequestMethod.GET}, produces={"application/json"})
    public DownloaderStatus getStatus() {
        return this.downloaderStatusRetrieval.getStatus();
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/downloader/addNzbs"}, method={RequestMethod.PUT}, produces={"application/json"})
    public AddNzbsResponse addNzb(@RequestBody AddFilesRequest addNzbsRequest, Principal principal) {
        if (DemoModeWeb.isDemoModeActive((Principal)principal)) {
            logger.info("Demo mode active, returning mock download response");
            return this.demoDataProvider.generateDownloadResponse(addNzbsRequest);
        }
        Downloader downloader = this.downloaderProvider.getDownloaderByName(addNzbsRequest.getDownloaderName());
        return downloader.addBySearchResultIds(addNzbsRequest.getSearchResults(), addNzbsRequest.getCategory());
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/downloader/{downloaderName}/categories"}, produces={"application/json"})
    public List<String> getCategories(@PathVariable(value="downloaderName") String downloaderName, Principal principal) {
        if (DemoModeWeb.isDemoModeActive((Principal)principal)) {
            logger.info("Demo mode active, returning mock downloader categories");
            return this.demoDataProvider.generateDownloaderCategories();
        }
        Downloader downloader = this.downloaderProvider.getDownloaderByName(downloaderName);
        return downloader.getCategories();
    }
}

