/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.downloaders.nzbget;

import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.downloading.DownloaderConfig;
import org.nzbhydra.downloading.FileDownloadStatus;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.IndexerSpecificDownloadExceptions;
import org.nzbhydra.downloading.downloaders.Downloader;
import org.nzbhydra.downloading.downloaders.DownloaderEntry;
import org.nzbhydra.downloading.downloaders.DownloaderStatus;
import org.nzbhydra.downloading.downloadurls.DownloadUrlBuilder;
import org.nzbhydra.downloading.exceptions.DownloaderException;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.nzbhydra.webaccess.Ssl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.util.UriComponentsBuilder;

public class NzbGet
extends Downloader {
    private static final Map<String, FileDownloadStatus> NZBGET_STATUS_TO_HYDRA_STATUS = new HashMap();
    private final Ssl ssl;
    private static final Logger logger;
    private JsonRpcHttpClient client;
    private Instant lastErrorLogged;

    public NzbGet(FileHandler nzbHandler, SearchResultRepository searchResultRepository, ApplicationEventPublisher applicationEventPublisher, IndexerSpecificDownloadExceptions indexerSpecificDownloadExceptions, ConfigProvider configProvider, Ssl ssl, DownloadUrlBuilder downloadUrlBuilder) {
        super(nzbHandler, searchResultRepository, applicationEventPublisher, indexerSpecificDownloadExceptions, configProvider, downloadUrlBuilder);
        this.ssl = ssl;
    }

    public void initialize(DownloaderConfig downloaderConfig) {
        super.initialize(downloaderConfig);
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)downloaderConfig.getUrl());
            builder.path("jsonrpc");
            HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
            if (downloaderConfig.getUsername().isPresent() && downloaderConfig.getPassword().isPresent()) {
                headers.put("Authorization", (CallSite)((Object)("Basic " + BaseEncoding.base64().encode(((String)downloaderConfig.getUsername().get() + ":" + (String)downloaderConfig.getPassword().get()).getBytes()))));
            }
            this.client = new JsonRpcHttpClient(builder.build().toUri().toURL(), headers);
            String host = builder.build().getHost();
            Ssl.SslVerificationState verificationState = this.ssl.getVerificationStateForHost(host);
            if (verificationState == Ssl.SslVerificationState.ENABLED) {
                this.client.setSslContext(this.ssl.getCaCertsContext());
            } else {
                this.client.setSslContext(this.ssl.getAllTrustingSslContext());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to create URL from configuration: " + e.getMessage());
        }
    }

    public GenericResponse checkConnection() {
        logger.debug("Checking connection");
        try {
            boolean successful = (Boolean)this.client.invoke("writelog", (Object)new Object[]{"INFO", "NZBHydra 2 connected to test connection"}, Boolean.class);
            logger.info("Connection check to NZBGet using URL {} successful", (Object)this.downloaderConfig.getUrl());
            return new GenericResponse(successful, null);
        }
        catch (Throwable e) {
            String message = e.getMessage();
            if (e.getMessage() != null && e.getMessage().contains("Caught error with no response body") && e.getCause() != null && !Strings.isNullOrEmpty((String)e.getCause().getMessage())) {
                message = e.getCause().getMessage();
            }
            logger.error("Connection check to NZBGet using URL {} failed: {}", (Object)this.downloaderConfig.getUrl(), (Object)message);
            return new GenericResponse(false, message);
        }
    }

    public List<String> getCategories() {
        logger.debug("Loading list of categories");
        List<String> categories = new ArrayList<String>();
        try {
            ArrayList config = this.callNzbget("config", null);
            categories = config.stream().filter(pair -> pair.containsKey("Name") && pair.get("Name").toString().contains("Category") && pair.get("Name").toString().contains("Name")).map(pair -> pair.get("Value").toString()).collect(Collectors.toList());
        }
        catch (DownloaderException throwable) {
            logger.error("Error while trying to get categories from NZBGet: {}", (Object)throwable.getMessage());
        }
        return categories;
    }

    public String addLink(String link, String title, DownloadType downloadType, String category) throws DownloaderException {
        logger.debug("Adding link for {} to NZB with category {}", (Object)title, (Object)category);
        try {
            return this.callAppend(link, title, category);
        }
        catch (Throwable throwable) {
            logger.error("Error while trying to add link {} for NZB \"{}\" to NZBGet queue: {}", new Object[]{link, title, throwable.getMessage()});
            if (throwable.getMessage() != null) {
                throw new DownloaderException("Error while adding link to NZBGet: " + throwable.getMessage());
            }
            throw new DownloaderException("Unknown error while adding link to NZBGet");
        }
    }

    public String addContent(byte[] content, String title, DownloadType downloadType, String category) throws DownloaderException {
        logger.debug("Adding NZB for {} to NZB with category {}", (Object)title, (Object)category);
        try {
            return this.callAppend(BaseEncoding.base64().encode(content), title, category);
        }
        catch (Throwable throwable) {
            logger.info("Error while trying to add link {} for NZB \"{}\" to NZBGet queue: {}", new Object[]{content, title, throwable.getMessage()});
            if (throwable.getMessage() != null) {
                throw new DownloaderException("Error while adding NZB to NZBGet: " + throwable.getMessage());
            }
            throw new DownloaderException("Unknown error while adding NZB to NZBGet");
        }
    }

    public DownloaderStatus getStatus() throws DownloaderException {
        LinkedHashMap statusMap;
        try {
            statusMap = (LinkedHashMap)this.client.invoke("status", (Object)new Object[0], LinkedHashMap.class);
            this.lastErrorLogged = null;
        }
        catch (Throwable e) {
            if (this.lastErrorLogged == null || this.lastErrorLogged.isBefore(Instant.now().minus(10L, ChronoUnit.MINUTES))) {
                logger.error("Error contacting NZBGet", e);
                this.lastErrorLogged = Instant.now();
            }
            DownloaderStatus status = new DownloaderStatus();
            status.setState(DownloaderStatus.State.OFFLINE);
            this.addDownloadRate(0L);
            return status;
        }
        DownloaderStatus status = this.getStatusFromMap(statusMap);
        this.fillStatusFromQueue(status);
        return status;
    }

    protected void fillStatusFromQueue(DownloaderStatus status) throws DownloaderException {
        ArrayList queue = this.callNzbget("listgroups", new Object[]{0});
        List<LinkedHashMap> nzbs = queue.stream().filter(x -> "NZB".equals(x.get("Kind"))).toList();
        if (!nzbs.isEmpty()) {
            Optional<LinkedHashMap> downloadingEntry;
            status.setElementsInQueue(queue.size());
            if (!queue.isEmpty() && (downloadingEntry = queue.stream().filter(x -> ((String)x.get("Status")).equals("DOWNLOADING")).findFirst()).isPresent()) {
                LinkedHashMap map = downloadingEntry.get();
                status.setDownloadingTitle((String)map.get("NZBName"));
                int totalMb = (Integer)map.get("FileSizeMB") - (Integer)map.get("PausedSizeMB");
                int remainingMb = (Integer)map.get("RemainingSizeMB") - (Integer)map.get("PausedSizeMB");
                if (totalMb == 0) {
                    status.setDownloadingTitlePercentFinished(0);
                } else {
                    status.setDownloadingTitlePercentFinished(Math.round((float)(totalMb - remainingMb) / (float)totalMb * 100.0f));
                }
                if (status.getState() == DownloaderStatus.State.DOWNLOADING && status.getDownloadRateInKilobytes() > 0L) {
                    status.setDownloadingTitleRemainingTimeSeconds((long)this.calculateSecondsLeft(remainingMb, status.getDownloadRateInKilobytes() * 1024L));
                }
            }
        }
    }

    private int calculateSecondsLeft(int remainingMb, long downloadRateBytesPerSecond) {
        return (int)((float)remainingMb * 1024.0f / ((float)downloadRateBytesPerSecond / 1024.0f));
    }

    private DownloaderStatus getStatusFromMap(LinkedHashMap<String, Object> statusMap) {
        DownloaderStatus status = new DownloaderStatus();
        status.setDownloaderName(this.downloaderConfig.getName());
        status.setDownloaderType(this.downloaderConfig.getDownloaderType());
        int remainingSizeMB = (Integer)statusMap.get("RemainingSizeMB") - (Integer)statusMap.getOrDefault("PausedSizeMB", 0);
        status.setRemainingSizeInMegaBytes((long)remainingSizeMB);
        Integer downloadRateInBytes = (Integer)statusMap.get("DownloadRate");
        int downloadRateInKilobytes = downloadRateInBytes / 1024;
        status.setDownloadRateInKilobytes((long)downloadRateInKilobytes);
        this.addDownloadRate((long)downloadRateInKilobytes);
        status.setDownloadingRatesInKilobytes(this.downloadRates);
        Boolean downloadPaused = (Boolean)statusMap.get("DownloadPaused");
        if (downloadPaused.booleanValue()) {
            status.setState(DownloaderStatus.State.PAUSED);
        } else if (remainingSizeMB > 0) {
            status.setState(DownloaderStatus.State.DOWNLOADING);
        } else {
            status.setState(DownloaderStatus.State.IDLE);
        }
        if (downloadRateInBytes > 0) {
            int mb = downloadPaused != false ? ((Integer)statusMap.get("ForcedSizeMB")).intValue() : ((Integer)statusMap.get("RemainingSizeMB")).intValue();
            status.setRemainingSeconds((long)((float)mb * 1024.0f / ((float)downloadRateInBytes.intValue() / 1024.0f)));
        }
        return status;
    }

    protected FileDownloadStatus getDownloadStatusFromDownloaderEntry(DownloaderEntry entry, Downloader.StatusCheckType statusCheckType) {
        if (statusCheckType == Downloader.StatusCheckType.QUEUE) {
            return FileDownloadStatus.NZB_ADDED;
        }
        return (FileDownloadStatus)NZBGET_STATUS_TO_HYDRA_STATUS.get(entry.getStatus());
    }

    public List<DownloaderEntry> getHistory(Instant earliestDownloadTime) throws DownloaderException {
        ArrayList history = this.callNzbget("history", new Object[]{true});
        ArrayList<DownloaderEntry> historyEntries = new ArrayList<DownloaderEntry>();
        for (LinkedHashMap map : history) {
            if (!map.get("Kind").equals("NZB") && !map.get("Kind").equals("DUP")) continue;
            DownloaderEntry historyEntry = this.getBasicDownloaderEntry(map);
            historyEntry.setTime(Instant.ofEpochSecond(((Integer)map.get("HistoryTime")).intValue()));
            if (historyEntry.getTime().isBefore(earliestDownloadTime)) {
                logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Stopping transforming history entries because the current history entry is from {} which is before earliest download to check which is from {}", (Object)historyEntry.getTime(), (Object)earliestDownloadTime);
                return historyEntries;
            }
            historyEntries.add(historyEntry);
        }
        return historyEntries;
    }

    public List<DownloaderEntry> getQueue(Instant earliestDownload) throws DownloaderException {
        ArrayList queue = this.callNzbget("listgroups", new Object[]{0});
        ArrayList<DownloaderEntry> queueEntries = new ArrayList<DownloaderEntry>();
        for (LinkedHashMap map : queue) {
            if (!map.get("Kind").equals("NZB")) continue;
            DownloaderEntry entry = this.getBasicDownloaderEntry(map);
            queueEntries.add(entry);
        }
        return queueEntries;
    }

    protected ArrayList<LinkedHashMap<String, Object>> callNzbget(String listgroups, Object[] argument) throws DownloaderException {
        try {
            return (ArrayList)this.client.invoke(listgroups, (Object)argument, ArrayList.class);
        }
        catch (Throwable e) {
            throw new DownloaderException("Error while calling NZBGet", e);
        }
    }

    protected DownloaderEntry getBasicDownloaderEntry(LinkedHashMap<String, Object> map) {
        DownloaderEntry entry = new DownloaderEntry();
        entry.setNzbId(String.valueOf(map.get("NZBID")));
        if (map.get("Kind").equals("DUP")) {
            entry.setNzbName((String)map.get("Name"));
        } else {
            entry.setNzbName((String)map.get("NZBName"));
        }
        entry.setStatus((String)map.get("Status"));
        return entry;
    }

    private String callAppend(String contentOrLink, String title, String category) throws Throwable {
        Object nzbName = title;
        if (!((String)nzbName).toLowerCase().endsWith(".nzb")) {
            nzbName = (String)nzbName + ".nzb";
        }
        category = category == null ? "" : category;
        boolean priority = false;
        boolean addToTop = false;
        boolean addPaused = this.downloaderConfig.isAddPaused();
        String dupeKey = "";
        boolean dupeScore = false;
        Object[] arguments = new Object[]{nzbName, contentOrLink, category, 0, false, addPaused, "", 0, "SCORE", new Object[0]};
        int nzbId = (Integer)this.client.invoke("append", (Object)arguments, Integer.class);
        if (nzbId <= 0) {
            throw new DownloaderException("NZBGet returned error code. Check its logs");
        }
        logger.info("Successfully added NZB \"{}\" to NZBGet queue with ID {} in category \"{}\"", new Object[]{title, nzbId, category});
        return String.valueOf(nzbId);
    }

    static {
        NZBGET_STATUS_TO_HYDRA_STATUS.put("SUCCESS/ALL", FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("SUCCESS/UNPACK", FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("SUCCESS/PAR", FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("SUCCESS/HEALTH", FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("SUCCESS/GOOD", FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("SUCCESS/MARK", FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("SUCCESS/HIDDEN", FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("FAILURE/MOVE", FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("WARNING/SCRIPT", FileDownloadStatus.CONTENT_DOWNLOAD_WARNING);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("WARNING/SPACE", FileDownloadStatus.CONTENT_DOWNLOAD_WARNING);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("WARNING/HEALTH", FileDownloadStatus.CONTENT_DOWNLOAD_WARNING);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("WARNING/PASSWORD", FileDownloadStatus.CONTENT_DOWNLOAD_WARNING);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("WARNING/DAMAGED", FileDownloadStatus.CONTENT_DOWNLOAD_WARNING);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("WARNING/REPAIRABLE", FileDownloadStatus.CONTENT_DOWNLOAD_WARNING);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("FAILURE/PAR", FileDownloadStatus.CONTENT_DOWNLOAD_ERROR);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("FAILURE/UNPACK", FileDownloadStatus.CONTENT_DOWNLOAD_ERROR);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("FAILURE/HEALTH", FileDownloadStatus.CONTENT_DOWNLOAD_ERROR);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("FAILURE/BAD", FileDownloadStatus.CONTENT_DOWNLOAD_ERROR);
        NZBGET_STATUS_TO_HYDRA_STATUS.put("FAILURE/SCAN", FileDownloadStatus.NZB_ADD_REJECTED);
        logger = LoggerFactory.getLogger(NzbGet.class);
    }
}

