/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.downloaders.torbox;

import jakarta.annotation.Nullable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.downloading.NzbAddingType;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.downloading.DownloaderType;
import org.nzbhydra.downloading.FileDownloadStatus;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.IndexerSpecificDownloadExceptions;
import org.nzbhydra.downloading.downloaders.Downloader;
import org.nzbhydra.downloading.downloaders.DownloaderEntry;
import org.nzbhydra.downloading.downloaders.DownloaderStatus;
import org.nzbhydra.downloading.downloaders.torbox.Torbox;
import org.nzbhydra.downloading.downloaders.torbox.TorboxHttpRequestFactory;
import org.nzbhydra.downloading.downloaders.torbox.mapping.AddUDlResponse;
import org.nzbhydra.downloading.downloaders.torbox.mapping.TorboxDownload;
import org.nzbhydra.downloading.downloaders.torbox.mapping.UsenetListResponse;
import org.nzbhydra.downloading.downloadurls.DownloadUrlBuilder;
import org.nzbhydra.downloading.exceptions.DownloaderException;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.nzbhydra.webaccess.HydraOkHttp3ClientHttpRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="torboxdownloader")
public class Torbox
extends Downloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Torbox.class);
    private static final String HOST = "torbox.app";
    private static final String BASE_URL = "https://torbox.app";
    private static final String BASE_API_URL = "https://api.torbox.app/v1/api";
    public static final Duration CACHE_TIME = Duration.ofSeconds(5L);
    private final RestTemplate restTemplate;
    private Instant lastUpdate = Instant.MIN;
    private final List<TorboxDownload> lastTorboxDownloads = new ArrayList();

    public Torbox(FileHandler nzbHandler, SearchResultRepository searchResultRepository, ApplicationEventPublisher applicationEventPublisher, IndexerSpecificDownloadExceptions indexerSpecificDownloadExceptions, ConfigProvider configProvider, HydraOkHttp3ClientHttpRequestFactory requestFactory, DownloadUrlBuilder downloadUrlBuilder, TorboxHttpRequestFactory torboxHttpRequestFactory) {
        super(nzbHandler, searchResultRepository, applicationEventPublisher, indexerSpecificDownloadExceptions, configProvider, downloadUrlBuilder);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)torboxHttpRequestFactory);
        this.restTemplate.getInterceptors().add((request, body, execution) -> {
            request.getHeaders().add("Authorization", "Bearer " + this.downloaderConfig.getApiKey());
            return execution.execute(request, body);
        });
    }

    public GenericResponse checkConnection() {
        log.debug("Checking connection");
        UriComponentsBuilder url = this.getBaseUrl().path("/user/me");
        try {
            ResponseEntity response = this.restTemplate.getForEntity(this.getBaseUrl().path("/user/me").toUriString(), String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("Connection check with torbox using URL {} successful", (Object)url.toUriString());
                return new GenericResponse(true, null);
            }
            log.error("Connection check with torbox using URL {} failed. Response code: {}. Response body:\n{}", new Object[]{url, response.getStatusCode(), response.getBody()});
            return new GenericResponse(false, null);
        }
        catch (RestClientException e) {
            log.info("Connection check with torbox using URL {} failed: {}", (Object)url.toUriString(), (Object)e.getMessage());
            return new GenericResponse(false, e.getMessage());
        }
    }

    private Request.Builder getRequestBuilder(UriComponentsBuilder uriComponentsBuilder) {
        return new Request.Builder().url(uriComponentsBuilder.toUriString()).header("Authorization", "Bearer " + this.downloaderConfig.getApiKey());
    }

    public List<String> getCategories() {
        return List.of();
    }

    public String addLink(String link, String title, DownloadType downloadType, String category) throws DownloaderException {
        return this.sendAddRequest(link.getBytes(StandardCharsets.UTF_8), title, "link", "link", downloadType);
    }

    public String addContent(byte[] content, String title, DownloadType downloadType, String category) throws DownloaderException {
        return this.sendAddRequest(content, title, "file", "data", downloadType);
    }

    private String sendAddRequest(byte[] value, String title, String addType, String descInLog, DownloadType downloadType) throws DownloaderException {
        log.debug("Sending {} for \"{}\" to torbox", (Object)descInLog, (Object)title);
        ResultType resultType = Torbox.determineResultType((byte[])value, (String)title, (DownloadType)downloadType);
        UriComponentsBuilder url = switch (2.$SwitchMap$org$nzbhydra$downloading$downloaders$torbox$Torbox$ResultType[resultType.ordinal()]) {
            case 1, 2 -> this.getBaseUrl().path("/usenet/createusenetdownload");
            case 3, 4, 5 -> this.getBaseUrl().path("/torrents/createtorrent");
            default -> throw new IllegalStateException("Unexpected result type " + String.valueOf(resultType));
        };
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        if (addType.equals("file") && resultType != ResultType.MAGNET) {
            1 fileResource = new /* Unavailable Anonymous Inner Class!! */;
            map.add((Object)"file", (Object)fileResource);
        } else {
            if (resultType == ResultType.MAGNET || "link".equals(addType) && new String(value).startsWith("magnet")) {
                map.add((Object)"magnet", (Object)URLDecoder.decode(new String(value), StandardCharsets.UTF_8));
            } else {
                map.add((Object)addType, (Object)value);
            }
            map.add((Object)"name", (Object)title);
        }
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            ResponseEntity entity = this.restTemplate.postForEntity(url.toUriString(), (Object)request, AddUDlResponse.class, new Object[0]);
            AddUDlResponse dlResponse = (AddUDlResponse)entity.getBody();
            if (dlResponse.isSuccess()) {
                log.info("Successfully added \"{}\" to torbox", (Object)title);
                return dlResponse.getData().getUsenetdownload_id();
            }
            log.error("Error adding {} for NZB {} to torbox. Error: {}\nDetail:{}", new Object[]{descInLog, title, dlResponse.getError(), dlResponse.getDetail()});
            throw new DownloaderException("Torbox returned error: " + dlResponse.getError());
        }
        catch (Exception e) {
            log.error("Unexpected response when sending add request for {} to torbox", (Object)title, (Object)e);
            throw new DownloaderException("Error sending " + descInLog + " to torbox", (Throwable)e);
        }
    }

    private static ResultType determineResultType(byte[] value, String title, DownloadType downloadType) throws DownloaderException {
        ResultType resultType;
        String valueString = new String(value);
        if (downloadType == DownloadType.TORRENT) {
            resultType = ResultType.TORRENT;
        } else if (downloadType == DownloadType.NZB) {
            resultType = ResultType.NZB;
        } else if (valueString.contains("usenet/download")) {
            resultType = ResultType.TORBOX_USENET;
        } else if (valueString.startsWith("magnet:")) {
            resultType = ResultType.MAGNET;
        } else {
            throw new DownloaderException("Unable to determine type of download for " + title + " from type " + String.valueOf(downloadType) + " and content " + valueString);
        }
        return resultType;
    }

    public DownloaderStatus getStatus() throws DownloaderException {
        List<TorboxDownload> downloadingEntries = this.getLastTorboxDownloads().stream().filter(x -> "downloading".equals(x.getDownloadState())).toList();
        long downloadSpeedKb = downloadingEntries.stream().mapToLong(TorboxDownload::getDownloadSpeedBytes).sum() / 1024L;
        this.addDownloadRate(downloadSpeedKb);
        DownloaderStatus.DownloaderStatusBuilder statusBuilder = DownloaderStatus.builder().downloaderName("Torbox").downloaderType(DownloaderType.TORBOX).state(downloadingEntries.isEmpty() ? DownloaderStatus.State.IDLE : DownloaderStatus.State.DOWNLOADING).url("https://torbox.app").downloadingRatesInKilobytes(this.downloadRates).downloadRateInKilobytes(downloadSpeedKb).elementsInQueue(downloadingEntries.size());
        if (!downloadingEntries.isEmpty()) {
            double etaSeconds = downloadingEntries.stream().mapToLong(TorboxDownload::getEta).average().orElse(0.0);
            long remainingMegaBytes = downloadingEntries.stream().mapToLong(TorboxDownload::getSize).sum() / 1024L / 1024L;
            TorboxDownload torboxDownload = downloadingEntries.get(0);
            statusBuilder = statusBuilder.remainingSeconds((long)etaSeconds).remainingSizeInMegaBytes(remainingMegaBytes).downloadingTitle(torboxDownload.getName()).downloadingTitlePercentFinished((int)(100.0 * torboxDownload.getProgress())).downloadingTitleRemainingSizeKilobytes(torboxDownload.getSize() / 1024L).downloadingTitleRemainingTimeSeconds((long)torboxDownload.getEta());
        }
        return statusBuilder.build();
    }

    public List<DownloaderEntry> getHistory(Instant earliestDownload) throws DownloaderException {
        return this.getDownloaderEntries().stream().filter(x -> "failed".equals(x.getStatus()) || "completed".equals(x.getStatus()) || "cached".equals(x.getStatus())).toList();
    }

    public List<DownloaderEntry> getQueue(@Nullable Instant earliestDownload) throws DownloaderException {
        return this.getDownloaderEntries().stream().filter(x -> !"failed".equals(x.getStatus()) && !"completed".equals(x.getStatus()) && !"cached".equals(x.getStatus())).toList();
    }

    @NotNull
    private List<DownloaderEntry> getDownloaderEntries() throws DownloaderException {
        return this.getLastTorboxDownloads().stream().map(entry -> DownloaderEntry.builder().nzbId(String.valueOf(entry.getId())).nzbName(entry.getName()).time(entry.getCreated_at()).status(entry.getDownloadState()).build()).toList();
    }

    protected NzbAddingType getNzbAddingType(DownloadType downloadType, SearchResultEntity searchResult) {
        IndexerConfig indexer = this.configProvider.getIndexerByName(searchResult.getIndexer().getName());
        if (downloadType == DownloadType.TORBOX || downloadType == DownloadType.TORRENT || indexer.getSearchModuleType() == SearchModuleType.TORBOX || indexer.getHost().contains("torbox.app")) {
            return NzbAddingType.SEND_LINK;
        }
        return NzbAddingType.UPLOAD;
    }

    private List<TorboxDownload> getLastTorboxDownloads() throws DownloaderException {
        if (this.lastUpdate.isAfter(Instant.now().minus(CACHE_TIME))) {
            return this.lastTorboxDownloads;
        }
        UriComponentsBuilder url = this.getBaseUrl().path("/usenet/mylist").queryParam("bypass_cache", new Object[]{true});
        try {
            ResponseEntity response = this.restTemplate.getForEntity(url.toUriString(), UsenetListResponse.class, new Object[0]);
            UsenetListResponse body = (UsenetListResponse)response.getBody();
            if (response.getStatusCode().is2xxSuccessful()) {
                this.lastUpdate = Instant.now();
                this.lastTorboxDownloads.clear();
                this.lastTorboxDownloads.addAll(body.getData());
                return this.lastTorboxDownloads;
            }
            log.error("Loading usenet list from torbox failed. Error: {}. Details:\n{}", (Object)body.getError(), (Object)body.getDetail());
            throw new DownloaderException("Error loading usenet list from torbox. Error: " + body.getError());
        }
        catch (RestClientException e) {
            throw new DownloaderException("Error loading usenet list from torbox", (Throwable)e);
        }
    }

    protected FileDownloadStatus getDownloadStatusFromDownloaderEntry(DownloaderEntry entry, Downloader.StatusCheckType statusCheckType) {
        if (entry.getStatus() == null) {
            return FileDownloadStatus.NONE;
        }
        switch (entry.getStatus()) {
            case "completed": 
            case "cached": {
                return FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL;
            }
            case "failed": {
                return FileDownloadStatus.CONTENT_DOWNLOAD_ERROR;
            }
            case "downloading": {
                return FileDownloadStatus.NZB_ADDED;
            }
        }
        return FileDownloadStatus.NONE;
    }

    private UriComponentsBuilder getBaseUrl() {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)"https://api.torbox.app/v1/api");
        return builder;
    }

    static /* synthetic */ String access$000(Torbox x0, String x1) {
        return x0.suffixNzbToTitle(x1);
    }
}

