/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.downloadurls;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.HistoryUserInfoType;
import org.nzbhydra.config.MainConfig;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.downloading.downloadurls.DownloadLink;
import org.nzbhydra.downloading.downloadurls.DownloadUrlBuilderStrategy;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.web.SessionStorage;
import org.nzbhydra.web.UrlCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class DownloadUrlBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadUrlBuilder.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private UrlCalculator urlCalculator;
    @Autowired
    private List<DownloadUrlBuilderStrategy> downloadUrlBuilderStrategies = new ArrayList();

    public DownloadLink getDownloadLinkForSendingToDownloader(SearchResultEntity searchResult, boolean internal) {
        UriComponentsBuilder builder;
        Optional<DownloadLink> specialUrl = this.downloadUrlBuilderStrategies.stream().map(x -> x.getDownloadLinkForSendingToDownloader(searchResult, internal, searchResult.getDownloadType())).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (specialUrl.isPresent()) {
            return specialUrl.get();
        }
        Optional externalUrl = this.configProvider.getBaseConfig().getDownloading().getExternalUrl();
        if (externalUrl.isPresent()) {
            log.debug(LoggingMarkers.URL_CALCULATION, "Using configured external URL: {}", externalUrl.get());
            builder = UriComponentsBuilder.fromHttpUrl((String)((String)externalUrl.get()));
        } else {
            builder = this.urlCalculator.getRequestBasedUriBuilder();
            log.debug(LoggingMarkers.URL_CALCULATION, "Using URL calculated from request: {}", (Object)builder.toUriString());
        }
        return new DownloadLink(this.getDownloadLink(Long.valueOf(searchResult.getId()), internal, searchResult.getDownloadType(), builder), true);
    }

    public String getDownloadLinkForResults(Long searchResultId, boolean internal, DownloadType downloadType) {
        UriComponentsBuilder builder = this.urlCalculator.getRequestBasedUriBuilder();
        log.debug(LoggingMarkers.URL_CALCULATION, "Using URL calculated from request: {}", (Object)builder.toUriString());
        return this.getDownloadLink(searchResultId, internal, downloadType, builder);
    }

    private String getDownloadLink(Long searchResultId, boolean internal, DownloadType downloadType, UriComponentsBuilder builder) {
        String getName;
        String string = getName = downloadType == DownloadType.NZB ? "getnzb" : "gettorrent";
        if (internal) {
            builder.path("/" + getName + "/user");
            builder.path("/" + searchResultId);
        } else {
            MainConfig main = this.configProvider.getBaseConfig().getMain();
            builder.path("/" + getName + "/api");
            builder.path("/" + searchResultId);
            builder.queryParam("apikey", new Object[]{main.getApiKey()});
        }
        HistoryUserInfoType infoType = this.configProvider.getBaseConfig().getMain().getLogging().getHistoryUserInfoType();
        if (infoType.isLogUserInfo() && SessionStorage.username.get() != null) {
            builder.queryParam("username", new Object[]{SessionStorage.username.get()});
        }
        return builder.toUriString();
    }
}

